/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.RBFN;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import keel.Algorithms.Neural_Networks.RBFN.ProcDataset;
import keel.Algorithms.Neural_Networks.RBFN.RBFUtils;
import keel.Algorithms.Neural_Networks.RBFN.Rbfn;
import org.core.Randomize;

public class doRbfn {
    static String trnFile;
    static String tstFile;
    static String outTrnFile;
    static String outTstFile;
    static String outRbfFile;
    static int neurons;
    static double seed;
    static boolean reallySeed;

    private static boolean setParameters(String fileName) {
        Hashtable parametros = RBFUtils.parameters(fileName);
        RBFUtils.setVerbosity(parametros);
        String tmp = (String)((Vector)parametros.get("inputData")).get(0);
        trnFile = tmp.substring(1, tmp.length() - 1);
        tmp = (String)((Vector)parametros.get("inputData")).get(2);
        tstFile = tmp.substring(1, tmp.length() - 1);
        tmp = (String)((Vector)parametros.get("outputData")).get(0);
        outTrnFile = tmp.substring(1, tmp.length() - 1);
        tmp = (String)((Vector)parametros.get("outputData")).get(1);
        outTstFile = tmp.substring(1, tmp.length() - 1);
        tmp = (String)((Vector)parametros.get("outputData")).get(2);
        outRbfFile = tmp.substring(1, tmp.length() - 1);
        neurons = (int)Double.parseDouble((String)((Vector)parametros.get("neurons")).get(0));
        if (parametros.containsKey("seed")) {
            reallySeed = true;
            seed = Double.parseDouble((String)((Vector)parametros.get("seed")).get(0));
        } else {
            reallySeed = false;
        }
        RBFUtils.verboseln("Training file      : " + trnFile);
        RBFUtils.verboseln("Test file          : " + tstFile);
        RBFUtils.verboseln("Ouput Training file: " + outTrnFile);
        RBFUtils.verboseln("Ouput Test file    : " + outTstFile);
        RBFUtils.verboseln("Ouput RBF file     : " + outRbfFile);
        RBFUtils.verboseln("Neurons            : " + neurons);
        RBFUtils.verbose("Seed               : ");
        if (reallySeed) {
            RBFUtils.verboseln("" + seed);
        } else {
            RBFUtils.verboseln("No seed, i.e., pure random execution");
        }
        RBFUtils.verboseln("Verbosity          : " + RBFUtils.getVerbosity());
        return trnFile != "" && tstFile != "" && outTrnFile != "" && outTstFile != "" && neurons > 0;
    }

    private static void doHelp() {
        System.out.println("Usage: doRbf paramFile");
        System.out.println("       doRbf --help");
        System.out.println("       (doRbf can also be RBFN.jar)");
        System.out.println("  Where: ");
        System.out.println("   paramFile  Name of file containing the parameters according to Keel format.");
        System.out.println("              Example of parameter file: ");
        System.out.println("              algorithm = rbfn");
        System.out.println("              neurons = 5");
        System.out.println("              verbose = true");
        System.out.println("              inputData = \"sintetica.trn\" \"sintetica.tst\" ");
        System.out.println("              outputData = \"result1.trn\" \"result1.tst\" \"result1.rbf\" ");
        System.out.println("\n---\nAuthors: Antonio Rivera (arivera@ujaen.es),  \n         Loli P\u00ef\u00bf\u00bdrez (lperez@ujaen.es), \n         V\u00ef\u00bf\u00bdctor Rivas  (vrivas@ujaen.es)\nFrom:    Univ. of Jaen (Spain)\nFor:     Keel Project.\n\n");
    }

    public static void main(String[] args) throws IOException {
        try {
            ProcDataset Dtst;
            Object[] obtained;
            Rbfn net;
            int i;
            Object[] auxY;
            double[][] X;
            double[][] Y;
            int ndata;
            int nOutpl;
            int nInpt;
            ProcDataset Dtrn;
            if (args.length > 0 && (args[0].equals("--help") || args[0].equals("-help") || args[0].equals("-h") || args[0].equals("-?"))) {
                doRbfn.doHelp();
                return;
            }
            System.out.println("- Executing doRbfn " + args.length);
            String paramFile = args.length > 0 ? args[0] : "parametros.txt";
            doRbfn.setParameters(paramFile);
            System.out.println("    - Parameters file: " + paramFile);
            if (reallySeed) {
                Randomize.setSeed((long)seed);
            }
            if ((Dtrn = new ProcDataset(trnFile, true)).datasetType() == 0) {
                System.out.println("Modeling Dataset");
                Dtrn.processModelDataset();
                nInpt = Dtrn.getninputs();
                nOutpl = 1;
                ndata = Dtrn.getndata();
                Y = new double[ndata][1];
                X = Dtrn.getX();
                auxY = Dtrn.getY();
                for (i = 0; i < ndata; ++i) {
                    Y[i][0] = auxY[i];
                }
                net = new Rbfn(X, ndata, nInpt, nOutpl, neurons);
                net.trainLMS(X, Y, ndata, 100, 0.3);
                obtained = new double[ndata];
                net.testModeling(X, ndata, (double[])obtained);
                Dtrn.generateResultsModeling(outTrnFile, (double[])auxY, (double[])obtained);
                Dtst = new ProcDataset(tstFile, false);
                Dtst.processModelDataset();
                nInpt = Dtst.getninputs();
                nOutpl = 1;
                ndata = Dtst.getndata();
                X = Dtst.getX();
                auxY = Dtst.getY();
                Y = new double[ndata][1];
                for (i = 0; i < ndata; ++i) {
                    Y[i][0] = auxY[i];
                }
                obtained = new double[ndata];
                net.testModeling(X, ndata, (double[])obtained);
                Dtst.generateResultsModeling(outTstFile, (double[])auxY, (double[])obtained);
                RBFUtils.createOutputFile("", outRbfFile);
                net.printRbfn(outRbfFile);
            }
            if (Dtrn.datasetType() == 1) {
                System.out.println("Classification Dataset");
                Dtrn.processClassifierDataset();
                nInpt = Dtrn.getninputs();
                nOutpl = 1;
                ndata = Dtrn.getndata();
                Y = new double[ndata][1];
                X = Dtrn.getX();
                auxY = Dtrn.getC();
                for (i = 0; i < ndata; ++i) {
                    Y[i][0] = auxY[i];
                }
                net = new Rbfn(X, ndata, nInpt, nOutpl, neurons);
                net.trainLMS(X, Y, ndata, 100, 0.3);
                obtained = new int[ndata];
                net.testClasification(X, ndata, (int[])obtained, Dtrn.getnclasses() - 1, 0);
                Dtrn.generateResultsModeling(outTrnFile, (int[])auxY, (int[])obtained);
                Dtst = new ProcDataset(tstFile, false);
                Dtst.processClassifierDataset();
                nInpt = Dtst.getninputs();
                nOutpl = 1;
                ndata = Dtst.getndata();
                Y = new double[ndata][1];
                obtained = new int[ndata];
                X = Dtst.getX();
                auxY = Dtst.getC();
                for (i = 0; i < ndata; ++i) {
                    Y[i][0] = auxY[i];
                }
                net.testClasification(X, ndata, (int[])obtained, Dtrn.getnclasses() - 1, 0);
                Dtst.generateResultsClasification(outTstFile, (int[])auxY, (int[])obtained);
                RBFUtils.createOutputFile(trnFile, outRbfFile);
                net.printRbfn(outRbfFile);
            }
            if (Dtrn.datasetType() == 2) {
                System.out.println("Clustering");
            }
            System.out.println("- End of doRbfn. See results in output files named according to " + paramFile + " parameters file.");
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
    }
}

