/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec;

import java.io.File;
import net.sourceforge.jclec.IAlgorithm;
import net.sourceforge.jclec.IConfigure;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;

public class RunExperiment {
    private static final String USAGE_MES = "\tnet.sf.jclec.RunExperiment <experiment file>\t\t(Execute experiment)";

    public static void main(String[] args) {
        long t0 = 0L;
        if (args.length == 0) {
            System.out.println("Usage:");
            RunExperiment.showUsageMessage();
            System.exit(1);
        } else {
            t0 = System.currentTimeMillis();
            System.out.println("Initializing job...");
            RunExperiment.executeJob(args[0]);
            long t1 = System.currentTimeMillis();
            System.out.println("Time " + (t1 - t0));
        }
    }

    private static void showUsageMessage() {
        System.out.println(USAGE_MES);
    }

    private static void executeJob(String jobFilename) {
        File jobFile = new File(jobFilename);
        if (jobFile.exists()) {
            try {
                XMLConfiguration jobConf = new XMLConfiguration(jobFile);
                int numberOfProcesses = jobConf.getList("process[@algorithm-type]").size();
                int i = 0;
                while (i < numberOfProcesses) {
                    String header = "process(" + i + ")";
                    String aname = jobConf.getString(String.valueOf(header) + "[@algorithm-type]");
                    Class<?> aclass = Class.forName(aname);
                    IAlgorithm algorithm = (IAlgorithm)aclass.newInstance();
                    if (algorithm instanceof IConfigure) {
                        ((IConfigure)((Object)algorithm)).configure(jobConf.subset(header));
                    }
                    algorithm.execute();
                    ++i;
                }
            }
            catch (ConfigurationException e) {
                System.out.println("Configuration exception ");
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {}
        } else {
            System.out.println("Job file not found");
            System.exit(1);
        }
    }
}

