/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.RankedOutputSearch;
import weka.attributeSelection.StartSetHandler;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Utils;

public class GreedyStepwise
extends ASSearch
implements RankedOutputSearch,
StartSetHandler,
OptionHandler {
    static final long serialVersionUID = -6312951970168325471L;
    protected boolean m_hasClass;
    protected int m_classIndex;
    protected int m_numAttribs;
    protected boolean m_rankingRequested;
    protected boolean m_doRank;
    protected boolean m_doneRanking = false;
    protected double m_threshold = -1.7976931348623157E308;
    protected int m_numToSelect = -1;
    protected int m_calculatedNumToSelect;
    protected double m_bestMerit;
    protected double[][] m_rankedAtts;
    protected int m_rankedSoFar;
    protected BitSet m_best_group;
    protected ASEvaluation m_ASEval;
    protected Instances m_Instances;
    protected Range m_startRange = new Range();
    protected int[] m_starting = null;
    protected boolean m_backward = false;
    protected boolean m_conservativeSelection = false;

    public GreedyStepwise() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "GreedyStepwise :\n\nPerforms a greedy forward or backward search through the space of attribute subsets. May start with no/all attributes or from an arbitrary point in the space. Stops when the addition/deletion of any remaining attributes results in a decrease in evaluation. Can also produce a ranked list of attributes by traversing the space from one side to the other and recording the order that attributes are selected.\n";
    }

    public String searchBackwardsTipText() {
        return "Search backwards rather than forwards.";
    }

    public void setSearchBackwards(boolean bl) {
        this.m_backward = bl;
        if (this.m_backward) {
            this.setGenerateRanking(false);
        }
    }

    public boolean getSearchBackwards() {
        return this.m_backward;
    }

    public String thresholdTipText() {
        return "Set threshold by which attributes can be discarded. Default value results in no attributes being discarded. Use in conjunction with generateRanking";
    }

    public void setThreshold(double d) {
        this.m_threshold = d;
    }

    public double getThreshold() {
        return this.m_threshold;
    }

    public String numToSelectTipText() {
        return "Specify the number of attributes to retain. The default value (-1) indicates that all attributes are to be retained. Use either this option or a threshold to reduce the attribute set.";
    }

    public void setNumToSelect(int n) {
        this.m_numToSelect = n;
    }

    public int getNumToSelect() {
        return this.m_numToSelect;
    }

    public int getCalculatedNumToSelect() {
        if (this.m_numToSelect >= 0) {
            this.m_calculatedNumToSelect = this.m_numToSelect;
        }
        return this.m_calculatedNumToSelect;
    }

    public String generateRankingTipText() {
        return "Set to true if a ranked list is required.";
    }

    public void setGenerateRanking(boolean bl) {
        this.m_rankingRequested = bl;
    }

    public boolean getGenerateRanking() {
        return this.m_rankingRequested;
    }

    public String startSetTipText() {
        return "Set the start point for the search. This is specified as a comma seperated list off attribute indexes starting at 1. It can include ranges. Eg. 1,2,5-9,17.";
    }

    public void setStartSet(String string) throws Exception {
        this.m_startRange.setRanges(string);
    }

    public String getStartSet() {
        return this.m_startRange.getRanges();
    }

    public String conservativeForwardSelectionTipText() {
        return "If true (and forward search is selected) then attributes will continue to be added to the best subset as long as merit does not degrade.";
    }

    public void setConservativeForwardSelection(boolean bl) {
        this.m_conservativeSelection = bl;
    }

    public boolean getConservativeForwardSelection() {
        return this.m_conservativeSelection;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(5);
        vector.addElement(new Option("\tUse conservative forward search", "-C", 0, "-C"));
        vector.addElement(new Option("\tUse a backward search instead of a\n\tforward one.", "-B", 0, "-B"));
        vector.addElement(new Option("\tSpecify a starting set of attributes.\n\tEg. 1,3,5-7.", "P", 1, "-P <start set>"));
        vector.addElement(new Option("\tProduce a ranked list of attributes.", "R", 0, "-R"));
        vector.addElement(new Option("\tSpecify a theshold by which attributes\n\tmay be discarded from the ranking.\n\tUse in conjuction with -R", "T", 1, "-T <threshold>"));
        vector.addElement(new Option("\tSpecify number of attributes to select", "N", 1, "-N <num to select>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        this.setSearchBackwards(Utils.getFlag('B', stringArray));
        this.setConservativeForwardSelection(Utils.getFlag('C', stringArray));
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setStartSet(string);
        }
        this.setGenerateRanking(Utils.getFlag('R', stringArray));
        string = Utils.getOption('T', stringArray);
        if (string.length() != 0) {
            Double d = Double.valueOf(string);
            this.setThreshold(d);
        }
        if ((string = Utils.getOption('N', stringArray)).length() != 0) {
            this.setNumToSelect(Integer.parseInt(string));
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[9];
        int n = 0;
        if (this.getSearchBackwards()) {
            stringArray[n++] = "-B";
        }
        if (this.getConservativeForwardSelection()) {
            stringArray[n++] = "-C";
        }
        if (!this.getStartSet().equals("")) {
            stringArray[n++] = "-P";
            stringArray[n++] = "" + this.startSetToString();
        }
        if (this.getGenerateRanking()) {
            stringArray[n++] = "-R";
        }
        stringArray[n++] = "-T";
        stringArray[n++] = "" + this.getThreshold();
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.getNumToSelect();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    protected String startSetToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_starting == null) {
            return this.getStartSet();
        }
        for (int i = 0; i < this.m_starting.length; ++i) {
            boolean bl = false;
            if (!this.m_hasClass || this.m_hasClass && i != this.m_classIndex) {
                stringBuffer.append(this.m_starting[i] + 1);
                bl = true;
            }
            if (i == this.m_starting.length - 1) {
                stringBuffer.append("");
                continue;
            }
            if (!bl) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tGreedy Stepwise (" + (this.m_backward ? "backwards)" : "forwards)") + ".\n\tStart set: ");
        if (this.m_starting == null) {
            if (this.m_backward) {
                stringBuffer.append("all attributes\n");
            } else {
                stringBuffer.append("no attributes\n");
            }
        } else {
            stringBuffer.append(this.startSetToString() + "\n");
        }
        if (!this.m_doneRanking) {
            stringBuffer.append("\tMerit of best subset found: " + Utils.doubleToString(Math.abs(this.m_bestMerit), 8, 3) + "\n");
        }
        if (this.m_threshold != -1.7976931348623157E308 && this.m_doneRanking) {
            stringBuffer.append("\tThreshold for discarding attributes: " + Utils.doubleToString(this.m_threshold, 8, 4) + "\n");
        }
        return stringBuffer.toString();
    }

    public int[] search(ASEvaluation aSEvaluation, Instances instances) throws Exception {
        int n;
        double d = -1.7976931348623157E308;
        int n2 = 0;
        if (instances != null) {
            this.resetOptions();
            this.m_Instances = instances;
        }
        this.m_ASEval = aSEvaluation;
        this.m_numAttribs = this.m_Instances.numAttributes();
        if (this.m_best_group == null) {
            this.m_best_group = new BitSet(this.m_numAttribs);
        }
        if (!(this.m_ASEval instanceof SubsetEvaluator)) {
            throw new Exception(this.m_ASEval.getClass().getName() + " is not a " + "Subset evaluator!");
        }
        this.m_startRange.setUpper(this.m_numAttribs - 1);
        if (!this.getStartSet().equals("")) {
            this.m_starting = this.m_startRange.getSelection();
        }
        if (this.m_ASEval instanceof UnsupervisedSubsetEvaluator) {
            this.m_hasClass = false;
            this.m_classIndex = -1;
        } else {
            this.m_hasClass = true;
            this.m_classIndex = this.m_Instances.classIndex();
        }
        SubsetEvaluator subsetEvaluator = (SubsetEvaluator)this.m_ASEval;
        if (this.m_rankedAtts == null) {
            this.m_rankedAtts = new double[this.m_numAttribs][2];
            this.m_rankedSoFar = 0;
        }
        if (this.m_starting != null && this.m_rankedSoFar <= 0) {
            for (n = 0; n < this.m_starting.length; ++n) {
                if (this.m_starting[n] == this.m_classIndex) continue;
                this.m_best_group.set(this.m_starting[n]);
            }
        } else if (this.m_backward && this.m_rankedSoFar <= 0) {
            for (n = 0; n < this.m_numAttribs; ++n) {
                if (n == this.m_classIndex) continue;
                this.m_best_group.set(n);
            }
        }
        d = subsetEvaluator.evaluateSubset(this.m_best_group);
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            BitSet bitSet = (BitSet)this.m_best_group.clone();
            double d2 = d;
            if (this.m_doRank) {
                d2 = -1.7976931348623157E308;
            }
            bl = true;
            bl2 = false;
            for (n = 0; n < this.m_numAttribs; ++n) {
                boolean bl3;
                if (this.m_backward) {
                    bl3 = n != this.m_classIndex && bitSet.get(n);
                } else {
                    boolean bl4 = bl3 = n != this.m_classIndex && !bitSet.get(n);
                }
                if (!bl3) continue;
                if (this.m_backward) {
                    bitSet.clear(n);
                } else {
                    bitSet.set(n);
                }
                double d3 = subsetEvaluator.evaluateSubset(bitSet);
                if (this.m_backward) {
                    bl3 = d3 >= d2;
                } else if (this.m_conservativeSelection) {
                    bl3 = d3 >= d2;
                } else {
                    boolean bl5 = bl3 = d3 > d2;
                }
                if (bl3) {
                    d2 = d3;
                    n2 = n;
                    bl2 = true;
                    bl = false;
                }
                if (this.m_backward) {
                    bitSet.set(n);
                } else {
                    bitSet.clear(n);
                }
                if (!this.m_doRank) continue;
                bl = false;
            }
            if (!bl2) continue;
            if (this.m_backward) {
                this.m_best_group.clear(n2);
            } else {
                this.m_best_group.set(n2);
            }
            d = d2;
            this.m_rankedAtts[this.m_rankedSoFar][0] = n2;
            this.m_rankedAtts[this.m_rankedSoFar][1] = d;
            ++this.m_rankedSoFar;
        }
        this.m_bestMerit = d;
        return this.attributeList(this.m_best_group);
    }

    public double[][] rankedAttributes() throws Exception {
        if (this.m_rankedAtts == null || this.m_rankedSoFar == -1) {
            throw new Exception("Search must be performed before attributes can be ranked.");
        }
        this.m_doRank = true;
        this.search(this.m_ASEval, null);
        double[][] dArray = new double[this.m_rankedSoFar][2];
        for (int i = 0; i < this.m_rankedSoFar; ++i) {
            dArray[i][0] = this.m_rankedAtts[i][0];
            dArray[i][1] = this.m_rankedAtts[i][1];
        }
        this.resetOptions();
        this.m_doneRanking = true;
        if (this.m_numToSelect > dArray.length) {
            throw new Exception("More attributes requested than exist in the data");
        }
        if (this.m_numToSelect <= 0) {
            if (this.m_threshold == -1.7976931348623157E308) {
                this.m_calculatedNumToSelect = dArray.length;
            } else {
                this.determineNumToSelectFromThreshold(dArray);
            }
        }
        return dArray;
    }

    private void determineNumToSelectFromThreshold(double[][] dArray) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i][1] > this.m_threshold)) continue;
            ++n;
        }
        this.m_calculatedNumToSelect = n;
    }

    protected int[] attributeList(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    protected void resetOptions() {
        this.m_doRank = false;
        this.m_best_group = null;
        this.m_ASEval = null;
        this.m_Instances = null;
        this.m_rankedSoFar = -1;
        this.m_rankedAtts = null;
    }
}

