## ----echo = FALSE-------------------------------------------------------------
set.seed(1)

## -----------------------------------------------------------------------------
env <- thor::mdb_env(tempfile())

## -----------------------------------------------------------------------------
env

## -----------------------------------------------------------------------------
env$list()

## -----------------------------------------------------------------------------
for (i in 1:10) {
  env$put(ids::adjective_animal(),
          ids::random_id())
}

## -----------------------------------------------------------------------------
keys <- env$list()
keys

## -----------------------------------------------------------------------------
env$get(keys[[1]])

## -----------------------------------------------------------------------------
env$del(keys[[1]])

## -----------------------------------------------------------------------------
length(env$list())

## -----------------------------------------------------------------------------
env$exists(keys[[1]])
env$exists(keys[[2]])

## -----------------------------------------------------------------------------
env$mdel(keys)

## -----------------------------------------------------------------------------
env$path()

## -----------------------------------------------------------------------------
dir(env$path())

## -----------------------------------------------------------------------------
env$flags()

## -----------------------------------------------------------------------------
env$info()
env$stat()

## -----------------------------------------------------------------------------
txn <- env$begin(write = TRUE)

## -----------------------------------------------------------------------------
txn

## -----------------------------------------------------------------------------
txn$put("key", "value")

## -----------------------------------------------------------------------------
txn$get("key")

## -----------------------------------------------------------------------------
txn$del("key")
txn$del("key")

## -----------------------------------------------------------------------------
txn$exists("key")

## -----------------------------------------------------------------------------
values <- ids::sentence(length(keys), style = "sentence")
txn$mput(keys, values)

## -----------------------------------------------------------------------------
txn$list()

## -----------------------------------------------------------------------------
txn$mget(keys[1:3], as_raw = FALSE)

## -----------------------------------------------------------------------------
txn$mdel(keys[1:3])

## -----------------------------------------------------------------------------
txn$exists(keys)

## -----------------------------------------------------------------------------
txn_new <- env$begin()
txn_new$list()

## ----error = TRUE-------------------------------------------------------------
env$put("key", "value")

## ----error = TRUE-------------------------------------------------------------
env$begin(write = TRUE)

## -----------------------------------------------------------------------------
txn$commit()

## ----error = TRUE-------------------------------------------------------------
txn$list()

## -----------------------------------------------------------------------------
env$list()

## -----------------------------------------------------------------------------
txn_new$list()

## -----------------------------------------------------------------------------
txn_new$abort()
env$mdel(keys)

## -----------------------------------------------------------------------------
charToRaw("hello")

## ----error = TRUE-------------------------------------------------------------
rawToChar(as.raw(c(42, 0, 255)))

## -----------------------------------------------------------------------------
txn <- env$begin(write = TRUE)

## ----error = TRUE-------------------------------------------------------------
txn$put("mtcars", mtcars)

## -----------------------------------------------------------------------------
mtcars_ser <- serialize(mtcars, NULL)

## -----------------------------------------------------------------------------
str(mtcars_ser)

## -----------------------------------------------------------------------------
identical(unserialize(mtcars_ser), mtcars)

txn$put("mtcars", mtcars_ser)
txn$list()

## -----------------------------------------------------------------------------
class(txn$get("mtcars"))

## -----------------------------------------------------------------------------
identical(unserialize(txn$get("mtcars")), mtcars)
txn$del("mtcars")

## -----------------------------------------------------------------------------
bytes <- as.raw(c(42, 0, 255))
string <- charToRaw("hello!")

txn$put("bytes", bytes)
txn$put("string", string)

## -----------------------------------------------------------------------------
txn$get("string")

## -----------------------------------------------------------------------------
txn$get("bytes")

## -----------------------------------------------------------------------------
txn$mget(c("string", "bytes"))

## -----------------------------------------------------------------------------
txn$mget(c("string", "bytes"), as_raw = TRUE)

## ----error = TRUE-------------------------------------------------------------
txn$mget(c("string", "bytes"), as_raw = FALSE)

## -----------------------------------------------------------------------------
txn$mget(c("string", "string"), as_raw = FALSE)

txn$abort()

