/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import vcf.GL;
import vcf.Marker;
import vcf.Markers;

public final class MaskedEndsGL
implements GL {
    private final GL gl;
    private final int start;
    private final int end;

    public MaskedEndsGL(GL gL, int n, int n2) {
        if (n < 0 || n > n2 || n2 > gL.nMarkers()) {
            String string = "start=" + n + " end=" + n2;
            throw new IllegalArgumentException(string);
        }
        this.gl = gL;
        this.start = n;
        this.end = n2;
    }

    @Override
    public boolean isRefData() {
        if ((this.start > 0 || this.end < this.gl.nMarkers()) && this.start < this.end) {
            return false;
        }
        return this.gl.isRefData();
    }

    private void checkMarkerAndSample(int n, int n2) {
        if (n < 0 || n >= this.gl.nMarkers()) {
            throw new IndexOutOfBoundsException("marker: " + n);
        }
        if (n2 < 0 || n2 >= this.gl.nSamples()) {
            throw new IndexOutOfBoundsException("sample: " + n2);
        }
    }

    private void checkAllele(int n, int n2) {
        if (n2 < 0 || n2 >= this.gl.marker(n).nAlleles()) {
            String string = "marker=" + n + " allele=" + n2;
            throw new IndexOutOfBoundsException(string);
        }
    }

    @Override
    public float gl(int n, int n2, int n3, int n4) {
        if (n < this.start || n >= this.end) {
            this.checkMarkerAndSample(n, n2);
            this.checkAllele(n, n3);
            this.checkAllele(n, n4);
            return 1.0f;
        }
        return this.gl.gl(n, n2, n3, n4);
    }

    @Override
    public boolean isPhased(int n, int n2) {
        if (n < this.start || n >= this.end) {
            this.checkMarkerAndSample(n, n2);
            return false;
        }
        return this.gl.isPhased(n, n2);
    }

    @Override
    public int allele1(int n, int n2) {
        if (n < this.start || n >= this.end) {
            this.checkMarkerAndSample(n, n2);
            return -1;
        }
        return this.gl.allele1(n, n2);
    }

    @Override
    public int allele2(int n, int n2) {
        if (n < this.start || n >= this.end) {
            this.checkMarkerAndSample(n, n2);
            return -1;
        }
        return this.gl.allele2(n, n2);
    }

    @Override
    public int allele(int n, int n2) {
        if (n < this.start || n >= this.end) {
            this.checkMarkerAndSample(n, n2 / 2);
            return -1;
        }
        return this.gl.allele(n, n2);
    }

    @Override
    public Marker marker(int n) {
        return this.gl.marker(n);
    }

    @Override
    public Markers markers() {
        return this.gl.markers();
    }

    @Override
    public int nMarkers() {
        return this.gl.nMarkers();
    }

    @Override
    public int nHaps() {
        return this.gl.nHaps();
    }

    @Override
    public int nSamples() {
        return this.gl.nSamples();
    }

    @Override
    public Samples samples() {
        return this.gl.samples();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10000);
        stringBuilder.append(this.getClass().toString());
        stringBuilder.append(": nSamples=");
        stringBuilder.append(this.nSamples());
        return stringBuilder.toString();
    }
}

