/*
 * Decompiled with CFR 0.152.
 */
package sample;

import blbutil.IntArray;
import blbutil.IntList;
import haplotype.SampleHapPairs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RefHapSeg {
    private final SampleHapPairs refHapPairs;
    private final int start;
    private final int end;
    private final IntArray hapToSeq;
    private final int[] seqToHap;

    public RefHapSeg(SampleHapPairs sampleHapPairs, int n, int n2) {
        if (n < 0 || n >= n2 || n2 > sampleHapPairs.nMarkers()) {
            throw new IllegalArgumentException();
        }
        HapSegData hapSegData = new HapSegData(sampleHapPairs, n, n2);
        this.refHapPairs = sampleHapPairs;
        this.start = n;
        this.end = n2;
        this.hapToSeq = hapSegData.hap2Seq();
        this.seqToHap = hapSegData.seq2Hap();
    }

    public SampleHapPairs refHapPairs() {
        return this.refHapPairs;
    }

    public int nSeq() {
        return this.seqToHap.length;
    }

    public int seq(int n) {
        return this.hapToSeq.get(n);
    }

    public int allele(int n, int n2) {
        int n3 = this.start + n;
        if (n < 0 || n3 >= this.end) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        return this.refHapPairs.allele(n3, this.seqToHap[n2]);
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    private static class HapSegData {
        private final SampleHapPairs refHapPairs;
        private final int[] hap2seq;
        private final IntList seq2Cnt;
        private final List<IntList> seq2AlleleMap;
        private final IntList seq2NonMajorCnt;
        private final IntList nonMajorSeq;

        public HapSegData(SampleHapPairs sampleHapPairs, int n, int n2) {
            this.refHapPairs = sampleHapPairs;
            this.hap2seq = new int[sampleHapPairs.nHaps()];
            this.seq2Cnt = new IntList(200);
            this.seq2Cnt.add(this.hap2seq.length);
            this.seq2AlleleMap = new ArrayList<IntList>(200);
            this.seq2AlleleMap.add(new IntList(4));
            this.seq2NonMajorCnt = new IntList(200);
            this.nonMajorSeq = new IntList(20);
            for (int i = n; i < n2; ++i) {
                if (sampleHapPairs.storesNonMajorIndices(i)) {
                    this.lowMafUpdate(i);
                    continue;
                }
                this.highMafUpdate(i);
            }
        }

        public IntArray hap2Seq() {
            return IntArray.create(this.hap2seq, 0, this.seq2AlleleMap.size() - 1);
        }

        public int[] seq2Hap() {
            int[] nArray = new int[this.seq2AlleleMap.size()];
            Arrays.fill(nArray, -1);
            for (int i = 0; i < this.hap2seq.length; ++i) {
                int n = this.hap2seq[i];
                if (nArray[n] != -1) continue;
                nArray[n] = i;
            }
            return nArray;
        }

        private void lowMafUpdate(int n) {
            this.setSeqToAlleleMap(n);
            int n2 = this.refHapPairs.nAlleles(n);
            int n3 = this.refHapPairs.majorAllele(n);
            for (int i = 0; i < n2; ++i) {
                if (i == n3) continue;
                int n4 = this.refHapPairs.alleleCount(n, i);
                for (int j = 0; j < n4; ++j) {
                    int n5 = this.refHapPairs.hapIndex(n, i, j);
                    int n6 = this.hap2seq[n5];
                    IntList intList = this.seq2AlleleMap.get(n6);
                    int n7 = this.indexOfAllele(intList, i);
                    if (n7 >= intList.size()) continue;
                    this.updateHap2Seq(n5, intList.get(n7 + 1));
                }
            }
        }

        private void setSeqToAlleleMap(int n) {
            int n2;
            int n3 = this.refHapPairs.nAlleles(n);
            int n4 = this.refHapPairs.majorAllele(n);
            this.seq2NonMajorCnt.clear();
            int n5 = this.seq2Cnt.size();
            for (n2 = 0; n2 < n5; ++n2) {
                this.seq2AlleleMap.get(n2).clear();
                this.seq2NonMajorCnt.add(0);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                if (n2 == n4) continue;
                this.updateNonMajorSeq(n, n2, this.seq2NonMajorCnt, this.nonMajorSeq);
                this.updateAlleleToSeqList(n2, this.seq2NonMajorCnt, this.nonMajorSeq);
                for (n5 = 0; n5 < this.nonMajorSeq.size(); ++n5) {
                    this.seq2NonMajorCnt.set(this.nonMajorSeq.get(n5), 0);
                }
                this.nonMajorSeq.clear();
            }
        }

        private void updateNonMajorSeq(int n, int n2, IntList intList, IntList intList2) {
            int n3 = this.refHapPairs.alleleCount(n, n2);
            for (int i = 0; i < n3; ++i) {
                int n4 = this.refHapPairs.hapIndex(n, n2, i);
                int n5 = this.hap2seq[n4];
                if (intList.getAndIncrement(n5) != 0) continue;
                intList2.add(n5);
            }
        }

        private void updateAlleleToSeqList(int n, IntList intList, IntList intList2) {
            for (int i = 0; i < intList2.size(); ++i) {
                int n2 = intList2.get(i);
                if (intList.get(n2) >= this.seq2Cnt.get(n2)) continue;
                IntList intList3 = this.seq2AlleleMap.get(n2);
                this.mapAlleleToNewSeq(intList3, n);
            }
        }

        private void highMafUpdate(int n) {
            int n2;
            int n3 = this.seq2AlleleMap.size();
            for (n2 = 0; n2 < n3; ++n2) {
                this.seq2AlleleMap.get(n2).clear();
            }
            for (n2 = 0; n2 < this.hap2seq.length; ++n2) {
                n3 = this.hap2seq[n2];
                int n4 = this.refHapPairs.allele(n, n2);
                IntList intList = this.seq2AlleleMap.get(n3);
                if (intList.isEmpty()) {
                    intList.add(n4);
                    intList.add(n3);
                    continue;
                }
                int n5 = this.indexOfAllele(intList, n4);
                if (n5 == intList.size()) {
                    this.mapAlleleToNewSeq(intList, n4);
                }
                this.updateHap2Seq(n2, intList.get(n5 + 1));
            }
        }

        private int indexOfAllele(IntList intList, int n) {
            int n2;
            for (n2 = 0; n2 < intList.size() && intList.get(n2) != n; n2 += 2) {
            }
            return n2;
        }

        private void mapAlleleToNewSeq(IntList intList, int n) {
            intList.add(n);
            intList.add(this.seq2AlleleMap.size());
            this.seq2AlleleMap.add(new IntList(4));
            this.seq2Cnt.add(0);
        }

        private void updateHap2Seq(int n, int n2) {
            this.seq2Cnt.decrementAndGet(this.hap2seq[n]);
            this.hap2seq[n] = n2;
            this.seq2Cnt.incrementAndGet(this.hap2seq[n]);
        }
    }
}

