/*
 * Decompiled with CFR 0.152.
 */
package beagleutil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ThreadSafeIndexer<T> {
    public static final int DEFAULT_INIT_CAPACITY = 500;
    private final List<T> list;
    private final Map<T, Integer> map;

    public ThreadSafeIndexer() {
        this(500);
    }

    public ThreadSafeIndexer(int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.list = new ArrayList<T>(n);
        this.map = new HashMap<T, Integer>(n);
    }

    public synchronized int getIndex(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.map.keySet().contains(t)) {
            return this.map.get(t);
        }
        int n = this.list.size();
        this.list.add(t);
        this.map.put(t, n);
        return n;
    }

    public synchronized int getIndexIfIndexed(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.map.keySet().contains(t)) {
            return this.map.get(t);
        }
        return -1;
    }

    public synchronized int size() {
        return this.list.size();
    }

    public synchronized T item(int n) {
        return this.list.get(n);
    }

    public synchronized List<T> items() {
        return new ArrayList<T>(this.list);
    }

    public synchronized String toString() {
        return this.items().toString();
    }
}

