/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.BitSet;
import uk.ac.ebi.beam.ArbitraryMatching;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.BiconnectedComponents;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.IntSet;
import uk.ac.ebi.beam.InvalidSmilesException;
import uk.ac.ebi.beam.Matching;
import uk.ac.ebi.beam.MaximumMatching;

final class Localise {
    Localise() {
    }

    private static Graph generateKekuleForm(Graph g, BitSet subset, BitSet aromatic, boolean inplace) throws InvalidSmilesException {
        Matching m = Matching.empty(g);
        int n = subset.cardinality();
        int nMatched = ArbitraryMatching.initial(g, m, subset);
        if (nMatched < n) {
            if (n - nMatched == 2) {
                nMatched = ArbitraryMatching.augmentOnce(g, m, nMatched, subset);
            }
            if (nMatched < n) {
                nMatched = MaximumMatching.maximise(g, m, nMatched, IntSet.fromBitSet(subset));
            }
            if (nMatched < n) {
                throw new InvalidSmilesException("Could not Kekulise");
            }
        }
        return inplace ? Localise.assign(g, subset, aromatic, m) : Localise.copyAndAssign(g, subset, aromatic, m);
    }

    private static Graph copyAndAssign(Graph delocalised, BitSet subset, BitSet aromatic, Matching m) throws InvalidSmilesException {
        Graph localised = new Graph(delocalised.order());
        localised.setFlags(delocalised.getFlags() & 0xFFFFFFFE);
        for (int u = 0; u < delocalised.order(); ++u) {
            localised.addAtom(delocalised.atom(u).toAliphatic());
            localised.addTopology(delocalised.topologyOf(u));
            int d = delocalised.degree(u);
            block6: for (int j = 0; j < d; ++j) {
                Edge e = delocalised.edgeAt(u, j);
                int v = e.other(u);
                if (v >= u) continue;
                switch (e.bond()) {
                    case SINGLE: {
                        if (aromatic.get(u) && aromatic.get(v)) {
                            localised.addEdge(Bond.SINGLE.edge(u, v));
                            continue block6;
                        }
                        localised.addEdge(Bond.IMPLICIT.edge(u, v));
                        continue block6;
                    }
                    case AROMATIC: {
                        if (subset.get(u) && m.other(u) == v) {
                            localised.addEdge(Bond.DOUBLE_AROMATIC.edge(u, v));
                            continue block6;
                        }
                        if (aromatic.get(u) && aromatic.get(v)) {
                            localised.addEdge(Bond.IMPLICIT_AROMATIC.edge(u, v));
                            continue block6;
                        }
                        localised.addEdge(Bond.IMPLICIT.edge(u, v));
                        continue block6;
                    }
                    case IMPLICIT: {
                        if (subset.get(u) && m.other(u) == v) {
                            localised.addEdge(Bond.DOUBLE_AROMATIC.edge(u, v));
                            continue block6;
                        }
                        if (aromatic.get(u) && aromatic.get(v)) {
                            localised.addEdge(Bond.IMPLICIT_AROMATIC.edge(u, v));
                            continue block6;
                        }
                        localised.addEdge(e);
                        continue block6;
                    }
                    default: {
                        localised.addEdge(e);
                    }
                }
            }
        }
        return localised;
    }

    private static Graph assign(Graph g, BitSet subset, BitSet aromatic, Matching m) throws InvalidSmilesException {
        g.setFlags(g.getFlags() & 0xFFFFFFFE);
        int u = aromatic.nextSetBit(0);
        while (u >= 0) {
            g.setAtom(u, g.atom(u).toAliphatic());
            int deg = g.degree(u);
            block6: for (int j = 0; j < deg; ++j) {
                Edge e = g.edgeAt(u, j);
                int v = e.other(u);
                if (v >= u) continue;
                switch (e.bond()) {
                    case SINGLE: {
                        if (aromatic.get(u) && aromatic.get(v)) {
                            e.bond(Bond.SINGLE);
                            continue block6;
                        }
                        e.bond(Bond.IMPLICIT);
                        continue block6;
                    }
                    case AROMATIC: {
                        if (subset.get(u) && m.other(u) == v) {
                            e.bond(Bond.DOUBLE_AROMATIC);
                            g.updateBondedValence(u, 1);
                            g.updateBondedValence(v, 1);
                            continue block6;
                        }
                        if (aromatic.get(v)) {
                            e.bond(Bond.IMPLICIT_AROMATIC);
                            continue block6;
                        }
                        e.bond(Bond.IMPLICIT);
                        continue block6;
                    }
                    case IMPLICIT: {
                        if (subset.get(u) && m.other(u) == v) {
                            e.bond(Bond.DOUBLE_AROMATIC);
                            g.updateBondedValence(u, 1);
                            g.updateBondedValence(v, 1);
                            continue block6;
                        }
                        if (!aromatic.get(u) || !aromatic.get(v)) continue block6;
                        e.bond(Bond.IMPLICIT_AROMATIC);
                    }
                }
            }
            u = aromatic.nextSetBit(u + 1);
        }
        return g;
    }

    static BitSet buildSet(Graph g, BitSet aromatic) {
        BitSet undecided = new BitSet(g.order());
        for (int v = 0; v < g.order(); ++v) {
            if (!g.atom(v).aromatic()) continue;
            aromatic.set(v);
            if (Localise.predetermined(g, v)) continue;
            undecided.set(v);
        }
        return undecided;
    }

    static boolean predetermined(Graph g, int v) {
        Atom a = g.atom(v);
        int q = a.charge();
        int deg = g.degree(v) + g.implHCount(v);
        if (g.bondedValence(v) > g.degree(v)) {
            int d = g.degree(v);
            for (int j = 0; j < d; ++j) {
                Edge e = g.edgeAt(v, j);
                if (e.bond() == Bond.DOUBLE) {
                    return q != 0 || a.element() != Element.Nitrogen && (a.element() != Element.Sulfur || deg <= 3);
                }
                if (e.bond().order() <= 2) continue;
                return true;
            }
        }
        switch (a.element()) {
            case Boron: {
                return q == 0 && deg == 3;
            }
            case Carbon: {
                return (q == 1 || q == -1) && deg == 3;
            }
            case Silicon: 
            case Germanium: {
                return q < 0;
            }
            case Nitrogen: 
            case Phosphorus: 
            case Arsenic: 
            case Antimony: {
                if (q == 0) {
                    return deg == 3 || deg > 4;
                }
                if (q == 1) {
                    return deg > 3;
                }
                return true;
            }
            case Oxygen: 
            case Sulfur: 
            case Selenium: 
            case Tellurium: {
                if (q == 0) {
                    return deg == 2 || deg == 4 || deg > 5;
                }
                if (q == -1 || q == 1) {
                    return deg == 3 || deg == 5 || deg > 6;
                }
                return false;
            }
        }
        return false;
    }

    static boolean inSmallRing(Graph g, Edge e) {
        BitSet visit = new BitSet();
        return Localise.inSmallRing(g, e.either(), e.other(e.either()), e.other(e.either()), 1, new BitSet());
    }

    static boolean inSmallRing(Graph g, int v, int prev, int t, int d, BitSet visit) {
        if (d > 7) {
            return false;
        }
        if (v == t) {
            return true;
        }
        if (visit.get(v)) {
            return false;
        }
        visit.set(v);
        int deg = g.degree(v);
        for (int j = 0; j < deg; ++j) {
            Edge e = g.edgeAt(v, j);
            int w = e.other(v);
            if (w == prev || !Localise.inSmallRing(g, w, v, t, d + 1, visit)) continue;
            return true;
        }
        return false;
    }

    static Graph resonate(Graph g, BitSet cyclic, boolean ordered) {
        BitSet subset = new BitSet();
        int u = cyclic.nextSetBit(0);
        while (u >= 0) {
            int uExtra = g.bondedValence(u) - g.degree(u);
            if (uExtra > 0) {
                int other = -1;
                Edge target = null;
                int d = g.degree(u);
                for (int j = 0; j < d; ++j) {
                    Edge e = g.edgeAt(u, j);
                    int v = e.other(u);
                    if (e.bond().order() != 2) continue;
                    int vExtra = g.bondedValence(v) - g.degree(v);
                    if (cyclic.get(v) && vExtra > 0) {
                        if (Localise.hasAdjDirectionalLabels(g, e, cyclic) && !Localise.inSmallRing(g, e)) {
                            other = -1;
                            break;
                        }
                        if (vExtra > 1 && Localise.hasAdditionalCyclicDoubleBond(g, cyclic, u, v)) {
                            other = -1;
                            break;
                        }
                        if (other == -1) {
                            other = v;
                            target = e;
                        } else {
                            other = -2;
                        }
                    }
                    if (uExtra == 1) break;
                }
                if (other >= 0) {
                    subset.set(u);
                    subset.set(other);
                    target.bond(Bond.IMPLICIT);
                }
            }
            u = cyclic.nextSetBit(u + 1);
        }
        if (!ordered) {
            g = g.sort(new Graph.CanOrderFirst());
        }
        Matching m = Matching.empty(g);
        int n = subset.cardinality();
        int nMatched = ArbitraryMatching.dfs(g, m, subset);
        if (nMatched < n) {
            if (n - nMatched == 2) {
                nMatched = ArbitraryMatching.augmentOnce(g, m, nMatched, subset);
            }
            if (nMatched < n) {
                nMatched = MaximumMatching.maximise(g, m, nMatched, IntSet.fromBitSet(subset));
            }
            if (nMatched < n) {
                throw new InternalError("Could not Kekulise");
            }
        }
        int v = subset.nextSetBit(0);
        while (v >= 0) {
            int w = m.other(v);
            subset.clear(w);
            g.edge(v, w).bond(Bond.DOUBLE);
            v = subset.nextSetBit(v + 1);
        }
        return g;
    }

    static Graph resonate(Graph g) {
        return Localise.resonate(g, new BiconnectedComponents(g).cyclic(), false);
    }

    private static boolean hasAdditionalCyclicDoubleBond(Graph g, BitSet cyclic, int u, int v) {
        for (Edge f : g.edges(v)) {
            if (f.bond() != Bond.DOUBLE || f.other(v) == u || !cyclic.get(u)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAdjDirectionalLabels(Graph g, Edge e, BitSet cyclic) {
        int u = e.either();
        int v = e.other(u);
        return Localise.hasAdjDirectionalLabels(g, u, cyclic) && Localise.hasAdjDirectionalLabels(g, v, cyclic);
    }

    private static boolean hasAdjDirectionalLabels(Graph g, int u, BitSet cyclic) {
        int d = g.degree(u);
        for (int j = 0; j < d; ++j) {
            Edge f = g.edgeAt(u, j);
            int v = f.other(u);
            if (!f.bond().directional() || !cyclic.get(v)) continue;
            return true;
        }
        return false;
    }

    static Graph localise(Graph delocalised) throws InvalidSmilesException {
        if (delocalised.getFlags(1) == 0) {
            return delocalised;
        }
        BitSet aromatic = new BitSet();
        BitSet subset = Localise.buildSet(delocalised, aromatic);
        if (Localise.hasOddCardinality(subset)) {
            throw new InvalidSmilesException("a valid kekul\u00e9 structure could not be assigned");
        }
        return Localise.generateKekuleForm(delocalised, subset, aromatic, false);
    }

    static Graph localiseInPlace(Graph delocalised) throws InvalidSmilesException {
        if (delocalised.getFlags(1) == 0) {
            return delocalised;
        }
        BitSet aromatic = new BitSet();
        BitSet subset = Localise.buildSet(delocalised, aromatic);
        if (Localise.hasOddCardinality(subset)) {
            throw new InvalidSmilesException("a valid kekul\u00e9 structure could not be assigned");
        }
        return Localise.generateKekuleForm(delocalised, subset, aromatic, true);
    }

    private static boolean hasOddCardinality(BitSet s) {
        return (s.cardinality() & 1) == 1;
    }
}

