/*
 * Decompiled with CFR 0.152.
 */
package org.extratrees;

import java.util.ArrayList;
import java.util.Set;
import org.extratrees.BinaryTree;
import org.extratrees.ExtraTrees;
import org.extratrees.QuantileBinaryTree;
import org.extratrees.QuickSelect;
import org.extratrees.data.Array2D;
import org.extratrees.data.Row;

public class QuantileExtraTrees
extends ExtraTrees {
    public QuantileExtraTrees(Array2D array2D, double[] dArray) {
        super(array2D, dArray);
    }

    public double[] getQuantiles(Array2D array2D, double d) {
        double[] dArray = new double[array2D.nrows()];
        ArrayList<Double> arrayList = new ArrayList<Double>(this.trees.size());
        for (int i = 0; i < array2D.nrows(); ++i) {
            this.getLeafValues(array2D.getRow(i), arrayList);
            dArray[i] = QuickSelect.quickSelect(arrayList, d);
        }
        return dArray;
    }

    public void getLeafValues(Row row, ArrayList<Double> arrayList) {
        arrayList.clear();
        for (BinaryTree binaryTree : this.trees) {
            QuantileBinaryTree quantileBinaryTree = (QuantileBinaryTree)binaryTree.getLeaf(row);
            if (quantileBinaryTree == null) continue;
            arrayList.addAll(quantileBinaryTree.values);
        }
    }

    @Override
    public BinaryTree makeLeaf(int[] nArray, Set<Integer> set) {
        QuantileBinaryTree quantileBinaryTree = new QuantileBinaryTree();
        quantileBinaryTree.value = 0.0;
        quantileBinaryTree.nSuccessors = nArray.length;
        quantileBinaryTree.tasks = set;
        quantileBinaryTree.values = new ArrayList(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            QuantileBinaryTree quantileBinaryTree2 = quantileBinaryTree;
            Double.valueOf((Double)quantileBinaryTree2.value + this.output[nArray[i]]);
            quantileBinaryTree2.value = quantileBinaryTree2.value;
            quantileBinaryTree.values.add(this.output[nArray[i]]);
        }
        QuantileBinaryTree quantileBinaryTree3 = quantileBinaryTree;
        quantileBinaryTree3.value = (Double)quantileBinaryTree3.value / (double)nArray.length;
        return quantileBinaryTree;
    }
}

