/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.toolkit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.rosuda.deducer.toolkit.ArrayListTransferHandler;

public class DJList
extends JList
implements DragSourceListener,
DropTargetListener,
DragGestureListener {
    protected ArrayListTransferHandler arrayListHandler = new ArrayListTransferHandler();
    protected int dragIndex = -1;
    protected boolean isAtEnd = false;
    protected int dragMode = 3;
    Object dropTargetCell;

    public DJList() {
        this.setTransferHandler(this.arrayListHandler);
        this.setDragEnabled(true);
        this.setCellRenderer(new DListCellRenderer());
        DragSource dragSource = new DragSource();
        DragGestureRecognizer dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        DropTarget dropTarget = new DropTarget(this, this);
        this.setModel(new DefaultListModel());
    }

    public int getTransferMode() {
        return this.dragMode;
    }

    public void setTransferMode(int n) {
        this.dragMode = n;
        this.arrayListHandler = new ArrayListTransferHandler();
        this.arrayListHandler.setTransferMode(n);
        this.setTransferHandler(this.arrayListHandler);
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.dragIndex = -1;
        this.isAtEnd = false;
        this.repaint();
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.dragIndex = -1;
        this.isAtEnd = false;
        this.repaint();
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        this.dragIndex = this.locationToIndex(point);
        Rectangle rectangle = this.getCellBounds(0, this.getModel().getSize() - 1);
        boolean bl = this.isAtEnd = rectangle != null && !rectangle.contains(point);
        if (!this.isAtEnd) {
            this.setSelectedIndex(this.dragIndex);
        } else {
            this.getSelectionModel().clearSelection();
        }
        this.repaint();
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            dropTargetDropEvent.acceptDrop(2);
            boolean bl = this.arrayListHandler.importData(this, dropTargetDropEvent.getTransferable());
            int[] nArray = this.getSelectedIndices();
            if (nArray.length > 0) {
                this.getSelectionModel().removeSelectionInterval(nArray[nArray.length - 1], nArray[nArray.length - 1]);
            }
            dropTargetDropEvent.dropComplete(bl);
            this.dragIndex = -1;
            this.isAtEnd = false;
            this.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
    }

    class DListCellRenderer
    extends DefaultListCellRenderer {
        boolean isLastItem;
        int thisIndex;
        Insets normalInsets = super.getInsets();
        Insets lastItemInsets;
        int BOTTOM_PAD = 30;

        public DListCellRenderer() {
            this.lastItemInsets = new Insets(this.normalInsets.top, this.normalInsets.left, this.normalInsets.bottom + this.BOTTOM_PAD, this.normalInsets.right);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.thisIndex = n;
            this.isLastItem = n == jList.getModel().getSize() - 1;
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.thisIndex == DJList.this.dragIndex && !DJList.this.isAtEnd) {
                graphics.setColor(Color.black);
                graphics.drawLine(0, 0, this.getSize().width, 0);
            } else if (DJList.this.isAtEnd && this.isLastItem) {
                graphics.setColor(Color.black);
                graphics.drawLine(0, this.getSize().height - 1, this.getSize().width, this.getSize().height - 1);
            }
        }
    }
}

