/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.shaded.apache.http.protocol;

import com.simba.athena.shaded.apache.http.HttpEntityEnclosingRequest;
import com.simba.athena.shaded.apache.http.HttpException;
import com.simba.athena.shaded.apache.http.HttpRequest;
import com.simba.athena.shaded.apache.http.HttpRequestInterceptor;
import com.simba.athena.shaded.apache.http.annotation.Contract;
import com.simba.athena.shaded.apache.http.annotation.ThreadingBehavior;
import com.simba.athena.shaded.apache.http.protocol.HttpContext;
import com.simba.athena.shaded.apache.http.protocol.HttpDateGenerator;
import com.simba.athena.shaded.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

