/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.shaded.apache.http.impl.conn;

import com.simba.athena.shaded.apache.http.HttpResponse;
import com.simba.athena.shaded.apache.http.HttpResponseFactory;
import com.simba.athena.shaded.apache.http.annotation.Contract;
import com.simba.athena.shaded.apache.http.annotation.ThreadingBehavior;
import com.simba.athena.shaded.apache.http.config.MessageConstraints;
import com.simba.athena.shaded.apache.http.impl.DefaultHttpResponseFactory;
import com.simba.athena.shaded.apache.http.impl.conn.DefaultHttpResponseParser;
import com.simba.athena.shaded.apache.http.io.HttpMessageParser;
import com.simba.athena.shaded.apache.http.io.HttpMessageParserFactory;
import com.simba.athena.shaded.apache.http.io.SessionInputBuffer;
import com.simba.athena.shaded.apache.http.message.BasicLineParser;
import com.simba.athena.shaded.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

