### Name: Tps
### Title: Thin plate spline regression
### Aliases: Tps
### Keywords: smooth

### ** Examples

#2-d example 

fit<- Tps(ozone$x, ozone$y)  # fits a surface to ozone measurements. 
plot(fit) # diagnostic plots of  fit and residuals. 
summary(fit)

# predict onto a grid that matches the ranges of the data.  

out.p<-predict.surface( fit)
image( out.p) 
surface(out.p) # perspective and contour plots of GCV spline fit 
# predict at different effective 
# number of parameters 
out.p<-predict.surface( fit,df=10)

#1-d example 
out<-Tps( rat.diet$t, rat.diet$trt) # lambda found by GCV 
plot( out$x, out$y)
lines( out$x, out$fitted.values)

# 
# compare to the ( much faster) one spline algorithm 
#  sreg(rat.diet$t, rat.diet$trt) 
# 
#
# simulation reusing
fit<- Tps( rat.diet$t, rat.diet$trt)
true<- fit$fitted.values
N<-  length( fit$y)
temp<- matrix(  NA, ncol=50, nrow=N)
sigma<- fit$shat.GCV
for (  k in 1:50){
ysim<- true + sigma* rnorm(N) 
temp[,k]<- predict(fit, y= ysim)
}
matplot( fit$x, temp, type="l")

# 
#4-d example 
fit<- Tps(BD[,1:4],BD$lnya,scale.type="range") 
surface(fit)   
# plots fitted surface and contours 
#2-d example using a reduced set of basis functions 
r1 <- range(flame$x[,1]) 
r2 <-range( flame$x[,2]) 
g.list <- list(seq(r1[1], r1[2],6), seq(r2[1], r2[2], 6)) 
knots<- make.surface.grid(g.list) 
# these knots are a 6X6 grid over 
# the ranges of the two flame variables 
out<-Tps(flame$x, flame$y, knots=knots, m=3)   
surface( out, type="I")
points( knots)



