### Name: Coercions between matrix and graph representations
### Title: Coercions between matrix and graph representations
### Aliases: aM2bpG ftM2adjM ftM2graphNEL coerce,matrix,graphNEL-method
###   coerce,graphNEL,matrix-method
### Keywords: graphs

### ** Examples


## From-To matrix

From <- c("A","A","C","C")
To   <- c("B","C","B","D")
L <- cbind(From,To)

W  <- 1:4
M1 <- ftM2adjM(L, W, edgemode="directed")
M2 <- ftM2adjM(L, W, edgemode="undirected")
stopifnot(all(M1+t(M1)==M2))

G1 <- ftM2graphNEL(L, W, edgemode="directed")
G2 <- ftM2graphNEL(L, W, edgemode="undirected")

## Adjacency matrix

From <- matrix(runif(100), nrow=10, ncol=10)
From <- (From+t(From)) > pi/4
rownames(From) <- colnames(From) <- LETTERS[1:10]

To <- as(From,"graphNEL")
Back <- as(To,"matrix")

stopifnot(all(From == Back))




