### Name: threePanelPlot
### Title: Visualize cytometry data
### Aliases: threePanelPlot
### Keywords: hplot

### ** Examples

   # generate some data:
   toyData <- cbind(matrix(pmax(0,pmin(runif(3000)+rnorm(3000),4)),ncol=3),
                    matrix(pmax(0,pmin(rnorm(3000,2,1),4)),ncol=3))
   colnames(toyData) <- paste("Var",1:6,sep="")
   toyQuantiles <- apply(toyData,2,quantile,probs=c(0.25,0.5,0.75))

   # plot it and mark the quantiles:
   threePanelPlot(toyData,addPoints=toyQuantiles,
                  addCol=c("orange","red","purple"),limits=c(0,4),pch=20)



