### Name: geneprofile
### Title: Expression plot for selected genes
### Aliases: geneprofile
### Keywords: hplot

### ** Examples

# load in data
data(paigen)
# make data object with rep 2
paigen <- createData(paigen.raw, 2)
# make an additive model
model.add.fix <- makeModel(data=paigen, formula=~Dye+Array+Strain+Diet)
# fit ANOVA model
anova.add <- fitmaanova(paigen, model.add.fix)
# test strain effect
## Not run: test.Strain.fix <- matest(paigen, model.add.fix, term="Strain", n.perm=100)
##D # volcano plot
##D idx <- volcano(test.Strain.fix)
##D 
##D # do gene profile for the selected genes
##D geneprofile(anova.add, "Strain", idx$idx.all)
## End(Not run)



