logic.vim              package:logicFS              R Documentation

_P_r_i_m_e _I_m_p_l_i_c_a_n_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     'logic.pimp' computes the prime implicants of an object of class 
     'logicBagg'.

     'logic.vim' additionally computes the importance of the prime
     implicants.

     'logic.oob' computes the out-of-bag error of a 'logicBagg' object.

_U_s_a_g_e:

     logic.pimp(log.out)
     logic.oob(log.out, prob.case = 0.5)
     logic.vim(log.out, prob.case = 0.5, addInfo = FALSE)

_A_r_g_u_m_e_n_t_s:

 log.out: an object of class 'logicBagg'.

prob.case: a numeric value between 0 and 1. If the outcome of the
          logistic regression, i.e. the predicted probability, for an
          observation is larger than 'prob.case' this observations will
          be classified as case  (or 1).

 addInfo: should further information on the logic regression models be
          added?

_D_e_t_a_i_l_s:

     Since we are interested in all potentially interested SNP
     interactions and not in a minimum set of them both 'logic.pimp'
     and 'logic.vim' return all prime implicants and not a minimum
     number of them.

_V_a_l_u_e:

     'logic.pimp' returns a list consisting of the prime implicants for
     each of the 'B' logic regression models of 'log.out'.

     'logic.oob' returns the out-of-bag error.

     'logic.vim' returns an object of class 'logicFS' containing 

  primes: the prime implicants

     vim: the importance of the prime implicants

    prop: the proportion of logic regression models that contain the
          prime  implicants

    type: the type of model (1: classification, 3: logistic regression)

   param: further parameters (if 'addInfo=TRUE').

_N_o_t_e:

     Tech. Report on the feature selection using logic regression will
     be available soon.

_A_u_t_h_o_r(_s):

     Holger Schwender, holger.schwender@udo.edu

_S_e_e _A_l_s_o:

     'logic.bagging', 'logic.fs', 'prime.implicants'

