### Name: panel.hexboxplot
### Title: ~~function to do ... ~~
### Aliases: panel.hexboxplot
### Keywords: hplot

### ** Examples

##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--    or do  help(data=index)  for the standard data sets.

## The function is currently defined as
function (x, y, xbins = 30, xbnds = c("panel", "data"), ybnds = c("panel", 
    "data"), .prelim = FALSE, .cpl = current.panel.limits(), 
    .xlim = .cpl$xlim, .ylim = .cpl$ylim, .aspect.ratio, type = character(0), 
    cdfcut = 0.25, shadow = 0.05, singles = TRUE, ..., check.erosion = TRUE) 
{
    if (is.character(xbnds)) 
        xbnds <- switch(match.arg(xbnds), panel = .xlim, data = range(x, 
            finite = TRUE))
    if (is.character(ybnds)) 
        ybnds <- switch(match.arg(ybnds), panel = .ylim, data = range(y, 
            finite = TRUE))
    shape <- .aspect.ratio * (diff(ybnds)/diff(.ylim))/(diff(xbnds)/diff(.xlim))
    if (!missing(check.erosion)) 
        warning("explicit 'check.erosion' specification ignored")
    h <- hexbin(x = x, y = y, xbins = xbins, shape = shape, xbnds = xbnds, 
        ybnds = ybnds, IDs = TRUE)
    if (.prelim) 
        return(max(h@count))
    args <- list(dat = h, check.erosion = FALSE, ...)
    keep <- names(args) %in% names(formals(grid.hexagons))
    if ("hg" %in% type) 
        panel.hexgrid(h)
    if ("g" %in% type) 
        panel.grid(h = -1, v = -1)
    if (shadow) {
        eh <- erode(h, cdfcut = shadow)
        h.xy <- hcell2xy(eh, check.erosion = TRUE)
        dx <- (0.5 * diff(eh@xbnds))/eh@xbins
        dy <- (0.5 * diff(eh@ybnds))/(eh@xbins * h@shape * sqrt(3))
        hexC <- hexcoords(dx, dy, sep = NULL)
        hexpolygon(h.xy$x, h.xy$y, hexC, density = density, fill = NA, 
            border = gray(0.75))
    }
    eh <- erode(h, cdfcut = cdfcut)
    h.xy <- hcell2xy(eh, check.erosion = TRUE)
    dx <- (0.5 * diff(eh@xbnds))/eh@xbins
    dy <- (0.5 * diff(eh@ybnds))/(eh@xbins * h@shape * sqrt(3))
    hexC <- hexcoords(dx, dy, sep = NULL)
    hexpolygon(h.xy$x, h.xy$y, hexC, density = density, fill = "green", 
        border = gray(0.75))
    med <- which.max(eh@erode)
    xnew <- h.xy$x[med]
    ynew <- h.xy$y[med]
    hexpolygon(xnew, ynew, hexC, density = density, fill = "red", 
        border = gray(0.25))
    invisible()
  }



