/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.geese.rShell;

import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import org.systemsbiology.gaggle.boss.Boss;
import org.systemsbiology.gaggle.experiment.datamatrix.DataMatrix;
import org.systemsbiology.gaggle.geese.Goose;
import org.systemsbiology.gaggle.geese.rShell.StringToObjectConverter;
import org.systemsbiology.gaggle.network.Interaction;
import org.systemsbiology.gaggle.network.Network;

public class RShellGoose
implements Goose {
    String myGaggleName = "R";
    Boss gaggleBoss;
    String gaggleBossHostName = "localhost";
    static RShellGoose self;
    boolean verbose = false;
    String[] nameList = new String[0];
    DataMatrix matrix = null;
    HashMap hashMap = null;
    Network network = null;
    String clusterName = null;
    String[] clusterRowNames = null;
    String[] clusterColumnNames = null;
    String defaultSpecies = "Homo sapiens";
    String targetGoose = "all";

    public RShellGoose() {
        this("localhost", false);
    }

    public RShellGoose(boolean bl) {
        this("localhost", bl);
    }

    public RShellGoose(String string) {
        this(string, false);
    }

    public RShellGoose(String string, boolean bl) {
        self = this;
        this.gaggleBossHostName = string;
        this.verbose = bl;
        try {
            UnicastRemoteObject.exportObject((Remote)this, 0);
            this.connectToGaggle();
        }
        catch (Exception exception) {
            System.err.println("RShellGoose failed to export remote object: " + exception.getMessage());
        }
    }

    public String getVersion() {
        String string = "$Revision: 883 $";
        String string2 = "Revision: ";
        int n = string.indexOf(string2);
        int n2 = string.indexOf(" $", n += string2.length());
        String string3 = string.substring(n, n2);
        return string3;
    }

    public void connectToGaggle() {
        block2: {
            String string = "gaggle";
            String string2 = "rmi://" + this.gaggleBossHostName + "/" + string;
            try {
                this.gaggleBoss = (Boss)Naming.lookup(string2);
                this.myGaggleName = this.gaggleBoss.register(this);
            }
            catch (Exception exception) {
                System.err.println("\n\n\tFailed to connect to Gaggle Boss  at " + string2 + ":\n\t\t" + exception.getMessage());
                System.err.println("\n\tPossible causes: ");
                System.err.println("\t\t1) You forgot to start a Gaggle Boss.");
                System.err.println("\t\t2) You are using an out-of-date Gaggle Boss.\n");
                if (!this.verbose) break block2;
                exception.printStackTrace();
            }
        }
    }

    public static RShellGoose getCurrent() {
        return self;
    }

    public String[] getNameList() {
        return this.nameList;
    }

    public void handleNameList(String string, String[] stringArray) {
        System.out.println("nameList ready, length " + stringArray.length);
        this.defaultSpecies = string;
        this.nameList = stringArray;
    }

    public void handleMatrix(DataMatrix dataMatrix) {
        System.out.println("matrix ready, dimension " + dataMatrix.getRowCount() + " x " + dataMatrix.getColumnCount());
        this.matrix = dataMatrix;
    }

    public int getMatrixRowCount() {
        if (this.matrix == null) {
            return 0;
        }
        return this.matrix.getRowCount();
    }

    public int getMatrixColumnCount() {
        if (this.matrix == null) {
            return 0;
        }
        return this.matrix.getColumnCount();
    }

    public String[] getMatrixRowNames() {
        if (this.matrix == null) {
            return new String[0];
        }
        return this.matrix.getRowTitles();
    }

    public String[] getMatrixColumnNames() {
        if (this.matrix == null) {
            return new String[0];
        }
        return this.matrix.getColumnTitles();
    }

    public double[] getMatrixRow(int n) {
        if (this.matrix == null) {
            return new double[0];
        }
        return this.matrix.get(n);
    }

    public double[] getAllMatrixData() {
        if (this.matrix == null) {
            return new double[0];
        }
        int n = this.matrix.getRowCount();
        int n2 = this.matrix.getColumnCount();
        int n3 = n * n2;
        double[] dArray = new double[n3];
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = this.matrix.get(i);
            boolean bl = false;
            int n4 = i * n2;
            System.arraycopy(dArray2, 0, dArray, n4, n2);
        }
        return dArray;
    }

    public String getHashMapTitle() {
        if (this.hashMap == null) {
            return null;
        }
        String string = this.hashMap.keySet().toArray(new String[0])[0];
        return string;
    }

    public String[] getHashMapKeys() {
        if (this.hashMap == null) {
            return new String[0];
        }
        String string = this.hashMap.keySet().toArray(new String[0])[0];
        ArrayList arrayList = (ArrayList)this.hashMap.get(string);
        String[] stringArray = (String[])arrayList.get(0);
        return stringArray;
    }

    public String[] getHashMapValues() {
        String string = this.hashMap.keySet().toArray(new String[0])[0];
        ArrayList arrayList = (ArrayList)this.hashMap.get(string);
        Object e = arrayList.get(1);
        Class<?> clazz = e.getClass();
        Class<?> clazz2 = "java.lang.String".getClass();
        if (clazz.isArray()) {
            Object[] objectArray = (Object[])arrayList.get(1);
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = objectArray[i].toString();
            }
            return stringArray;
        }
        System.err.println("RShellGoose.getHashMapValues error: not an array");
        return new String[0];
    }

    public void test(String string) {
        System.out.println("RShellGoose test (String name): " + string);
    }

    public void test(String[] stringArray) {
        System.out.println("RShellGoose test (String [] name): " + stringArray.length);
    }

    public void test(int n) {
        System.out.println("RShellGoose test (int i): " + n);
    }

    public void test(int[] nArray) {
        System.out.println("RShellGoose test (int i []): " + nArray.length);
    }

    public void test(Integer n) {
        System.out.println("RShellGoose test (Integer i): " + n);
    }

    public void test(Integer[] integerArray) {
        System.out.println("RShellGoose test (Integer [] i): " + integerArray.length);
    }

    public void test(double d) {
        System.out.println("RShellGoose test (double d): " + d);
    }

    public void test(Double d) {
        System.out.println("RShellGoose test (Double d: " + d);
    }

    public void test(double[] dArray) {
        System.out.println("RShellGoose test (double [] numbers): " + dArray.length);
    }

    public void test(Double[] doubleArray) {
        System.out.println("RShellGoose test (Double [] numbers): " + doubleArray.length);
    }

    public void createAndBroadcastDoubleAttributes(String string, String[] stringArray, double[] dArray) {
        HashMap hashMap = new HashMap();
        String string2 = this.defaultSpecies;
        String string3 = "";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        arrayList.add(stringArray);
        arrayList.add(dArray);
        hashMap.put(string, arrayList);
        this.broadcastAssociativeArray(string2, string3, hashMap);
    }

    public void createAndBroadcastIntegerAttributes(String string, String[] stringArray, int[] nArray) {
        HashMap hashMap = new HashMap();
        String string2 = this.defaultSpecies;
        String string3 = "";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        arrayList.add(stringArray);
        arrayList.add(nArray);
        hashMap.put(string, arrayList);
        this.broadcastAssociativeArray(string2, string3, hashMap);
    }

    public void createAndBroadcastStringAtrributes(String string, String[] stringArray, String[] stringArray2) {
        HashMap hashMap = new HashMap();
        String string2 = this.defaultSpecies;
        String string3 = "";
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(stringArray);
        arrayList.add(stringArray2);
        hashMap.put(string, arrayList);
        this.broadcastAssociativeArray(string2, string3, hashMap);
    }

    public void createAndBroadcastHashMap(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3};
        String[] stringArray2 = new String[]{string4};
        this.createAndBroadcastHashMap(string, string2, stringArray, stringArray2);
    }

    public void createAndBroadcastHashMap(String string, String string2, String string3, double d) {
        String[] stringArray = new String[]{string3};
        double[] dArray = new double[]{d};
        this.createAndBroadcastHashMap(string, string2, stringArray, dArray);
    }

    public void createAndBroadcastHashMap(String string, String string2, String[] stringArray, String[] stringArray2) {
        HashMap hashMap = new HashMap();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(stringArray);
        arrayList.add(stringArray2);
        hashMap.put(string2, arrayList);
        try {
            this.gaggleBoss.broadcast(this.myGaggleName, this.targetGoose, this.defaultSpecies, string, hashMap);
        }
        catch (RemoteException remoteException) {
            System.err.println("error broadcasting hashmap from RShellGoose " + this.myGaggleName);
            remoteException.printStackTrace();
        }
    }

    public void createAndBroadcastHashMap(String string, String string2, String[] stringArray, double[] dArray) {
        HashMap hashMap = new HashMap();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        arrayList.add(stringArray);
        arrayList.add(dArray);
        hashMap.put(string2, arrayList);
        try {
            this.gaggleBoss.broadcast(this.myGaggleName, this.targetGoose, this.defaultSpecies, string, hashMap);
        }
        catch (RemoteException remoteException) {
            System.err.println("error broadcasting hashmap from RShellGoose " + this.myGaggleName);
            remoteException.printStackTrace();
        }
    }

    public void createAndBroadcastMatrix(String[] stringArray, String[] stringArray2, double[] dArray, String string) {
        DataMatrix dataMatrix = new DataMatrix();
        int n = stringArray.length;
        int n2 = stringArray2.length;
        dataMatrix.setSize(n, n2);
        if (string != null) {
            dataMatrix.setShortName(string);
        }
        dataMatrix.setRowTitles(stringArray);
        dataMatrix.setColumnTitles(stringArray2);
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = new double[n2];
            int n3 = i * n2;
            boolean bl = false;
            System.arraycopy(dArray, n3, dArray2, 0, n2);
            dataMatrix.set(i, dArray2);
        }
        this.broadcastMatrix(dataMatrix);
    }

    protected String[] networkToStringArray(Network network) {
        Interaction[] interactionArray = network.getInteractions();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < interactionArray.length; ++i) {
            String string = interactionArray[i].getSource();
            String string2 = interactionArray[i].getTarget();
            String string3 = interactionArray[i].getType();
            String string4 = string + "::" + string2 + "::" + string3;
            arrayList.add(string4);
        }
        String[] stringArray = network.getOrphanNodes();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[0]);
    }

    protected String[] networkEdgeAttributesToStringArray(Network network) {
        Interaction[] interactionArray = network.getInteractions();
        String[] stringArray = network.getEdgeAttributeNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < interactionArray.length; ++i) {
            int n = i * 3;
            String string = interactionArray[i].getSource();
            String string2 = interactionArray[i].getType();
            String string3 = interactionArray[i].getTarget();
            String string4 = string + " (" + string2 + ") " + string3;
            String string5 = string + "::" + string3 + "::" + string2;
            for (int j = 0; j < stringArray.length; ++j) {
                String string6 = stringArray[j];
                HashMap hashMap = network.getEdgeAttributes(string6);
                if (hashMap.containsKey(string4)) {
                    Object v = hashMap.get(string4);
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string5);
                    stringBuffer.append("::");
                    stringBuffer.append(string6);
                    stringBuffer.append("::");
                    stringBuffer.append(v.toString());
                    arrayList.add(stringBuffer.toString());
                    continue;
                }
                System.out.println("no " + string6 + " attribute for " + string4);
            }
        }
        String[] stringArray2 = arrayList.toArray(new String[0]);
        return stringArray2;
    }

    protected String[] networkNodeAttributesToStringArray(Network network) {
        String[] stringArray = network.getNodeAttributeNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            HashMap hashMap = network.getNodeAttributes(string);
            String[] stringArray2 = hashMap.keySet().toArray(new String[0]);
            for (int j = 0; j < stringArray2.length; ++j) {
                String string2 = stringArray2[j];
                Object v = hashMap.get(string2);
                String string3 = string2 + "::" + string + "::" + v.toString();
                arrayList.add(string3);
            }
        }
        String[] stringArray3 = arrayList.toArray(new String[0]);
        return stringArray3;
    }

    public String[] getNetworkAsStringArray() {
        String[] stringArray = new String[]{};
        if (this.network != null) {
            stringArray = this.networkToStringArray(this.network);
        }
        return stringArray;
    }

    public String[] getNetworkEdgeAttributesAsStringArray() {
        String[] stringArray = new String[]{};
        if (this.network != null) {
            stringArray = this.networkEdgeAttributesToStringArray(this.network);
        }
        return stringArray;
    }

    public String[] getNetworkNodeAttributesAsStringArray() {
        String[] stringArray = new String[]{};
        if (this.network != null) {
            stringArray = this.networkNodeAttributesToStringArray(this.network);
        }
        return stringArray;
    }

    public void createAndBroadcastNetwork(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        String string;
        Object object;
        String string2;
        String string3;
        String[] stringArray4;
        int n;
        Network network = new Network();
        network.setSpecies(this.defaultSpecies);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            stringArray4 = stringArray[n].split("::");
            int n2 = stringArray4.length;
            if (n2 == 1 && stringArray4[0].trim().length() > 0) {
                network.add(stringArray4[0]);
                continue;
            }
            if (n2 != 3) continue;
            string3 = stringArray4[0];
            string2 = stringArray4[1];
            object = stringArray4[2];
            string = string3 + " (" + (String)object + ") " + string2;
            arrayList.add(string);
            network.add(new Interaction(string3, string2, (String)object));
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray4 = stringArray2[n].split("::");
            if (stringArray4.length != 3) continue;
            String string4 = stringArray4[0].trim();
            string3 = stringArray4[1].trim();
            string2 = stringArray4[2].trim();
            object = StringToObjectConverter.convert(string2);
            network.addNodeAttribute(string4, string3, object);
        }
        for (n = 0; n < stringArray3.length; ++n) {
            stringArray4 = stringArray3[n].split("::");
            if (stringArray4.length != 5) continue;
            String string5 = stringArray4[0].trim();
            string3 = stringArray4[1].trim();
            string2 = stringArray4[2].trim();
            object = stringArray4[3].trim();
            string = stringArray4[4].trim();
            Object object2 = StringToObjectConverter.convert(string);
            String string6 = string5 + " (" + string2 + ") " + string3;
            network.addEdgeAttribute(string6, (String)object, object2);
        }
        try {
            this.gaggleBoss.broadcast(this.myGaggleName, this.targetGoose, this.defaultSpecies, network);
        }
        catch (RemoteException remoteException) {
            System.err.println("error broadcasting network from RShellGoose " + this.myGaggleName);
            remoteException.printStackTrace();
        }
    }

    public void createAndBroadcastNetwork(String string, String[] stringArray, double[] dArray, String[] stringArray2) {
        Network network = new Network();
        network.setSpecies(this.defaultSpecies);
        for (int i = 0; i < stringArray.length; ++i) {
            Interaction interaction = new Interaction(string, stringArray[i], stringArray2[i]);
            network.add(interaction);
            String string2 = string + " (" + stringArray2[i] + ") " + stringArray[i];
            network.addEdgeAttribute(string2, "weight", dArray[i]);
        }
        try {
            this.gaggleBoss.broadcast(this.myGaggleName, this.targetGoose, this.defaultSpecies, network);
        }
        catch (RemoteException remoteException) {
            System.err.println("error broadcasting network from RShellGoose " + this.myGaggleName);
            remoteException.printStackTrace();
        }
    }

    public void handleMap(String string, String string2, HashMap hashMap) {
        System.out.println("hashMap ready");
        this.hashMap = hashMap;
    }

    public void handleCluster(String string, String string2, String[] stringArray, String[] stringArray2) {
        System.out.println("cluster ready, rowNames " + stringArray.length + " columnNames " + stringArray2.length);
        this.clusterName = string2;
        this.clusterRowNames = stringArray;
        this.clusterColumnNames = stringArray2;
    }

    public String getClusterName() {
        if (this.clusterName != null) {
            return this.clusterName;
        }
        return "";
    }

    public String[] getClusterRowNames() {
        if (this.clusterRowNames != null) {
            return this.clusterRowNames;
        }
        return new String[0];
    }

    public String[] getClusterColumnNames() {
        if (this.clusterColumnNames != null) {
            return this.clusterColumnNames;
        }
        return new String[0];
    }

    public void handleNetwork(String string, Network network) {
        System.out.println("network ready, node count " + network.getNodes().length + ", edges: " + network.edgeCount());
        this.network = network;
    }

    public void clearSelections() {
    }

    public String[] getSelection() {
        return new String[0];
    }

    public int getSelectionCount() {
        return 0;
    }

    public String[] getGeeseNames() {
        String[] stringArray = new String[]{};
        try {
            stringArray = this.gaggleBoss.getGooseNames();
        }
        catch (RemoteException remoteException) {
            System.err.println("error broadcasting network from RShellGoose " + this.myGaggleName);
            remoteException.printStackTrace();
        }
        return stringArray;
    }

    public String getName() {
        return this.myGaggleName;
    }

    public void setName(String string) {
        this.myGaggleName = string;
    }

    public void setGeometry(int n, int n2, int n3, int n4) {
    }

    public void doBroadcastList() {
    }

    protected void broadcastToGaggle(String string, String[] stringArray) {
    }

    public void doHide() {
        System.out.println("doHide not implemented for the R goose");
    }

    public void doShow() {
        System.out.println("doShow not implemented for the R goose");
    }

    public void doExit() {
        System.out.println("doExit not implemented for the R goose");
    }

    void show(String string) {
        try {
            this.gaggleBoss.show(string);
        }
        catch (RemoteException remoteException) {
            System.err.println("error rmi at boss.show , from RShellGoose " + string);
        }
    }

    void hide(String string) {
        try {
            this.gaggleBoss.hide(string);
        }
        catch (RemoteException remoteException) {
            System.err.println("error rmi at boss.hide , from RShellGoose " + string);
        }
    }

    void broadcastAssociativeArray(String string, String string2, HashMap hashMap) {
        try {
            this.gaggleBoss.broadcast(this.myGaggleName, this.targetGoose, string, string2, hashMap);
        }
        catch (RemoteException remoteException) {
            System.err.println("error broadcasting hashmap from RShellGoose " + this.myGaggleName);
        }
    }

    public void setSpecies(String string) {
        this.defaultSpecies = string;
    }

    public String getSpecies() {
        return this.defaultSpecies;
    }

    public void broadcastList(String[] stringArray) {
        try {
            this.gaggleBoss.broadcast(this.myGaggleName, this.targetGoose, this.defaultSpecies, stringArray);
        }
        catch (RemoteException remoteException) {
            System.err.println("error rmi selecting at boss, from RShellGoose " + this.myGaggleName);
        }
    }

    public void broadcastCluster(String string, String[] stringArray, String[] stringArray2) {
        try {
            this.gaggleBoss.broadcast(this.myGaggleName, this.targetGoose, this.defaultSpecies, string, stringArray, stringArray2);
        }
        catch (RemoteException remoteException) {
            System.err.println("broadcast cluster error, in RShellGoose " + this.myGaggleName);
        }
    }

    void broadcastMatrix(DataMatrix dataMatrix) {
        try {
            this.gaggleBoss.broadcast(this.myGaggleName, this.targetGoose, dataMatrix);
        }
        catch (RemoteException remoteException) {
            System.err.println("error rmi selecting at boss, from RShellGoose " + this.myGaggleName);
        }
    }

    public void setTargetGoose(String string) {
        this.targetGoose = string;
    }

    public String getTargetGoose() {
        return this.targetGoose;
    }

    public static void main(String[] stringArray) throws Exception {
        RShellGoose rShellGoose = new RShellGoose();
    }
}

