### Name: normalise
### Title: Normalisation of microarray data
### Aliases: normalise
### Keywords: utilities

### ** Examples


       intensities <- array(data=runif(720),dim=c(120,2,3))
       dimnames(intensities) <- list(NULL, c("green","red"), NULL)
       hybAttr <- data.frame(Name=I(c("hx","hy","hz")), Index=c(1:3))
        arrayDataObject <- new("arrayData",
                              intensities=intensities,
                              hybAttrList=list(red=hybAttr,green=hybAttr)
                             )
       exprSetRGObject <- normalise(arrayDataObject = arrayDataObject,
                               subtractBackground = FALSE,
                               method = "none",
                               verbose = TRUE
                               )
       nRed <- exprs(getExprSetRed(exprSetRGObject))
       nGreen <- exprs(getExprSetGreen(exprSetRGObject))
       stopifnot( all.equal.numeric( as.vector(nRed), as.vector(intensities[,"red",] )))
       stopifnot( all.equal.numeric( as.vector(nGreen), as.vector(intensities[,"green",] )) ) 

   ## Don't show: 
       exprSetRGObject <- normalise(arrayDataObject = arrayDataObject,
                               subtractBackground = FALSE,
                               method = "none",
                               channelsSeparately = TRUE,
                               verbose = TRUE
                               )
       nRed <- exprs(getExprSetRed(exprSetRGObject))
       nGreen <- exprs(getExprSetGreen(exprSetRGObject))
       stopifnot( all.equal.numeric( as.vector(nRed), as.vector(intensities[,"red",] ) ))
       stopifnot( all.equal.numeric( as.vector(nGreen), as.vector(intensities[,"green",] ) ))

       exprSetRGObject <- normalise(arrayDataObject = arrayDataObject,
                               subtractBackground = FALSE,
                               method = "none",
                               hybridisationGroups= list(c(1,3),2),
                               verbose = FALSE
                               )
       nRed <- exprs(getExprSetRed(exprSetRGObject))
       nGreen <- exprs(getExprSetGreen(exprSetRGObject))
       stopifnot( all.equal.numeric( as.vector(nRed), as.vector(intensities[,"red",] ) ))
       stopifnot( all.equal.numeric( as.vector(nGreen), as.vector(intensities[,"green",] ) ) )

       exprSetRGObject <- normalise(arrayDataObject = arrayDataObject,
                               subtractBackground = FALSE,
                               method = "none",
                               channelsSeparately = TRUE,
                               hybridisationGroups= list(c(2,3),1),
                               verbose = TRUE
                               )
       nRed <- exprs(getExprSetRed(exprSetRGObject))
       nGreen <- exprs(getExprSetGreen(exprSetRGObject))
       stopifnot( all.equal.numeric( as.vector(nRed), as.vector(intensities[,"red",] ) ))
       stopifnot( all.equal.numeric( as.vector(nGreen), as.vector(intensities[,"green",] ) ) )

       intensities <- array(data=runif(1440),dim=c(120,4,3))
       dimnames(intensities) <- list(NULL,
                                     c("green","red","greenBackground","redBackground"),
                                     NULL)
       intensities[,c("greenBackground","redBackground"),] <- -1
       hybAttr <- data.frame(Name=I(c("hx","hy","hz")), Index=c(1:3))
        arrayDataObject <- new("arrayData",
                              intensities=intensities,
                              hybAttrList=list(red=hybAttr,green=hybAttr)
                             )
       exprSetRGObject <- normalise(arrayDataObject = arrayDataObject,
                               subtractBackground = TRUE,
                               method = "none",
                               channelsSeparately = TRUE,
                               hybridisationGroups= list(c(2,3),1),
                               verbose = TRUE
                               )
       nRed <- exprs(getExprSetRed(exprSetRGObject))
       nGreen <- exprs(getExprSetGreen(exprSetRGObject))
       stopifnot( all.equal.numeric( as.vector(nRed), as.vector((intensities[,"red",] + 1) ) ))
       stopifnot( all.equal.numeric( as.vector(nGreen), as.vector((intensities[,"green",] + 1) ) ))

   ## End Don't show      
 


