### Name: olin
### Title: Optimised local intensity-dependent normalisation of two-colour
###   microarrays
### Aliases: olin
### Keywords: utilities regression

### ** Examples


# LOADING DATA
  data(sw)
  data(sw.xy)

# OPTIMISED LOCAL INTENSITY-DEPENDENT NORMALISATION OF FIRST ARRAY
  norm.olin <- olin(sw[,1],X=sw.xy$X[,1],Y=sw.xy$Y[,1])

# MA-PLOT OF NORMALISATION RESULTS OF FIRST ARRAY
  plot(maA(norm.olin),maM(norm.olin),main="OLIN")
 
# CORRESPONDING MXY-PLOT
  mxy.plot(maM(norm.olin)[,1],Ngc=maNgc(norm.olin),Ngr=maNgr(norm.olin),
                Nsc=maNsc(norm.olin),Nsr=maNsr(norm.olin),main="OLIN")

# OPTIMISED SCALED LOCAL INTENSITY-DEPENDENT NORMALISATION
  norm.oslin <- olin(sw[,1],X=sw.xy$X[,1],Y=sw.xy$Y[,1],OSLIN=TRUE)
# MA-PLOT
  plot(maA(norm.oslin),maM(norm.oslin),main="OSLIN")
# MXY-PLOT
  mxy.plot(maM(norm.oslin)[,1],Ngc=maNgc(norm.oslin),Ngr=maNgr(norm.oslin),
                 Nsc=maNsc(norm.oslin),Nsr=maNsr(norm.oslin),main="OSLIN")




