### Name: knnB
### Title: An interface to various machine learning methods for
###   ExpressionSets
### Aliases: allClass stat.diag.daB
###   stat.diag.daB,ExpressionSet,character,integer-method cvB knn1B knnP
###   lcaB logitboostB lvq2B lvq3B olvq1B predLabels RObject knnB nnetB
###   lvq1B naiveBayesB svmB baggingB ipredknnB sldaB ldaB qdaB pamrB
###   rpartB randomForestB gbmB allClass,classifOutput-method
###   cvB,ExpressionSet,character-method predLabels,MLOutput-method
###   predLabels,classifOutput-method last.warning distMat,MLOutput-method
###   RObject,MLOutput-method trainInds,classifOutput-method
###   show,probMat-method show,probArray-method show,membMat-method
###   show,qualScore-method show,silhouetteVec-method show,MLOutput-method
###   baggingB,ExpressionSet,character,integer-method
###   gbmB,ExpressionSet,character,integer-method
###   ipredknnB,ExpressionSet,character,integer-method
###   knn1B,ExpressionSet,character,integer-method
###   knnB,ExpressionSet,character,integer-method
###   lcaB,ExpressionSet,numeric-method
###   ldaB,ExpressionSet,character,integer-method
###   logitboostB,ExpressionSet,character,integer,numeric-method
###   lvq1B,ExpressionSet,character,integer-method
###   lvq2B,ExpressionSet,character,integer-method
###   lvq3B,ExpressionSet,character,integer-method
###   naiveBayesB,ExpressionSet,character,integer-method
###   nnetB,ExpressionSet,character,integer-method
###   olvq1B,ExpressionSet,character,integer-method
###   pamrB,ExpressionSet,character,integer-method
###   qdaB,ExpressionSet,character,integer-method
###   randomForestB,ExpressionSet,character,integer-method
###   rpartB,ExpressionSet,character,integer-method
###   sldaB,ExpressionSet,character,integer-method
###   svmB,ExpressionSet,character,integer-method
### Keywords: classif

### ** Examples

# access and trim an ExpressionSet
library(golubEsets)
data(Golub_Merge)
smallG <- Golub_Merge[1:60,]
# set a PRNG seed for reproducibilitiy
set.seed(1234) # needed for nnet initialization
# now run the classifiers
knnB( smallG, "ALL.AML", 1:40 )
nnetB( smallG, "ALL.AML", 1:40, size=5, decay=.01 )
lvq1B( smallG, "ALL.AML", 1:40 )
naiveBayesB( smallG, "ALL.AML", 1:40 )
svmB( smallG, "ALL.AML", 1:40 )
baggingB( smallG, "ALL.AML", 1:40 )
ipredknnB( smallG, "ALL.AML", 1:40 )
sldaB( smallG, "ALL.AML", 1:40 )
ldaB( smallG, "ALL.AML", 1:40 )
qdaB( smallG[1:10,], "ALL.AML", 1:40 )
pamrB( smallG, "ALL.AML", 1:40 )
rpartB( smallG, "ALL.AML", 1:35 )
randomForestB( smallG, "ALL.AML", 1:35 )
gbmB( smallG, "ALL.AML", 1:40, n.minobsinnode=3 , n.trees=6000)
stat.diag.daB( smallG, "ALL.AML", 1:40 )



