### Name: plot.MCRestimate
### Title: Plot method for a objects of class MCRestimate
### Aliases: plot.MCRestimate
### Keywords: hplot

### ** Examples

  library(MCRestimate)
  x <- c(0.5, 0.3, 0.7, 0.3, 0.8, 0.2, 0.3)
  mat2 <- cbind(x, 1-x)
  fac2 <- factor(c("low", rep("high", 3), rep("low", 3)))
  colnames(mat2) <- levels(fac2)

  mat3 <- cbind(x/3, 2*x/3, 1-x)
  fac3 <- factor(c(rep("high", 3), rep("intermediate", 2), rep("low", 2)))
  colnames(mat3) <- levels(fac3)
if (interactive()) {
  x11(width=9, height=9)
  par(mfrow=c(3,1))}
  plot.MCRestimate(mat2, fac2)
  plot.MCRestimate(mat2, fac2, sample.order=FALSE)
  plot.MCRestimate(mat3, fac3)



