### Name: msa
### Title: Relative mean square calculation function
### Aliases: msa
### Keywords: math

### ** Examples

#library
library(Biobase)
library(LMGene)

#data
#data
data(Smpd0)

# model information 
for(i in 1:length(Smpd0@phenoData@varLabels)){
  assign(paste('x', i, sep=''),as.factor(Smpd0@phenoData@pData[,i]))
}
  
fchar=''
for(i in 1:length(Smpd0@phenoData@varLabels)){
  fchar=paste(fchar, paste('x', i, sep=''), ifelse(i<length(Smpd0@phenoData@varLabels), '+', ''), sep='')
}
fchar2 <- paste("y ~",fchar)
#
# run regression and anovas
y <- t(as.matrix(Smpd0@exprs))
formobj <- as.formula(fchar2)
tmp <- lm(formobj)
tmp2 <- mlm2lm(tmp,i)
tmp3 <- anova(tmp2)$Mean
tmp4 <- msa(tmp3)
rbind(tmp3, tmp4)




