### Name: unifyMappings
### Title: A function to unify mapping result from different sources
### Aliases: unifyMappings
### Keywords: manip

### ** Examples

## Not run: 
##D myDir <- file.path(.path.package("AnnBuilder"), "temp")
##D geneNMap <- matrix(c("32468_f_at", "D90278", "32469_at", "L00693",
##D                    "32481_at", "AL031663", "33825_at", " X68733",
##D                    "35730_at", "X03350", "36512_at", "L32179",
##D                    "38912_at", "D90042", "38936_at", "M16652",
##D                    "39368_at", "AL031668"), ncol = 2, byrow = TRUE)
##D colnames(geneNMap) <- c("PROBE", "ACCNUM")
##D write.table(geneNMap, file = file.path(myDir, "geneNMap"), sep = "\t",
##D quote = FALSE, row.names = FALSE, col.names = FALSE)
##D 
##D temp <- matrix(c("32468_f_at", NA, "32469_at", "2",
##D                    "32481_at", NA, "33825_at", " 9",
##D                    "35730_at", "1576", "36512_at", NA,
##D                    "38912_at", "10", "38936_at", NA,
##D                    "39368_at", NA), ncol = 2, byrow = TRUE)
##D temp
##D write.table(temp, file = file.path(myDir, "srcone"), sep = "\t",
##D quote = FALSE, row.names = FALSE, col.names = FALSE)
##D temp <- matrix(c("32468_f_at", NA, "32469_at", NA,
##D                    "32481_at", "7051", "33825_at", NA,
##D                    "35730_at", NA, "36512_at", "1084",
##D                    "38912_at", NA, "38936_at", NA,
##D                    "39368_at", "89"), ncol = 2, byrow = TRUE)
##D temp
##D write.table(temp, file = file.path(myDir, "srctwo"), sep = "\t",
##D quote = FALSE, row.names = FALSE, col.names = FALSE)
##D otherMapping <- c(srcone = file.path(myDir, "srcone"),
##D srctwo = file.path(myDir, "srctwo"))
##D 
##D baseFile <-  file.path(myDir, "geneNMap")
##D egParser <- file.path(.path.package("AnnBuilder"), "scripts", "gbLLParser")
##D ugParser <- file.path(.path.package("AnnBuilder"), "scripts", "gbUGParser")
##D #if(.Platform$OS.type == "unix"){
##D     egUrl <-  "http://www.bioconductor.org/datafiles/wwwsources"
##D     ugUrl <-  "http://www.bioconductor.org/datafiles/wwwsources/Ths.data.gz"
##D     fromWeb = TRUE
##D #}else{
##D #    egUrl <- file.path(.path.package("AnnBuilder"), "data", "Tll_tmpl")
##D #    ugUrl <- file.path(.path.package("AnnBuilder"), "data", "Ths.data")
##D #    fromWeb = FALSE
##D #}
##D eg <- EG(srcUrl = egUrl, parser = egParser, baseFile = baseFile,
##D accession = "Tll_tmpl.gz")
##D ug <- UG(srcUrl = ugUrl, parser = ugParser, baseFile = baseFile,
##D organism = "Homo sapiens") 
##D # Only works interactively
##D     unified <- unifyMappings(base =  geneNMap, eg = eg, ug = ug,
##D                otherSrc = otherMapping)
##D     read.table(unified, sep = "\t", header = FALSE)
##D 
##D     unlink(c(file.path(myDir, "geneNMap"), file.path(myDir, "srcone"),
##D     file.path(myDir, "srctwo"), unified))
## End(Not run)



