## ----message = FALSE-------------------------------------------------------
library(transcriptogramer)
t <- transcriptogramPreprocess(association = association, ordering = Hs900)

## ----message = FALSE-------------------------------------------------------
## during the preprocessing

## creating the object and setting the radius as 0
t <- transcriptogramPreprocess(association = association, ordering = Hs900)

## creating the object and setting the radius as 50
t <- transcriptogramPreprocess(association = association, ordering = Hs900,
                                radius = 50)

## ----message = FALSE-------------------------------------------------------
## after the preprocessing

## modifying the radius of an existing Transcriptogram object
radius(object = t) <- 25

## getting the radius of an existing Transcriptogram object
r <- radius(object = t)

## ----message = FALSE-------------------------------------------------------
oPropertiesR25 <- orderingProperties(object = t, nCores = 1)

## slight change of radius
radius(object = t) <- 30

## this output is partially different comparing to oPropertiesR25
oPropertiesR30 <- orderingProperties(object = t, nCores = 1)

## ----message = FALSE-------------------------------------------------------
cProperties <- connectivityProperties(object = t)

## ----message = FALSE-------------------------------------------------------
t <- transcriptogramStep1(object = t, expression = GSE9988,
                          dictionary = GPL570, nCores = 1)

## ----message = FALSE-------------------------------------------------------
t <- transcriptogramStep2(object = t, nCores = 1)

## ----message = FALSE-------------------------------------------------------
radius(object = t) <- 50
t <- transcriptogramStep2(object = t, nCores = 1)

## ----message = FALSE, fig.show = "hide"------------------------------------
levels <- c(rep(FALSE, 3), rep(TRUE, 3))
t <- differentiallyExpressed(object = t, levels = levels, pValue = 0.005)

## ----eval = FALSE----------------------------------------------------------
#  ## translating ENSEMBL Peptide IDs to Symbols using the biomaRt package
#  ## Internet connection is required for this command
#  t <- differentiallyExpressed(object = t, levels = levels, pValue = 0.005,
#                               species = "Homo sapiens")
#  
#  ## translating ENSEMBL Peptide IDs to Symbols using the DEsymbols dataset
#  t <- differentiallyExpressed(object = t, levels = levels, pValue = 0.005,
#                               species = DEsymbols)

## ----message = FALSE-------------------------------------------------------
DE <- DE(object = t)

## ----eval = FALSE----------------------------------------------------------
#  rdp <- clusterVisualization(object = t)

## ----message = FALSE-------------------------------------------------------
## using the HsBPTerms dataset to create the gene2GO list
terms <- clusterEnrichment(object = t, species = HsBPTerms,
                           pValue = 0.005, nCores = 1)

## ----eval = FALSE----------------------------------------------------------
#  ## using the biomaRt package to create the gene2GO list
#  ## Internet connection is required for this command
#  terms <- clusterEnrichment(object = t, species = "Homo sapiens",
#                             pValue = 0.005, nCores = 1)

## ----echo = FALSE----------------------------------------------------------
load("terms.RData")

## --------------------------------------------------------------------------
head(terms)

## --------------------------------------------------------------------------
sessionInfo()

## --------------------------------------------------------------------------
warnings()

