## ----environment, echo=FALSE-----------------------------------------------
suppressPackageStartupMessages(library("topdownr"))
suppressPackageStartupMessages(library("BiocStyle"))

## ----writeMethodXml, eval=FALSE--------------------------------------------
#  library("topdownr")
#  
#  ## MS1 parameters (you could also use and modify
#  ## the output of `defaultMs1Settings()`)
#  parMS1 <- list(
#      FirstMass = 400,
#      LastMass = 1600,
#      Microscans = 10
#  )
#  
#  ## MS2 parameters (you could also use and modify
#  ## the output of `defaultMs2Settings()`)
#  parMS2  <- list(
#      OrbitrapResolution = "R120K",
#      IsolationWindow = 1,
#      MaxITTimeInMS = 200,
#      ETDSupplementalActivation = c("ETciD", "EThcD"),
#      ActivationType = "ETD",
#      Microscans = 40,
#      ETDSupplementalActivationEnergy = seq (0, 35, 7),
#      ETDReactionTime = c (0, 2.5, 5, 10, 15, 30, 50),
#      ETDReagentTarget = c(1e6, 5e6, 1e7),
#      AgcTarget = c(1e5, 5e5, 1e6)
#  )
#  
#  ## Create the XML files for mz == 707
#  writeMethodXmls(ms1Settings = parMS1,
#                  ms2Settings = parMS2,
#                  replications = 1,
#                  groupBy = "ETDReagentTarget",
#                  mz = cbind(mass=707.3, z=1),
#                  massLabeling = TRUE,
#                  nMs2perMs1 = 1000,
#                  duration = 0.5,
#                  randomise = FALSE,
#                  pattern = "method707_%s.xml")
#  
#  ## Create the XML files for mz == 893
#  writeMethodXmls(ms1Settings = parMS1,
#                  ms2Settings = parMS2,
#                  replications = 1,
#                  groupBy = "ETDReagentTarget",
#                  mz = cbind(mass=893.1, z=1),
#                  massLabeling = TRUE,
#                  nMs2perMs1 = 1000,
#                  duration = 0.5,
#                  randomise = FALSE,
#                  pattern = "method893_%s.xml")
#  
#  ## Create the XML files for mz == 1211
#  writeMethodXmls(ms1Settings = parMS1,
#                  ms2Settings = parMS2,
#                  replications = 1,
#                  groupBy = "ETDReagentTarget",
#                  mz = cbind(mass=1211.7, z=1),
#                  massLabeling = TRUE,
#                  nMs2perMs1 = 1000,
#                  duration = 0.5,
#                  randomise = FALSE,
#                  pattern = "method1211_%s.xml")
#  
#  ## Run XMLMethodChanger
#  runXmlMethodChanger(
#      modificationXml=list.files(pattern="^method.*\\.xml$"),
#      templateMeth="TMS2IndependentTemplateForTD.meth",
#      executable="path\\to\\XmlMethodChanger.exe"
#  )

## ----ScanHeadsman, eval=FALSE----------------------------------------------
#  runScanHeadsman(
#      path="path\\to\\raw-files",
#      executable="path\\to\\ScanHeadsman.exe"
#  )

## ----sessioninfo-----------------------------------------------------------
sessionInfo()

