## ----echo=FALSE------------------------------------------------------------
library(specL)
library(BiocStyle)

## --------------------------------------------------------------------------
lapply(c("SCHTAVGR", "SCHTGLGR", "EDLIAYLK"), ssrc)

## --------------------------------------------------------------------------
.plot.rt_ssrc <- function(x, y, ...){
  fit <- lm(y~x)
  plot(x, y, ylab='ssrc predicted RT', xlab='RT',
       cex=2,
       asp=1,
       ...)
  
  abline(fit)
  abline(a=0, b=1, col='grey', lwd=2)
  
  legend("topleft", 
         c(paste("spearman", round(cor(x, y, method='spearman'),2)),
           paste('R-squared', round(summary(fit)$r.squared,2)))
         )
} 

## ---- fig.width=5, fig.height=5, fig.retina=1, warning=FALSE, echo = FALSE, message = FALSE----

ssrc <- unlist(lapply(peptideStd, function(x){ssrc(x$peptideSequence)}))
rt <- unlist(lapply(peptideStd, function(x){x$rt}))
type <-as.integer(as.factor(unlist(lapply(peptideStd, function(x){x$peptideSequence}))))
.plot.rt_ssrc(ssrc, rt, col=type)

## --------------------------------------------------------------------------
library(msqc1)

## --------------------------------------------------------------------------
msqc1.8rep.aggregate <- msqc1:::.reshape_rt(msqc1_8rep, peptides=peptides, plot=FALSE)
msqc1.dilution.aggregate <- msqc1:::.reshape_rt(msqc1_dil, peptides=peptides, plot=FALSE)

## --------------------------------------------------------------------------
msqc1.peptide.ssrc <- unlist(lapply(as.character(msqc1.dilution.aggregate$Peptide.Sequence), ssrc))
                    

## ----fig.width=12, fig.height=3, fig.retina=1, echo=FALSE------------------
op <- par(mfrow=c(1,5))
type <- as.integer(msqc1.8rep.aggregate$Peptide.Sequence)
.plot.rt_ssrc(msqc1.8rep.aggregate$Retention.Time.QExactive,  msqc1.peptide.ssrc, col=type, pch=type, main='QExactive')

.plot.rt_ssrc(msqc1.8rep.aggregate$Retention.Time.QExactiveHF, msqc1.peptide.ssrc, col=type, pch=type, main='QExactiveHF')

.plot.rt_ssrc(msqc1.8rep.aggregate$Retention.Time.QTRAP, msqc1.peptide.ssrc, col=type, pch=type, main='QTRAP')

.plot.rt_ssrc(msqc1.8rep.aggregate$Retention.Time.TSQVantage, msqc1.peptide.ssrc, col=type, pch=type, main='TSQVantage')

.plot.rt_ssrc(msqc1.8rep.aggregate$Retention.Time.TRIPLETOF, msqc1.peptide.ssrc, col=type, pch=type, main='TRIPLETOF')

## ----fig.width=12, fig.height=3, fig.retina=1, echo=FALSE------------------
op <- par(mfrow=c(1,5))
type <- as.integer(msqc1.dilution.aggregate$Peptide.Sequence)
.plot.rt_ssrc(msqc1.dilution.aggregate$Retention.Time.QExactive,  msqc1.peptide.ssrc, col=type, pch=type, main='QExactive')

.plot.rt_ssrc(msqc1.dilution.aggregate$Retention.Time.QExactiveHF, msqc1.peptide.ssrc, col=type, pch=type, main='QExactiveHF')


.plot.rt_ssrc(msqc1.dilution.aggregate$Retention.Time.QTRAP, msqc1.peptide.ssrc, col=type, pch=type, main='QTRAP')


.plot.rt_ssrc(msqc1.dilution.aggregate$Retention.Time.TSQVantage, msqc1.peptide.ssrc, col=type, pch=type, main='TSQVantage')


.plot.rt_ssrc(msqc1.dilution.aggregate$Retention.Time.TRIPLETOF, msqc1.peptide.ssrc, col=type, pch=type, main='TRIPLETOF')


## ---- cache=FALSE----------------------------------------------------------
sessionInfo()

