## ----knitr-options, echo=FALSE, message=FALSE, warning=FALSE---------------
## To render an HTML version that works nicely with github and web pages, do:
## rmarkdown::render("vignettes/vignette.Rmd", "all")
library(knitr)
opts_chunk$set(fig.align = 'center', fig.width = 6, fig.height = 5, dev = 'png')
library(ggplot2)
theme_set(theme_bw(12))

## ----quickstart-load-data, message=FALSE, warning=FALSE--------------------
suppressPackageStartupMessages(library(scater))
data("sc_example_counts")
data("sc_example_cell_info")

## ----quickstart-make-sce, results='hide'-----------------------------------
example_sce <- SingleCellExperiment(
    assays = list(counts = sc_example_counts), colData = sc_example_cell_info)

## ----quickstart-add-exprs, results='hide'----------------------------------
exprs(example_sce) <- log2(
    calculateCPM(example_sce, use.size.factors = FALSE) + 1)

## ----filter-no-exprs-------------------------------------------------------
keep_feature <- rowSums(exprs(example_sce) > 0) > 0
example_sce <- example_sce[keep_feature,]

## ----quick-start-calc-qc-metrics, eval=FALSE-------------------------------
#  example_sce <- calculateQCMetrics(example_sce, feature_controls = 1:40)

## ----quick-start-gui, eval=FALSE-------------------------------------------
#  scater_gui(example_sce)

## ----plot-sceset-blocking, eval=FALSE--------------------------------------
#  plot(example_sceset, block1 = "Mutation_Status", block2 = "Treatment",
#       colour_by = "Cell_Cycle", nfeatures = 300, exprs_values = "counts")

## ----calc-qc-metrics, eval=FALSE-------------------------------------------
#  example_sceset <- calculateQCMetrics(example_sceset, feature_controls = 1:20)
#  varLabels(example_sceset)

## ----calc-qc-metrics-multi-feature-controls, eval=FALSE--------------------
#  example_sceset <- calculateQCMetrics(
#      example_sceset, feature_controls = list(controls1 = 1:20, controls2 = 500:1000),
#      cell_controls = list(set_1 = 1:5, set_2 = 31:40))
#  varLabels(example_sceset)

## ----list-fdata-qc, eval=FALSE---------------------------------------------
#  names(fData(example_sceset))

## ----plot-qc-expression, fig.height=7.5, fig.width=8.5, eval=FALSE---------
#  keep_feature <- rowSums(counts(example_sceset) > 0) > 4
#  example_sceset <- example_sceset[keep_feature,]
#  ## Plot QC
#  plotQC(example_sceset, type = "highest-expression", exprs_values = "counts")

## ----plot-qc-expression-cell-controls, fig.height=7.5, fig.width=8.5, fig.show=FALSE, eval=FALSE----
#  p1 <- plotQC(example_sceset[, !example_sceset$is_cell_control],
#               type = "highest-expression")
#  p2 <- plotQC(example_sceset[, example_sceset$is_cell_control],
#         type = "highest-expression")
#  multiplot(p1, p2, cols = 2)

## ----plot-qc-exprs-freq-vs-mean-default, eval=FALSE------------------------
#  plotQC(example_sceset, type = "exprs-freq-vs-mean")

## ----plot-qc-exprs-mean-vs-freq-defined-feature-set, results = 'hide', fig.show = FALSE, eval=FALSE----
#  feature_set_1 <- fData(example_sceset)$is_feature_control_controls1
#  plotQC(example_sceset, type = "exprs-freq-vs-mean", feature_set = feature_set_1)

## ----plot-fdata, eval=FALSE------------------------------------------------
#  plotFeatureData(example_sceset, aes(x = n_cells_exprs, y = pct_total_counts))

## ----plot-pdata, echo=FALSE, fig.show=FALSE, results='hide', eval=FALSE----
#  plotPhenoData(example_sceset, aes(x = total_counts, y = total_features,
#                                    colour = Mutation_Status))

## ----plot-pdata-cont-col, fig.show = TRUE, eval=FALSE----------------------
#  plotPhenoData(example_sceset, aes(x = Mutation_Status, y = total_features,
#                                    colour = log10_total_counts))

## ----plot-pdata-col-gene-exprs, eval=FALSE---------------------------------
#  plotPhenoData(example_sceset, aes(x = total_counts, y = total_features,
#                                    colour = Gene_1000))

## ----plot-pdatacol-gene-exprs-2, fig.show = FALSE, eval=FALSE--------------
#  plotPhenoData(example_sceset, aes(x = pct_counts_feature_controls,
#                                    y = total_features, colour = Gene_0500))

## ----plot-pdatacol-gene-exprs-3, fig.show = FALSE, eval=FALSE--------------
#  plotPhenoData(example_sceset, aes(x = pct_counts_feature_controls,
#                                    y = pct_counts_top_50_features,
#                                    colour = Gene_0001))

## ----plot-pdata-pct-exprs-controls, eval=FALSE-----------------------------
#  plotPhenoData(example_sceset, aes(x = total_features,
#                                    y = pct_counts_feature_controls,
#                                    colour = Mutation_Status)) +
#      theme(legend.position = "top") +
#      stat_smooth(method = "lm", se = FALSE, size = 2, fullrange = TRUE)

## ----plot-pca-outlier, eval=FALSE------------------------------------------
#  example_sceset <- plotPCA(example_sceset, pca_data_input = "pdata",
#                            detect_outliers = TRUE, return_SCESet = TRUE)
#  

## ----plot-qc-expl-variables-all, warning=FALSE, eval=FALSE-----------------
#  plotQC(example_sceset, type = "expl")

## ----plot-qc-expl-variables-select-variables, eval=FALSE-------------------
#  plotQC(example_sceset, type = "expl",
#         variables = c("total_features", "total_counts", "Mutation_Status", "Treatment",
#                       "Cell_Cycle"))

## ----plot-qc-pairs-pc, eval=FALSE------------------------------------------
#  plotQC(example_sceset, type = "expl", method = "pairs", theme_size = 6)

## ----plot-qc-find-pcs-pcs-vs-vars, fig.width=8, fig.height=7, eval=FALSE----
#  p1 <- plotQC(example_sceset, type = "find-pcs", variable = "total_features",
#          plot_type = "pcs-vs-vars")
#  p2 <- plotQC(example_sceset, type = "find-pcs", variable = "Cell_Cycle",
#         plot_type = "pcs-vs-vars")
#  multiplot(p1, p2, cols = 2)

## ----plot-qc-find-pcs-pairs, fig.width=10, fig.height=7, eval=FALSE--------
#  plotQC(example_sceset, type = "find-pcs", variable = "total_features",
#         plot_type = "pairs-pcs")

## ----plot-qc-find-pcs-pairs-2, fig.show=FALSE, eval=FALSE------------------
#  plotQC(example_sceset, type = "find-pcs", variable = "Cell_Cycle",
#         plot_type = "pairs-pcs")

