## ----knitr-options, echo=FALSE, message=FALSE, warning=FALSE---------------
## To render an HTML version that works nicely with github and web pages, do:
## rmarkdown::render("vignettes/vignette.Rmd", "all")
library(knitr)
opts_chunk$set(fig.align = 'center', fig.width = 6, fig.height = 5, dev = 'png')
library(ggplot2)
theme_set(theme_bw(12))

## ----sceset-make-sce-minimal-----------------------------------------------
data("sc_example_counts")
example_sce <- SingleCellExperiment(assays = list(counts = sc_example_counts))
example_sce

## ----sceset-make-sceset-counts-only----------------------------------------
data("sc_example_cell_info")
gene_df <- DataFrame(Gene = rownames(sc_example_counts))
rownames(gene_df) <- gene_df$Gene
example_sce <- SingleCellExperiment(assays = list(counts = sc_example_counts), 
                                    colData = sc_example_cell_info, 
                                    rowData = gene_df)
example_sce

## ----normalise, eval=TRUE--------------------------------------------------
example_sce <- normalise(example_sce)

## ----cpm, eval=TRUE--------------------------------------------------------
logcounts(example_sce) <- log2(calculateCPM(example_sce, 
                                            use.size.factors = FALSE) + 1)

## ----counts-accessor, eval=TRUE--------------------------------------------
counts(example_sce)[1:3, 1:6]

## ----exprs-accessor, eval=TRUE---------------------------------------------
exprs(example_sce)[1:3, 1:6]

## ----assay, eval=FALSE-----------------------------------------------------
#  assay(example_sce, "counts")[1:3, 1:6]

## ----assay-set, eval=TRUE--------------------------------------------------
assay(example_sce, "counts") <- counts(example_sce)

## ----sce-demo-replacement, eval=TRUE---------------------------------------
gene_df <- DataFrame(Gene = rownames(sc_example_counts))
rownames(gene_df) <- gene_df$Gene
## replace rowData (previously featureData)
rowData(example_sce) <- gene_df
## replace colData (previously phenotype data)
colData(example_sce) <- DataFrame(sc_example_cell_info)

