/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence;

import java.util.LinkedHashMap;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.DNASequence;
import org.biojava3.core.sequence.GeneSequence;
import org.biojava3.core.sequence.Strand;
import org.biojava3.core.sequence.compound.DNACompoundSet;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.SequenceReader;

public class ChromosomeSequence
extends DNASequence {
    private int chromosomeNumber;
    private LinkedHashMap<String, GeneSequence> geneSequenceHashMap = new LinkedHashMap();

    public ChromosomeSequence() {
    }

    public ChromosomeSequence(String seqString) {
        super(seqString, (CompoundSet<NucleotideCompound>)DNACompoundSet.getDNACompoundSet());
    }

    public ChromosomeSequence(SequenceReader<NucleotideCompound> proxyLoader) {
        super(proxyLoader, (CompoundSet<NucleotideCompound>)DNACompoundSet.getDNACompoundSet());
    }

    public ChromosomeSequence(String seqString, CompoundSet<NucleotideCompound> compoundSet) {
        super(seqString, compoundSet);
    }

    public ChromosomeSequence(SequenceReader<NucleotideCompound> proxyLoader, CompoundSet<NucleotideCompound> compoundSet) {
        super(proxyLoader, compoundSet);
    }

    public int getChromosomeNumber() {
        return this.chromosomeNumber;
    }

    public void setChromosomeNumber(int chromosomeNumber) {
        this.chromosomeNumber = chromosomeNumber;
    }

    public LinkedHashMap<String, GeneSequence> getGeneSequences() {
        return this.geneSequenceHashMap;
    }

    public GeneSequence removeGeneSequence(String accession) {
        return (GeneSequence)this.geneSequenceHashMap.remove(accession);
    }

    public GeneSequence addGene(AccessionID accession, int bioBegin, int bioEnd, Strand strand) {
        GeneSequence geneSequence = new GeneSequence(this, bioBegin, bioEnd, strand);
        geneSequence.setAccession(accession);
        this.geneSequenceHashMap.put(accession.toString(), geneSequence);
        return geneSequence;
    }

    public GeneSequence getGene(String accession) {
        return this.geneSequenceHashMap.get(accession);
    }
}

