/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.massspectrometry;

import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public abstract class Spectrum
extends ExperimentObject {
    static final long serialVersionUID = 7152424141470431489L;
    protected String spectrumTitle;
    protected String fileName;
    protected int level;
    protected HashMap<Double, Peak> peakList;
    protected HashMap<Double, ArrayList<Peak>> intensityPeakMap = null;
    protected String scanNumber;
    protected double scanStartTime;
    public static final String SPECTRUM_KEY_SPLITTER = "_cus_";
    private double[][] jFreePeakList = null;
    private double[] mzValuesAsArray = null;
    private Boolean mzOrdered = false;
    private double[] intensityValuesAsArray = null;
    private double[][] mzAndIntensityAsArray = null;
    private Double totalIntensity;
    private Double maxIntensity;
    private Double maxMz;
    private Double minMz;

    public static String getSpectrumKey(String spectrumFile, String spectrumTitle) {
        return spectrumFile + SPECTRUM_KEY_SPLITTER + spectrumTitle;
    }

    public static String getSpectrumFile(String spectrumKey) {
        return spectrumKey.substring(0, spectrumKey.indexOf(SPECTRUM_KEY_SPLITTER)).trim();
    }

    public static String getSpectrumTitle(String spectrumKey) {
        return spectrumKey.substring(spectrumKey.indexOf(SPECTRUM_KEY_SPLITTER) + SPECTRUM_KEY_SPLITTER.length()).trim();
    }

    public void setSpectrumTitle(String spectrumTitle) {
        this.spectrumTitle = spectrumTitle;
    }

    public String getSpectrumKey() {
        return this.fileName + SPECTRUM_KEY_SPLITTER + this.spectrumTitle;
    }

    public String getSpectrumTitle() {
        return this.spectrumTitle;
    }

    public double[][] getJFreePeakList() {
        if (this.jFreePeakList == null) {
            double[] mz = new double[this.peakList.size()];
            double[] intensity = new double[this.peakList.size()];
            int cpt = 0;
            for (Peak currentPeak : this.peakList.values()) {
                mz[cpt] = currentPeak.mz;
                intensity[cpt] = currentPeak.intensity;
                ++cpt;
            }
            this.jFreePeakList = new double[6][mz.length];
            this.jFreePeakList[0] = mz;
            this.jFreePeakList[1] = mz;
            this.jFreePeakList[2] = mz;
            this.jFreePeakList[3] = intensity;
            this.jFreePeakList[4] = intensity;
            this.jFreePeakList[5] = intensity;
        }
        return this.jFreePeakList;
    }

    public HashMap<Double, Peak> getPeakMap() {
        return this.peakList;
    }

    public void addPeak(Peak aPeak) {
        if (this.peakList == null) {
            this.peakList = new HashMap();
        }
        this.peakList.put(aPeak.mz, aPeak);
    }

    public void setPeaks(ArrayList<Peak> peaks) {
        if (this.peakList != null) {
            this.peakList.clear();
        } else {
            this.peakList = new HashMap();
        }
        for (Peak p : peaks) {
            double mz = p.mz;
            this.peakList.put(mz, p);
        }
    }

    public String getScanNumber() {
        return this.scanNumber;
    }

    public void setScanNumber(String scanNumber) {
        this.scanNumber = scanNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLevel() {
        return this.level;
    }

    public Collection<Peak> getPeakList() {
        return this.peakList.values();
    }

    public void setPeakList(HashMap<Double, Peak> peakList) {
        this.peakList = peakList;
    }

    public double getScanStartTime() {
        return this.scanStartTime;
    }

    public void setScanStartTime(double scanStartTime) {
        this.scanStartTime = scanStartTime;
    }

    public void removePeakList() {
        if (this.peakList != null) {
            this.peakList.clear();
        }
    }

    public double[] getMzValuesAsArray() {
        if (this.mzValuesAsArray == null) {
            this.mzValuesAsArray = new double[this.peakList.size()];
            int counter = 0;
            Iterator<Double> i$ = this.peakList.keySet().iterator();
            while (i$.hasNext()) {
                double currentMz;
                this.mzValuesAsArray[counter] = currentMz = i$.next().doubleValue();
                ++counter;
            }
        }
        return this.mzValuesAsArray;
    }

    public double[] getOrderedMzValues() {
        if (this.mzOrdered == null || !this.mzOrdered.booleanValue()) {
            this.getMzValuesAsArray();
            Arrays.sort(this.mzValuesAsArray);
            this.mzOrdered = true;
        }
        return this.mzValuesAsArray;
    }

    public double[] getIntensityValuesAsArray() {
        if (this.intensityValuesAsArray == null) {
            this.intensityValuesAsArray = new double[this.peakList.size()];
            int counter = 0;
            for (Peak currentPeak : this.peakList.values()) {
                this.intensityValuesAsArray[counter] = currentPeak.intensity;
                ++counter;
            }
        }
        return this.intensityValuesAsArray;
    }

    public double[][] getMzAndIntensityAsArray() {
        if (this.mzAndIntensityAsArray == null) {
            this.mzAndIntensityAsArray = new double[2][this.peakList.size()];
            int i = 0;
            for (double mz : this.getOrderedMzValues()) {
                Peak currentPeak = this.peakList.get(mz);
                this.mzAndIntensityAsArray[0][i] = currentPeak.mz;
                this.mzAndIntensityAsArray[1][i] = currentPeak.intensity;
                ++i;
            }
        }
        return this.mzAndIntensityAsArray;
    }

    public double getTotalIntensity() {
        if (this.totalIntensity == null) {
            this.totalIntensity = 0.0;
            for (Peak currentPeak : this.peakList.values()) {
                this.totalIntensity = this.totalIntensity + currentPeak.intensity;
            }
        }
        return this.totalIntensity;
    }

    public double getMaxIntensity() {
        if (this.maxIntensity == null) {
            this.maxIntensity = 0.0;
            for (Peak currentPeak : this.peakList.values()) {
                if (!(currentPeak.intensity > this.maxIntensity)) continue;
                this.maxIntensity = currentPeak.intensity;
            }
        }
        return this.maxIntensity;
    }

    public double getMaxMz() {
        if (this.maxMz == null) {
            this.maxMz = Collections.max(this.peakList.keySet());
        }
        return this.maxMz;
    }

    public double getMinMz() {
        if (this.minMz == null) {
            this.minMz = Collections.min(this.peakList.keySet());
        }
        return this.minMz;
    }

    public ArrayList<Double> getPeaksAboveIntensityThreshold(double threshold) {
        ArrayList<Double> peakIntensities = new ArrayList<Double>();
        for (Peak currentPeak : this.peakList.values()) {
            if (!(currentPeak.intensity > threshold)) continue;
            peakIntensities.add(currentPeak.intensity);
        }
        return peakIntensities;
    }

    public double getIntensityLimit(double intensityLimit) {
        ArrayList<Double> intensities = new ArrayList<Double>(this.peakList.size());
        for (Peak peak : this.peakList.values()) {
            intensities.add(peak.intensity);
        }
        if (intensities.isEmpty()) {
            return 0.0;
        }
        Collections.sort(intensities);
        int index = (int)((double)(intensities.size() - 1) * intensityLimit);
        return (Double)intensities.get(index);
    }

    public HashMap<Double, Peak> getRecalibratedPeakList(HashMap<Double, Double> mzCorrections) throws IllegalArgumentException {
        HashMap<Double, Peak> result = new HashMap<Double, Peak>(this.peakList.size());
        ArrayList<Double> keys = new ArrayList<Double>(mzCorrections.keySet());
        Collections.sort(keys);
        for (Peak peak : this.peakList.values()) {
            double fragmentMz = peak.mz;
            double key1 = keys.get(0);
            double correction = 0.0;
            if (fragmentMz <= key1) {
                correction = mzCorrections.get(key1);
            } else {
                key1 = keys.get(keys.size() - 1);
                if (fragmentMz >= key1) {
                    correction = mzCorrections.get(key1);
                } else {
                    for (int i = 0; i < keys.size() - 1; ++i) {
                        key1 = keys.get(i);
                        if (key1 == fragmentMz) {
                            correction = mzCorrections.get(key1);
                            break;
                        }
                        double key2 = keys.get(i + 1);
                        if (!(key1 < fragmentMz) || !(fragmentMz < key2)) continue;
                        double y1 = mzCorrections.get(key1);
                        double y2 = mzCorrections.get(key2);
                        correction = y1 + (fragmentMz - key1) * (y2 - y1) / (key2 - key1);
                        break;
                    }
                }
            }
            result.put(peak.mz - correction, new Peak(peak.mz - correction, peak.intensity));
        }
        return result;
    }

    public HashMap<Double, Peak> getDesignaledPeakList(ArrayList<IonMatch> matches) {
        HashMap<Double, Peak> result = new HashMap<Double, Peak>(this.peakList);
        for (IonMatch ionMatch : matches) {
            result.remove(ionMatch.peak.mz);
        }
        return result;
    }

    public HashMap<Double, Peak> getSubSpectrum(double mzMin, double mzMax) {
        HashMap<Double, Peak> result = new HashMap<Double, Peak>();
        for (double mz : this.getOrderedMzValues()) {
            if (mz >= mzMin && mz < mzMax) {
                result.put(mz, this.peakList.get(mz));
                continue;
            }
            if (mz >= mzMax) break;
        }
        return result;
    }

    public HashMap<Double, ArrayList<Peak>> getIntensityMap() {
        if (this.intensityPeakMap == null) {
            this.intensityPeakMap = new HashMap(this.peakList.size());
            for (Peak peak : this.peakList.values()) {
                double intensity = peak.intensity;
                ArrayList<Peak> peaksAtIntensity = this.intensityPeakMap.get(intensity);
                if (peaksAtIntensity == null) {
                    peaksAtIntensity = new ArrayList();
                    this.intensityPeakMap.put(intensity, peaksAtIntensity);
                }
                peaksAtIntensity.add(peak);
            }
        }
        return this.intensityPeakMap;
    }

    public int getNPeaks() {
        if (this.peakList == null) {
            return 0;
        }
        return this.peakList.size();
    }
}

