/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.examples;

import com.compomics.util.Export;
import com.compomics.util.Util;
import com.compomics.util.enumeration.ImageType;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.examples.HelpWindow;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.general.IsotopicDistribution;
import com.compomics.util.gui.UtilitiesGUIDefaults;
import com.compomics.util.gui.events.RescalingEvent;
import com.compomics.util.gui.interfaces.SpectrumAnnotation;
import com.compomics.util.gui.interfaces.SpectrumPanelListener;
import com.compomics.util.gui.protein.ProteinSequencePane;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.gui.spectrum.ChromatogramPanel;
import com.compomics.util.gui.spectrum.DefaultSpectrumAnnotation;
import com.compomics.util.gui.spectrum.IsotopicDistributionPanel;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import com.compomics.util.io.MascotEnzymeReader;
import com.compomics.util.io.PklFile;
import com.compomics.util.io.filefilters.PdfFileFilter;
import com.compomics.util.protein.AASequenceImpl;
import com.compomics.util.protein.Enzyme;
import com.compomics.util.protein.Header;
import com.compomics.util.protein.Protein;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import no.uib.jsparklines.extra.NimbusCheckBoxRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerColorTableCellRenderer;
import org.apache.batik.transcoder.TranscoderException;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXTable;
import org.jfree.chart.plot.PlotOrientation;

public class UtilitiesDemo
extends JFrame {
    private HashMap<Integer, Color> peffAnnotationsColorMap;
    private HashMap<Integer, String> peffAnnotationsTooltipMap;
    private boolean peffFormat = true;
    private TreeMap<String, String> keyValuePairs;
    private File currentSequenceFile;
    private BufferedReader currentPeffBufferedReader;
    private String currentSequence = "";
    private String currentSequenceLine;
    private HashMap<Integer, SpectrumPanel> linkedSpectrumPanels;
    private HashMap<Integer, Vector<SpectrumAnnotation>> allAnnotations;
    private SpectrumPanel spectrumAPanel;
    private SpectrumPanel spectrumBPanel;
    private int spectrumPanelMaxPadding = 50;
    private int chromatogramPanelMaxPadding = 65;
    private MascotEnzymeReader mascotEnzymeReader = null;
    private String cleanProteinSequence = null;
    private HashMap<String, Color> selectedAnnotationTypes;
    private ArrayList<String> sequenceAnnotationColumnHeaderTooltips = new ArrayList();
    private Color sparklineColor = new Color(110, 196, 97);
    private JCheckBox H2OIonsJCheckBox;
    private JCheckBox NH3IonsJCheckBox;
    private JCheckBox aIonsJCheckBox;
    private JCheckBox allPeaksJCheckBox;
    private JCheckBox bIonsJCheckBox;
    private JButton browseJButton;
    private JCheckBox cIonsJCheckBox;
    private JCheckBox chargeOneJCheckBox;
    private JCheckBox chargeOverTwoJCheckBox;
    private JSpinner chargePeptideAJSpinner;
    private JSpinner chargePeptideBJSpinner;
    private JCheckBox chargeTwoJCheckBox;
    private JPanel chromatogramAJPanel;
    private JPanel chromatogramJPanel;
    private JLabel chromatogramPanelHelpJLabel;
    private JLabel chromatogramPanelInfoJLabel;
    private JComboBox enzymesJComboBox;
    private JButton exportJButton;
    private JLabel inSilicoDigestionHelpJLabel;
    private JEditorPane informationJEditorPane;
    private JPanel informationJPanel;
    private JScrollPane informationJScrollPane;
    private JTextField inhibitorsJTextField;
    private JPanel ionSelectionJPanel;
    private JPanel isotopicDistributionAJPanel;
    private JLabel isotopicDistributionCalculatorHelpJLabel;
    private JLabel isotopicDistributionCalculatorInfoJLabel;
    private JPanel isotopicDistributionJPanel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel24;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JRadioButton jRadioButton1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator9;
    private JTabbedPane jTabbedPane;
    private JCheckBox linkedSpectraJCheckBox;
    private JSpinner lowerMassJSpinner;
    private JSpinner missedCleavagesJSpinner;
    private JButton nextJButton;
    private JCheckBox otherIonsJCheckBox;
    private JTable peffAnnotationsJTable;
    private JTable peffHeaderJTable;
    private JPanel peptideAColorJPanel;
    private JTextField peptideACompositionJTextField;
    private JScrollPane peptideAJScrollPane;
    private JXTable peptideAJXTable;
    private JTextField peptideAMzJTextField;
    private JPanel peptideBColorJPanel;
    private JTextField peptideBCompositionJTextField;
    private JScrollPane peptideBJScrollPane;
    private JXTable peptideBJXTable;
    private JTextField peptideBMzJTextField;
    private JTextField peptideSequenceAJTextField;
    private JTextField peptideSequenceBJTextField;
    private JPanel peptidesJPanel;
    private JTable peptidesJTable;
    private JScrollPane peptidesScrollPane;
    private JTextField positionJTextField;
    private JCheckBox profileSpectrumJCheckBox;
    private JScrollPane proteinCoverageJScrollPane;
    private JLabel proteinDigestionJLabel;
    private JPanel proteinDigestionJPanel;
    private JTable proteinHeaderJTable;
    private JEditorPane proteinSequenceCoverageJEditorPane;
    private JPanel sequenceCoverageJPanel;
    private JTextField sequenceFileJTextField;
    private JTabbedPane sequenceJTabbedPane;
    private JComboBox silacLabelPeptideAJComboBox;
    private JComboBox silacLabelPeptideBJComboBox;
    private JTextField siteJTextField;
    private JPanel spectraJPanel;
    private JPanel spectrumAJPanel;
    private JPanel spectrumBJPanel;
    private JPanel spectrumJPanel;
    private JLabel spectrumPanelHelpJLabel;
    private JLabel spectrumPanelInfoJLabel;
    private JSpinner upperMassJSpinner;
    private JCheckBox xIonsJCheckBox;
    private JCheckBox yIonsJCheckBox;
    private JCheckBox zIonsJCheckBox;

    public UtilitiesDemo() {
        this.initComponents();
        this.keyValuePairs = new TreeMap();
        this.selectedAnnotationTypes = new HashMap();
        this.setTitle(this.getTitle() + " " + this.getVersion() + " - Demo");
        this.insertInformationTabText();
        this.silacLabelPeptideAJComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.silacLabelPeptideBJComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.enzymesJComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.setColumnProperties();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/compomics-utilities.png")));
        this.setUpSpectrumPanelDemo();
        this.setUpChromatogramPanelDemo();
        this.setUpIsotopicDistributionPanelDemo();
        this.setUpInSilicoDigestionDemo();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void setColumnProperties() {
        this.peptidesJTable.getTableHeader().setReorderingAllowed(false);
        this.peptideAJXTable.getTableHeader().setReorderingAllowed(false);
        this.peptideBJXTable.getTableHeader().setReorderingAllowed(false);
        this.peffHeaderJTable.getTableHeader().setReorderingAllowed(false);
        this.peffAnnotationsJTable.getTableHeader().setReorderingAllowed(false);
        this.proteinHeaderJTable.getTableHeader().setReorderingAllowed(false);
        this.peptidesJTable.getColumn(" ").setMinWidth(40);
        this.peptidesJTable.getColumn(" ").setMaxWidth(40);
        this.peptidesJTable.getColumn("Start").setMinWidth(40);
        this.peptidesJTable.getColumn("Start").setMaxWidth(40);
        this.peptidesJTable.getColumn("End").setMinWidth(40);
        this.peptidesJTable.getColumn("End").setMaxWidth(40);
        this.peffHeaderJTable.getColumn(" ").setMinWidth(40);
        this.peffHeaderJTable.getColumn(" ").setMaxWidth(40);
        this.proteinHeaderJTable.getColumn(" ").setMinWidth(40);
        this.proteinHeaderJTable.getColumn(" ").setMaxWidth(40);
        this.peffAnnotationsJTable.getColumn(" ").setMinWidth(40);
        this.peffAnnotationsJTable.getColumn(" ").setMaxWidth(40);
        this.peffAnnotationsJTable.getColumn("F").setMinWidth(40);
        this.peffAnnotationsJTable.getColumn("F").setMaxWidth(40);
        this.peffAnnotationsJTable.getColumn("B").setMinWidth(40);
        this.peffAnnotationsJTable.getColumn("B").setMaxWidth(40);
        this.peffAnnotationsJTable.getColumn("  ").setMinWidth(40);
        this.peffAnnotationsJTable.getColumn("  ").setMaxWidth(40);
        this.peffAnnotationsJTable.getColumn("  ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.sequenceAnnotationColumnHeaderTooltips.add(null);
        this.sequenceAnnotationColumnHeaderTooltips.add("Term");
        this.sequenceAnnotationColumnHeaderTooltips.add("Foreground Color");
        this.sequenceAnnotationColumnHeaderTooltips.add("Background Color");
        this.sequenceAnnotationColumnHeaderTooltips.add("Selected");
        this.peptidesJTable.getColumn("Mass").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(10.0), this.sparklineColor));
        ((JSparklinesBarChartTableCellRenderer)this.peptidesJTable.getColumn("Mass").getCellRenderer()).showNumberAndChart(true, 50);
    }

    private void insertInformationTabText() {
        String htmlText = "<html><head></head><body><h1>Compomics-Utilities</h1><p style=\"margin-top: 0\">The <a href=\"http://www.compomics.com\">Computational Omics Group</a> at the <a href=\"http://www.ugent.be/en\">University of Ghent</a> develops various bioinformatics tools for analyzing omics data.<br><br>Compomics-utilities is a library containing code shared by many of our research projects, amongst others containing panels <br>for visualizing spectra and chromatograms  and objects for representing peptides and proteins etc.  We believe that this library<br>can be of use to other research groups doing computational proteomics, and have therefore made it available as open source.<br><br>This demo contains four examples of how the library can be used. For the complete source code of the examples, see the<br><i>com.compomics.util.examples</i> package. Click the tabs at the top to select one of the demos.<br><br>Additional info can be found at the project's <a href=\"http://googlecode.com\">Google Code</a> home page: <a href=\"http://compomics-utilities.googlecode.com\">http://compomics-utilities.googlecode.com</a>.</p><br><br><br><br><b>The Computational Omics Group is grateful to be supported by:<b><br><br><a href=\"http://www.compomics.com\"><img src=\"" + this.getClass().getResource("/icons/compomics.png") + "\" border=\"0\" width=\"222\" height=\"111\"></a>" + "<a href=\"http://www.ugent.be/en\"><img src=\"" + this.getClass().getResource("/icons/ugent.png") + "\" border=\"0\"></a>" + "<a href=\"http://www.vib.be\"><img src=\"" + this.getClass().getResource("/icons/vib.png") + "\" border=\"0\"></a>" + "<a href=\"http://java.com/en\"><img src=\"" + this.getClass().getResource("/icons/java.png") + "\" border=\"0\"></a>" + "<a href=\"http://maven.apache.org\"><img src=\"" + this.getClass().getResource("/icons/maven.png") + "\" border=\"0\"></a>" + "<a href=\"http://www.jetbrains.com/idea/\"><img src=\"" + this.getClass().getResource("/icons/intelliJ.png") + "\" border=\"0\"></a>" + "<a href=\"http://www.yourkit.com/\"><img src=\"" + this.getClass().getResource("/icons/yourkit.png") + "\" border=\"0\"></a>" + "</body>" + "</html>";
        this.informationJEditorPane.setText(htmlText);
    }

    private void setUpInSilicoDigestionDemo() {
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("enzymes.txt");
            if (in != null) {
                this.mascotEnzymeReader = new MascotEnzymeReader(in);
                Object[] allEnzymeNames = this.mascotEnzymeReader.getEnzymeNames();
                Arrays.sort(allEnzymeNames);
                this.enzymesJComboBox.setModel(new DefaultComboBoxModel<Object>(allEnzymeNames));
                this.enzymesJComboBox.setSelectedItem("Trypsin");
                this.enzymesJComboBoxActionPerformed(null);
                if (this.peptidesJTable.getRowCount() > 0) {
                    this.peptidesJTable.setRowSelectionInterval(0, 0);
                    this.formatProteinSequence();
                }
            } else {
                JOptionPane.showMessageDialog(this, "enzymes.txt not found...", "Error Setting Up In Silico Digestion Demo", 0);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error Setting Up In Silico Digestion Demo", 0);
        }
    }

    private void setUpIsotopicDistributionPanelDemo() {
        this.isotopicDistributionAJPanel.removeAll();
        this.peptideAColorJPanel.setBackground(new JButton().getBackground());
        this.peptideBColorJPanel.setBackground(new JButton().getBackground());
        try {
            String labelPeptideA = (String)this.silacLabelPeptideAJComboBox.getSelectedItem();
            int labelDifferencePeptideA = 0;
            if (labelPeptideA.startsWith("+")) {
                labelDifferencePeptideA = Integer.valueOf(labelPeptideA.substring(1));
            }
            IsotopicDistributionPanel isotopicDistributionPanel = new IsotopicDistributionPanel(this.peptideSequenceAJTextField.getText(), (Integer)this.chargePeptideAJSpinner.getValue(), true, labelDifferencePeptideA);
            AASequenceImpl peptideSequence = isotopicDistributionPanel.getPeptideSequences().get(0);
            IsotopicDistribution lIso = peptideSequence.getIsotopicDistribution();
            if (labelDifferencePeptideA > 0) {
                lIso.setLabelDifference(labelDifferencePeptideA);
            }
            DefaultTableModel dm = (DefaultTableModel)this.peptideAJXTable.getModel();
            dm.getDataVector().removeAllElements();
            for (int i = 0; i < 15; ++i) {
                if (!(Util.roundDouble(lIso.getPercTot()[i], 2) > 0.0)) continue;
                ((DefaultTableModel)this.peptideAJXTable.getModel()).addRow(new Object[]{i, Math.floor(lIso.getPercTot()[i] * 10000.0) / 100.0, Math.floor(lIso.getPercMax()[i] * 10000.0) / 100.0});
            }
            this.peptideAColorJPanel.setBackground(isotopicDistributionPanel.getAreaUnderCurveColors().get(0));
            this.peptideAMzJTextField.setText("" + Util.roundDouble(peptideSequence.getMz((Integer)this.chargePeptideAJSpinner.getValue()) + (double)labelDifferencePeptideA, 4));
            if (labelDifferencePeptideA > 0) {
                this.peptideACompositionJTextField.setText(peptideSequence.getMolecularFormula().toString() + " + " + labelDifferencePeptideA + "n");
            } else {
                this.peptideACompositionJTextField.setText(peptideSequence.getMolecularFormula().toString());
            }
            if (this.peptideSequenceBJTextField.getText().length() > 0) {
                String labelPeptideB = (String)this.silacLabelPeptideBJComboBox.getSelectedItem();
                int labelDifferencePeptideB = 0;
                if (labelPeptideB.startsWith("+")) {
                    labelDifferencePeptideB = Integer.valueOf(labelPeptideB.substring(1));
                }
                isotopicDistributionPanel.addAdditionalDataset(this.peptideSequenceBJTextField.getText(), (Integer)this.chargePeptideBJSpinner.getValue(), Color.BLUE, new Color(85, 85, 255), labelDifferencePeptideB);
                peptideSequence = isotopicDistributionPanel.getPeptideSequences().get(1);
                lIso = peptideSequence.getIsotopicDistribution();
                if (labelDifferencePeptideB > 0) {
                    lIso.setLabelDifference(labelDifferencePeptideB);
                }
                dm = (DefaultTableModel)this.peptideBJXTable.getModel();
                dm.getDataVector().removeAllElements();
                for (int i = 0; i < 15; ++i) {
                    if (!(Util.roundDouble(lIso.getPercTot()[i], 2) > 0.0)) continue;
                    ((DefaultTableModel)this.peptideBJXTable.getModel()).addRow(new Object[]{i, Math.floor(lIso.getPercTot()[i] * 10000.0) / 100.0, Math.floor(lIso.getPercMax()[i] * 10000.0) / 100.0});
                }
                this.peptideBColorJPanel.setBackground(isotopicDistributionPanel.getAreaUnderCurveColors().get(1));
                this.peptideBMzJTextField.setText("" + Util.roundDouble(peptideSequence.getMz((Integer)this.chargePeptideBJSpinner.getValue()) + (double)labelDifferencePeptideB, 4));
                if (labelDifferencePeptideB > 0) {
                    this.peptideBCompositionJTextField.setText(peptideSequence.getMolecularFormula().toString() + " + " + labelDifferencePeptideB + "n");
                } else {
                    this.peptideBCompositionJTextField.setText(peptideSequence.getMolecularFormula().toString());
                }
            } else {
                this.peptideBMzJTextField.setText("");
                this.peptideBCompositionJTextField.setText("");
                dm = (DefaultTableModel)this.peptideBJXTable.getModel();
                dm.getDataVector().removeAllElements();
            }
            isotopicDistributionPanel.setBorder(null);
            this.isotopicDistributionAJPanel.add(isotopicDistributionPanel);
            this.isotopicDistributionAJPanel.validate();
            this.isotopicDistributionAJPanel.repaint();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error Setting Up Isotopic Distributions", 0);
        }
    }

    private void setUpChromatogramPanelDemo() {
        File chromatogramFile = new File(this.getJarFilePath() + "/exampleFiles/exampleChromatogram.txt");
        ArrayList<Double> xValuesAsArray = new ArrayList<Double>();
        ArrayList<Double> yValuesAsArray = new ArrayList<Double>();
        try {
            FileReader f = new FileReader(chromatogramFile);
            BufferedReader b = new BufferedReader(f);
            String currentLine = b.readLine();
            while (currentLine != null) {
                String[] peakDetails = currentLine.split(" ");
                if (peakDetails.length != 2) {
                    throw new IOException("Error reading chromatogram file - incorrect number of peak paramaters!");
                }
                xValuesAsArray.add(new Double(peakDetails[0]));
                yValuesAsArray.add(new Double(peakDetails[1]));
                currentLine = b.readLine();
            }
            b.close();
            f.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error reading chromatogram data:\n" + e.toString(), "Error Reading Chromatogram Data", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error reading chromatogram data:\n" + e.toString(), "Error Reading Chromatogram Data", 0);
            e.printStackTrace();
        }
        double[] xValues = new double[xValuesAsArray.size()];
        double[] yValues = new double[yValuesAsArray.size()];
        for (int i = 0; i < xValuesAsArray.size(); ++i) {
            xValues[i] = (Double)xValuesAsArray.get(i);
            yValues[i] = (Double)yValuesAsArray.get(i);
        }
        ChromatogramPanel chromatogramPanel = new ChromatogramPanel(xValues, yValues, "Time (minutes)", "Intensity (number of counts)");
        chromatogramPanel.setMaxPadding(this.chromatogramPanelMaxPadding);
        chromatogramPanel.setBorder(null);
        this.chromatogramAJPanel.add(chromatogramPanel);
        this.chromatogramAJPanel.validate();
        this.chromatogramAJPanel.repaint();
    }

    private void setUpSpectrumPanelDemo() {
        this.linkedSpectrumPanels = new HashMap();
        this.allAnnotations = new HashMap();
        try {
            File spectrumFile = new File(this.getJarFilePath() + "/exampleFiles/exampleSpectrumA.pkl");
            PklFile pklFileA = new PklFile(spectrumFile);
            this.spectrumAPanel = this.getSpectrumPanel(pklFileA, this.profileSpectrumJCheckBox.isSelected());
            Vector<SpectrumAnnotation> currentAnnotations = new Vector<SpectrumAnnotation>();
            currentAnnotations.add(new DefaultSpectrumAnnotation(175.119495, -0.006822999999997137, SpectrumPanel.determineColorOfPeak("y1"), "y1"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(389.251235, 4.6299999996790575E-4, SpectrumPanel.determineColorOfPeak("y3"), "y3"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(460.288345, -0.003290999999990163, SpectrumPanel.determineColorOfPeak("y4"), "y4"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(559.356755, -2.4200000007112976E-4, SpectrumPanel.determineColorOfPeak("y5"), "y5"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(660.404435, -0.002686000000039712, SpectrumPanel.determineColorOfPeak("y6"), "y6"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(820.4350840000001, 8.09999999091815E-5, SpectrumPanel.determineColorOfPeak("y7"), "y7"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(271.177006, -0.003444999999999254, SpectrumPanel.determineColorOfPeak("y2-NH3"), "y2-NH3"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(288.203555, -0.002484999999978754, SpectrumPanel.determineColorOfPeak("y2"), "y2"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(158.092946, -5.020000000115488E-4, SpectrumPanel.determineColorOfPeak("y1-NH3"), "y1-NH3"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(372.224686, 0.001030999999954929, SpectrumPanel.determineColorOfPeak("y3-NH3"), "y3-NH3"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(443.261796, 0.0025039999999876272, SpectrumPanel.determineColorOfPeak("y4-NH3"), "y4-NH3"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(274.12253400000003, 0.00181899999995494, SpectrumPanel.determineColorOfPeak("b2"), "b2"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(458.20561749999996, 0.05911150000002863, SpectrumPanel.determineColorOfPeak("Prec-H2O 2+"), "Prec-H2O 2+"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(129.0, 0.10726900000000228, SpectrumPanel.determineColorOfPeak("iR"), "iR"));
            this.allAnnotations.put(0, currentAnnotations);
            this.spectrumAPanel.setAnnotations(currentAnnotations);
            this.linkedSpectrumPanels.put(0, this.spectrumAPanel);
            this.spectrumAPanel.setBorder(null);
            this.spectrumAJPanel.add(this.spectrumAPanel);
            this.spectrumAJPanel.validate();
            this.spectrumAJPanel.repaint();
            spectrumFile = new File(this.getJarFilePath() + "/exampleFiles/exampleSpectrumB.pkl");
            PklFile pklFileB = new PklFile(spectrumFile);
            this.spectrumBPanel = this.getSpectrumPanel(pklFileB, this.profileSpectrumJCheckBox.isSelected());
            currentAnnotations = new Vector();
            currentAnnotations.add(new DefaultSpectrumAnnotation(175.119495, -0.010621000000014647, SpectrumPanel.determineColorOfPeak("y1"), "y1"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(387.27196499999997, -0.0044499999999629836, SpectrumPanel.determineColorOfPeak("y3"), "y3"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(500.356025, -0.002353999999968437, SpectrumPanel.determineColorOfPeak("y4"), "y4"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(571.393135, -0.004269000000022061, SpectrumPanel.determineColorOfPeak("y5"), "y5"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(685.436065, -0.013534999999933461, SpectrumPanel.determineColorOfPeak("y6"), "y6"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(813.494645, 0.005993999999986954, SpectrumPanel.determineColorOfPeak("y7"), "y7"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(257.161356, -0.007209999999986394, SpectrumPanel.determineColorOfPeak("y2-NH3"), "y2-NH3"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(370.245416, -9.159999999610591E-4, SpectrumPanel.determineColorOfPeak("y3-NH3"), "y3-NH3"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(796.468096, 0.0018540000000939472, SpectrumPanel.determineColorOfPeak("y7-NH3"), "y7-NH3"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(274.187905, -0.004702000000008866, SpectrumPanel.determineColorOfPeak("y2"), "y2"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(158.092946, -0.008444000000025653, SpectrumPanel.determineColorOfPeak("y1-NH3"), "y1-NH3"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(668.4095159999999, 0.0019680000000334985, SpectrumPanel.determineColorOfPeak("y6-NH3"), "y6-NH3"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(276.134815, -0.002712000000030912, SpectrumPanel.determineColorOfPeak("b2"), "b2"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(259.108266, -0.004803000000038082, SpectrumPanel.determineColorOfPeak("b2-NH3"), "b2-NH3"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(242.164738, -0.08587800000000811, SpectrumPanel.determineColorOfPeak("y4++-NH3"), "y4++-NH3"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(129.0, 0.09981500000000665, SpectrumPanel.determineColorOfPeak("iR"), "iR"));
            currentAnnotations.add(new DefaultSpectrumAnnotation(120.0, 0.08159999999999457, SpectrumPanel.determineColorOfPeak("iF"), "iF"));
            this.allAnnotations.put(1, currentAnnotations);
            this.spectrumBPanel.setAnnotations(currentAnnotations);
            this.linkedSpectrumPanels.put(1, this.spectrumBPanel);
            this.spectrumBPanel.setBorder(null);
            this.spectrumBJPanel.add(this.spectrumBPanel);
            this.spectrumBJPanel.validate();
            this.spectrumBJPanel.repaint();
            this.aIonsJCheckBoxActionPerformed(null);
            this.allPeaksJCheckBoxActionPerformed(null);
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error reading spectrum data:\n" + e.toString(), "Error Reading Spectrum Data", 0);
        }
    }

    private SpectrumPanel getSpectrumPanel(PklFile pklFile, boolean profileMode) throws IOException {
        SpectrumPanel spectrumPanel = new SpectrumPanel(pklFile.getMzValues(), pklFile.getIntensityValues(), pklFile.getPrecursorMz(), "" + pklFile.getPrecurorCharge(), "" + pklFile.getFileName(), this.spectrumPanelMaxPadding, false, false, false, 2, profileMode);
        spectrumPanel.addSpectrumPanelListener(new SpectrumPanelListener(){

            @Override
            public void rescaled(RescalingEvent rescalingEvent) {
                SpectrumPanel source = (SpectrumPanel)rescalingEvent.getSource();
                double minMass = rescalingEvent.getMinMass();
                double maxMass = rescalingEvent.getMaxMass();
                Iterator iterator = UtilitiesDemo.this.linkedSpectrumPanels.keySet().iterator();
                while (iterator.hasNext()) {
                    SpectrumPanel currentSpectrumPanel = (SpectrumPanel)UtilitiesDemo.this.linkedSpectrumPanels.get(iterator.next());
                    if (currentSpectrumPanel == source || !UtilitiesDemo.this.linkedSpectraJCheckBox.isSelected()) continue;
                    currentSpectrumPanel.rescale(minMass, maxMass, false);
                    currentSpectrumPanel.repaint();
                }
            }
        });
        return spectrumPanel;
    }

    private String getJarFilePath() {
        String path = this.getClass().getResource("UtilitiesDemo.class").getPath();
        if (path.lastIndexOf("/utilities-") != -1) {
            path = path.startsWith("file:") ? path.substring("file:".length(), path.lastIndexOf("/utilities-")) : path.substring(0, path.lastIndexOf("/utilities-"));
            path = path.replace("%20", " ");
            path = path.replace("%5b", "[");
            path = path.replace("%5d", "]");
        } else {
            path = ".";
        }
        return path;
    }

    private void initComponents() {
        this.jRadioButton1 = new JRadioButton();
        this.jTabbedPane = new JTabbedPane();
        this.informationJPanel = new JPanel();
        this.informationJScrollPane = new JScrollPane();
        this.informationJEditorPane = new JEditorPane();
        this.spectrumJPanel = new JPanel();
        this.ionSelectionJPanel = new JPanel();
        this.aIonsJCheckBox = new JCheckBox();
        this.bIonsJCheckBox = new JCheckBox();
        this.cIonsJCheckBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.yIonsJCheckBox = new JCheckBox();
        this.xIonsJCheckBox = new JCheckBox();
        this.zIonsJCheckBox = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.chargeOneJCheckBox = new JCheckBox();
        this.chargeTwoJCheckBox = new JCheckBox();
        this.chargeOverTwoJCheckBox = new JCheckBox();
        this.jSeparator3 = new JSeparator();
        this.H2OIonsJCheckBox = new JCheckBox();
        this.NH3IonsJCheckBox = new JCheckBox();
        this.otherIonsJCheckBox = new JCheckBox();
        this.jSeparator4 = new JSeparator();
        this.jSeparator6 = new JSeparator();
        this.profileSpectrumJCheckBox = new JCheckBox();
        this.linkedSpectraJCheckBox = new JCheckBox();
        this.jSeparator5 = new JSeparator();
        this.jSeparator9 = new JSeparator();
        this.exportJButton = new JButton();
        this.allPeaksJCheckBox = new JCheckBox();
        this.spectrumPanelInfoJLabel = new JLabel();
        this.spectrumPanelHelpJLabel = new JLabel();
        this.spectraJPanel = new JPanel();
        this.jPanel7 = new JPanel();
        this.spectrumBJPanel = new JPanel();
        this.jPanel6 = new JPanel();
        this.spectrumAJPanel = new JPanel();
        this.chromatogramJPanel = new JPanel();
        this.chromatogramPanelInfoJLabel = new JLabel();
        this.chromatogramPanelHelpJLabel = new JLabel();
        this.jPanel8 = new JPanel();
        this.chromatogramAJPanel = new JPanel();
        this.isotopicDistributionJPanel = new JPanel();
        this.isotopicDistributionCalculatorInfoJLabel = new JLabel();
        this.isotopicDistributionCalculatorHelpJLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel3 = new JLabel();
        this.peptideSequenceAJTextField = new JTextField();
        this.peptideSequenceBJTextField = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel6 = new JLabel();
        this.chargePeptideAJSpinner = new JSpinner();
        this.chargePeptideBJSpinner = new JSpinner();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.silacLabelPeptideAJComboBox = new JComboBox();
        this.silacLabelPeptideBJComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.peptideAJScrollPane = new JScrollPane();
        this.peptideAJXTable = new JXTable();
        this.jLabel12 = new JLabel();
        this.peptideACompositionJTextField = new JTextField();
        this.jLabel13 = new JLabel();
        this.peptideAMzJTextField = new JTextField();
        this.peptideAColorJPanel = new JPanel();
        this.jPanel4 = new JPanel();
        this.peptideBJScrollPane = new JScrollPane();
        this.peptideBJXTable = new JXTable();
        this.jLabel14 = new JLabel();
        this.peptideBCompositionJTextField = new JTextField();
        this.jLabel15 = new JLabel();
        this.peptideBMzJTextField = new JTextField();
        this.peptideBColorJPanel = new JPanel();
        this.jPanel5 = new JPanel();
        this.isotopicDistributionAJPanel = new JPanel();
        this.proteinDigestionJPanel = new JPanel();
        this.proteinDigestionJLabel = new JLabel();
        this.inSilicoDigestionHelpJLabel = new JLabel();
        this.jPanel11 = new JPanel();
        this.jLabel4 = new JLabel();
        this.enzymesJComboBox = new JComboBox();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.missedCleavagesJSpinner = new JSpinner();
        this.siteJTextField = new JTextField();
        this.inhibitorsJTextField = new JTextField();
        this.positionJTextField = new JTextField();
        this.jLabel20 = new JLabel();
        this.lowerMassJSpinner = new JSpinner();
        this.jLabel21 = new JLabel();
        this.upperMassJSpinner = new JSpinner();
        this.jPanel3 = new JPanel();
        this.jLabel24 = new JLabel();
        this.sequenceFileJTextField = new JTextField();
        this.browseJButton = new JButton();
        this.nextJButton = new JButton();
        this.sequenceJTabbedPane = new JTabbedPane();
        this.jPanel9 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.peffAnnotationsJTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)UtilitiesDemo.this.sequenceAnnotationColumnHeaderTooltips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.jPanel12 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.proteinHeaderJTable = new JTable();
        this.jPanel10 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.peffHeaderJTable = new JTable();
        this.peptidesJPanel = new JPanel();
        this.peptidesScrollPane = new JScrollPane();
        this.peptidesJTable = new JTable();
        this.sequenceCoverageJPanel = new JPanel();
        this.proteinCoverageJScrollPane = new JScrollPane();
        this.proteinSequenceCoverageJEditorPane = new JEditorPane();
        this.jRadioButton1.setText("jRadioButton1");
        this.setDefaultCloseOperation(3);
        this.setTitle("Compomics-Utilities");
        this.setMinimumSize(new Dimension(1000, 750));
        this.jTabbedPane.setMinimumSize(new Dimension(235, 102));
        this.jTabbedPane.setPreferredSize(new Dimension(20, 680));
        this.informationJEditorPane.setContentType("text/html");
        this.informationJEditorPane.setEditable(false);
        this.informationJEditorPane.setMargin(new Insets(30, 20, 10, 20));
        this.informationJEditorPane.setMinimumSize(new Dimension(10, 10));
        this.informationJEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                UtilitiesDemo.this.informationJEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.informationJScrollPane.setViewportView(this.informationJEditorPane);
        GroupLayout informationJPanelLayout = new GroupLayout((Container)this.informationJPanel);
        this.informationJPanel.setLayout((LayoutManager)informationJPanelLayout);
        informationJPanelLayout.setHorizontalGroup((GroupLayout.Group)informationJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)informationJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.informationJScrollPane, -1, 1178, Short.MAX_VALUE).addContainerGap()));
        informationJPanelLayout.setVerticalGroup((GroupLayout.Group)informationJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)informationJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.informationJScrollPane, -1, 600, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane.addTab("Introduction to Compomics-Utilities", this.informationJPanel);
        this.spectrumJPanel.setRequestFocusEnabled(false);
        this.ionSelectionJPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.aIonsJCheckBox.setText("a");
        this.aIonsJCheckBox.setToolTipText("Show a-ions");
        this.aIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.aIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.aIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.aIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.aIonsJCheckBoxActionPerformed(evt);
            }
        });
        this.bIonsJCheckBox.setSelected(true);
        this.bIonsJCheckBox.setText("b");
        this.bIonsJCheckBox.setToolTipText("Show b-ions");
        this.bIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.bIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.bIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.bIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.bIonsJCheckBoxActionPerformed(evt);
            }
        });
        this.cIonsJCheckBox.setText("c");
        this.cIonsJCheckBox.setToolTipText("Show c-ions");
        this.cIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.cIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.cIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.cIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.cIonsJCheckBoxActionPerformed(evt);
            }
        });
        this.yIonsJCheckBox.setSelected(true);
        this.yIonsJCheckBox.setText("y");
        this.yIonsJCheckBox.setToolTipText("Show y-ions");
        this.yIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.yIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.yIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.yIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.yIonsJCheckBoxActionPerformed(evt);
            }
        });
        this.xIonsJCheckBox.setText("x");
        this.xIonsJCheckBox.setToolTipText("Show x-ions");
        this.xIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.xIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.xIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.xIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.xIonsJCheckBoxActionPerformed(evt);
            }
        });
        this.zIonsJCheckBox.setText("z");
        this.zIonsJCheckBox.setToolTipText("Show z-ions");
        this.zIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.zIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.zIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.zIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.zIonsJCheckBoxActionPerformed(evt);
            }
        });
        this.chargeOneJCheckBox.setSelected(true);
        this.chargeOneJCheckBox.setText("+");
        this.chargeOneJCheckBox.setToolTipText("Show ions with charge 1");
        this.chargeOneJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.chargeOneJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.chargeOneJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.chargeOneJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.chargeOneJCheckBoxActionPerformed(evt);
            }
        });
        this.chargeTwoJCheckBox.setText("++");
        this.chargeTwoJCheckBox.setToolTipText("Show ions with charge 2");
        this.chargeTwoJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.chargeTwoJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.chargeTwoJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.chargeTwoJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.chargeTwoJCheckBoxActionPerformed(evt);
            }
        });
        this.chargeOverTwoJCheckBox.setText(">2");
        this.chargeOverTwoJCheckBox.setToolTipText("Show ions with charge >2");
        this.chargeOverTwoJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.chargeOverTwoJCheckBoxActionPerformed(evt);
            }
        });
        this.H2OIonsJCheckBox.setText("H2O");
        this.H2OIonsJCheckBox.setToolTipText("Show ions with H2O loss");
        this.H2OIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.H2OIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.H2OIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.H2OIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.H2OIonsJCheckBoxActionPerformed(evt);
            }
        });
        this.NH3IonsJCheckBox.setText("NH3");
        this.NH3IonsJCheckBox.setToolTipText("Show ions with NH3 loss");
        this.NH3IonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.NH3IonsJCheckBoxActionPerformed(evt);
            }
        });
        this.otherIonsJCheckBox.setText("Other");
        this.otherIonsJCheckBox.setToolTipText("Show other ions");
        this.otherIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.otherIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.otherIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.otherIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.otherIonsJCheckBoxActionPerformed(evt);
            }
        });
        this.profileSpectrumJCheckBox.setText("Profile");
        this.profileSpectrumJCheckBox.setToolTipText("Select profile or centroid mode.\n");
        this.profileSpectrumJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.profileSpectrumJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.profileSpectrumJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.profileSpectrumJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.profileSpectrumJCheckBoxActionPerformed(evt);
            }
        });
        this.linkedSpectraJCheckBox.setSelected(true);
        this.linkedSpectraJCheckBox.setText("Linked");
        this.linkedSpectraJCheckBox.setToolTipText("<html>\nLink the spectra such that zooming in one <br>\nalso results in zooming in the other.\n</html>");
        this.linkedSpectraJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.linkedSpectraJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.linkedSpectraJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.exportJButton.setText("Export");
        this.exportJButton.setToolTipText("Export the spectra to a PDF file.");
        this.exportJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.exportJButtonActionPerformed(evt);
            }
        });
        this.allPeaksJCheckBox.setText("All");
        this.allPeaksJCheckBox.setToolTipText("Display all peaks or just the annotated peaks");
        this.allPeaksJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.allPeaksJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.allPeaksJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.allPeaksJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.allPeaksJCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout ionSelectionJPanelLayout = new GroupLayout((Container)this.ionSelectionJPanel);
        this.ionSelectionJPanel.setLayout((LayoutManager)ionSelectionJPanelLayout);
        ionSelectionJPanelLayout.setHorizontalGroup((GroupLayout.Group)ionSelectionJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)ionSelectionJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)ionSelectionJPanelLayout.createParallelGroup(1).add((Component)this.allPeaksJCheckBox, -2, 65, -2).add((Component)this.jSeparator9, -1, 69, Short.MAX_VALUE).add((Component)this.jSeparator5, -1, 69, Short.MAX_VALUE).add((Component)this.jSeparator6, -1, 69, Short.MAX_VALUE).add((Component)this.jSeparator4, -1, 69, Short.MAX_VALUE).add(4, (Component)this.otherIonsJCheckBox, -2, 65, -2).add(4, (Component)this.NH3IonsJCheckBox).add(4, (Component)this.H2OIonsJCheckBox, -1, 65, Short.MAX_VALUE).add((Component)this.jSeparator3, -1, 69, Short.MAX_VALUE).add(4, (Component)this.chargeOverTwoJCheckBox).add(4, (Component)this.chargeTwoJCheckBox, -1, 65, Short.MAX_VALUE).add(4, (Component)this.chargeOneJCheckBox, -1, 65, Short.MAX_VALUE).add((Component)this.jSeparator2, -1, 69, Short.MAX_VALUE).add(4, (Component)this.zIonsJCheckBox, -1, 65, Short.MAX_VALUE).add(4, (Component)this.yIonsJCheckBox, -1, 65, Short.MAX_VALUE).add(4, (Component)this.xIonsJCheckBox, -1, 65, Short.MAX_VALUE).add((Component)this.jSeparator1, -1, 69, Short.MAX_VALUE).add(4, (Component)this.aIonsJCheckBox, -1, 65, Short.MAX_VALUE).add(4, (Component)this.bIonsJCheckBox, -1, 65, Short.MAX_VALUE).add(4, (Component)this.cIonsJCheckBox, -1, 65, Short.MAX_VALUE).add((Component)this.profileSpectrumJCheckBox, -2, 65, -2).add((Component)this.linkedSpectraJCheckBox, -2, 65, -2).add((Component)this.exportJButton, -1, 69, Short.MAX_VALUE)).addContainerGap()));
        ionSelectionJPanelLayout.linkSize(new Component[]{this.H2OIonsJCheckBox, this.NH3IonsJCheckBox, this.aIonsJCheckBox, this.bIonsJCheckBox, this.cIonsJCheckBox, this.chargeOneJCheckBox, this.chargeOverTwoJCheckBox, this.chargeTwoJCheckBox, this.linkedSpectraJCheckBox, this.otherIonsJCheckBox, this.profileSpectrumJCheckBox, this.xIonsJCheckBox, this.yIonsJCheckBox, this.zIonsJCheckBox}, 1);
        ionSelectionJPanelLayout.linkSize(new Component[]{this.jSeparator1, this.jSeparator2, this.jSeparator3, this.jSeparator4, this.jSeparator6}, 1);
        ionSelectionJPanelLayout.setVerticalGroup((GroupLayout.Group)ionSelectionJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)ionSelectionJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.aIonsJCheckBox, -2, -1, -2).addPreferredGap(0).add((Component)this.bIonsJCheckBox, -2, -1, -2).addPreferredGap(0).add((Component)this.cIonsJCheckBox, -2, -1, -2).addPreferredGap(1).add((Component)this.jSeparator1, -2, 2, -2).addPreferredGap(1).add((Component)this.xIonsJCheckBox, -2, -1, -2).addPreferredGap(0).add((Component)this.yIonsJCheckBox, -2, -1, -2).addPreferredGap(0).add((Component)this.zIonsJCheckBox, -2, -1, -2).addPreferredGap(1).add((Component)this.jSeparator2, -2, -1, -2).addPreferredGap(1).add((Component)this.chargeOneJCheckBox, -2, -1, -2).addPreferredGap(0).add((Component)this.chargeTwoJCheckBox, -2, -1, -2).addPreferredGap(0).add((Component)this.chargeOverTwoJCheckBox).addPreferredGap(1).add((Component)this.jSeparator3, -2, 2, -2).addPreferredGap(1).add((Component)this.H2OIonsJCheckBox, -2, -1, -2).addPreferredGap(0).add((Component)this.NH3IonsJCheckBox).addPreferredGap(0).add((Component)this.otherIonsJCheckBox, -2, -1, -2).addPreferredGap(1).add((Component)this.jSeparator4, -2, -1, -2).addPreferredGap(0).add((Component)this.jSeparator6, -2, -1, -2).addPreferredGap(1).add((Component)this.profileSpectrumJCheckBox, -2, -1, -2).addPreferredGap(0).add((Component)this.allPeaksJCheckBox, -2, -1, -2).addPreferredGap(0).add((Component)this.linkedSpectraJCheckBox, -2, -1, -2).addPreferredGap(1).add((Component)this.jSeparator5, -2, -1, -2).addPreferredGap(0).add((Component)this.jSeparator9, -2, -1, -2).addPreferredGap(1).add((Component)this.exportJButton).addContainerGap(73, Short.MAX_VALUE)));
        ionSelectionJPanelLayout.linkSize(new Component[]{this.H2OIonsJCheckBox, this.NH3IonsJCheckBox, this.aIonsJCheckBox, this.bIonsJCheckBox, this.cIonsJCheckBox, this.chargeOneJCheckBox, this.chargeOverTwoJCheckBox, this.chargeTwoJCheckBox, this.otherIonsJCheckBox, this.xIonsJCheckBox, this.yIonsJCheckBox, this.zIonsJCheckBox}, 2);
        this.spectrumPanelInfoJLabel.setFont(this.spectrumPanelInfoJLabel.getFont().deriveFont(this.spectrumPanelInfoJLabel.getFont().getStyle() | 2));
        this.spectrumPanelInfoJLabel.setText("Spectrum Panel makes is easy to visualize spectra with annotations. It supports zooming and calculation of distances representing amino acids.");
        this.spectrumPanelHelpJLabel.setForeground(new Color(0, 0, 255));
        this.spectrumPanelHelpJLabel.setText("<html> <a href=\\\"dummy_link\">Click here for Help</a></html>");
        this.spectrumPanelHelpJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UtilitiesDemo.this.spectrumPanelHelpJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                UtilitiesDemo.this.spectrumPanelHelpJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                UtilitiesDemo.this.spectrumPanelHelpJLabelMouseExited(evt);
            }
        });
        this.jPanel7.setBorder(BorderFactory.createTitledBorder("NH2-FQNALLVR-COOH"));
        this.jPanel7.setPreferredSize(new Dimension(1050, 265));
        this.spectrumBJPanel.setBackground(new Color(255, 255, 255));
        this.spectrumBJPanel.setBorder(BorderFactory.createEtchedBorder());
        this.spectrumBJPanel.setLayout(new BoxLayout(this.spectrumBJPanel, 2));
        GroupLayout jPanel7Layout = new GroupLayout((Container)this.jPanel7);
        this.jPanel7.setLayout((LayoutManager)jPanel7Layout);
        jPanel7Layout.setHorizontalGroup((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel7Layout.createSequentialGroup().addContainerGap().add((Component)this.spectrumBJPanel, -1, 1039, Short.MAX_VALUE).addContainerGap()));
        jPanel7Layout.setVerticalGroup((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel7Layout.createSequentialGroup().addContainerGap().add((Component)this.spectrumBJPanel, -1, 235, Short.MAX_VALUE).addContainerGap()));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder("NH2-LC<Cmm*>TVATLR-COOH"));
        this.jPanel6.setPreferredSize(new Dimension(1050, 266));
        this.spectrumAJPanel.setBackground(new Color(255, 255, 255));
        this.spectrumAJPanel.setBorder(BorderFactory.createEtchedBorder());
        this.spectrumAJPanel.setLayout(new BoxLayout(this.spectrumAJPanel, 2));
        GroupLayout jPanel6Layout = new GroupLayout((Container)this.jPanel6);
        this.jPanel6.setLayout((LayoutManager)jPanel6Layout);
        jPanel6Layout.setHorizontalGroup((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel6Layout.createSequentialGroup().addContainerGap().add((Component)this.spectrumAJPanel, -1, 1039, Short.MAX_VALUE).addContainerGap()));
        jPanel6Layout.setVerticalGroup((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel6Layout.createSequentialGroup().addContainerGap().add((Component)this.spectrumAJPanel, -1, 236, Short.MAX_VALUE).addContainerGap()));
        GroupLayout spectraJPanelLayout = new GroupLayout((Container)this.spectraJPanel);
        this.spectraJPanel.setLayout((LayoutManager)spectraJPanelLayout);
        spectraJPanelLayout.setHorizontalGroup((GroupLayout.Group)spectraJPanelLayout.createParallelGroup(1).add((Component)this.jPanel7, -1, 1071, Short.MAX_VALUE).add(2, (Component)this.jPanel6, -1, 1071, Short.MAX_VALUE));
        spectraJPanelLayout.setVerticalGroup((GroupLayout.Group)spectraJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)spectraJPanelLayout.createSequentialGroup().add((Component)this.jPanel6, -1, 285, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel7, -1, 284, Short.MAX_VALUE)));
        GroupLayout spectrumJPanelLayout = new GroupLayout((Container)this.spectrumJPanel);
        this.spectrumJPanel.setLayout((LayoutManager)spectrumJPanelLayout);
        spectrumJPanelLayout.setHorizontalGroup((GroupLayout.Group)spectrumJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)spectrumJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)spectrumJPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)spectrumJPanelLayout.createSequentialGroup().add((Component)this.spectraJPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.ionSelectionJPanel, -2, -1, -2)).add(2, (GroupLayout.Group)spectrumJPanelLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.spectrumPanelInfoJLabel).addPreferredGap(0, 397, Short.MAX_VALUE).add((Component)this.spectrumPanelHelpJLabel, -2, -1, -2))).addContainerGap()));
        spectrumJPanelLayout.setVerticalGroup((GroupLayout.Group)spectrumJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)spectrumJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)spectrumJPanelLayout.createParallelGroup(1).add((Component)this.spectraJPanel, -1, -1, Short.MAX_VALUE).add((Component)this.ionSelectionJPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)spectrumJPanelLayout.createParallelGroup(3).add((Component)this.spectrumPanelHelpJLabel, -2, -1, -2).add((Component)this.spectrumPanelInfoJLabel)).addContainerGap()));
        this.jTabbedPane.addTab("Spectrum Panel - Demo", this.spectrumJPanel);
        this.chromatogramPanelInfoJLabel.setFont(this.chromatogramPanelInfoJLabel.getFont().deriveFont(this.chromatogramPanelInfoJLabel.getFont().getStyle() | 2));
        this.chromatogramPanelInfoJLabel.setText("Chromatogram Panel makes it easy to visualize chromatograms. It supports zooming and other user interactions. ");
        this.chromatogramPanelHelpJLabel.setForeground(new Color(0, 0, 255));
        this.chromatogramPanelHelpJLabel.setText("<html> <a href=\\\"dummy_link\">Click here for Help</a></html>");
        this.chromatogramPanelHelpJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UtilitiesDemo.this.chromatogramPanelHelpJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                UtilitiesDemo.this.chromatogramPanelHelpJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                UtilitiesDemo.this.chromatogramPanelHelpJLabelMouseExited(evt);
            }
        });
        this.jPanel8.setBorder(BorderFactory.createTitledBorder("Chromatogram"));
        this.chromatogramAJPanel.setBackground(new Color(255, 255, 255));
        this.chromatogramAJPanel.setBorder(BorderFactory.createEtchedBorder());
        this.chromatogramAJPanel.setForeground(new Color(255, 255, 255));
        this.chromatogramAJPanel.setLayout(new BoxLayout(this.chromatogramAJPanel, 2));
        GroupLayout jPanel8Layout = new GroupLayout((Container)this.jPanel8);
        this.jPanel8.setLayout((LayoutManager)jPanel8Layout);
        jPanel8Layout.setHorizontalGroup((GroupLayout.Group)jPanel8Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel8Layout.createSequentialGroup().addContainerGap().add((Component)this.chromatogramAJPanel, -1, 1146, Short.MAX_VALUE).addContainerGap()));
        jPanel8Layout.setVerticalGroup((GroupLayout.Group)jPanel8Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel8Layout.createSequentialGroup().addContainerGap().add((Component)this.chromatogramAJPanel, -1, 526, Short.MAX_VALUE).addContainerGap()));
        GroupLayout chromatogramJPanelLayout = new GroupLayout((Container)this.chromatogramJPanel);
        this.chromatogramJPanel.setLayout((LayoutManager)chromatogramJPanelLayout);
        chromatogramJPanelLayout.setHorizontalGroup((GroupLayout.Group)chromatogramJPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)chromatogramJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)chromatogramJPanelLayout.createParallelGroup(2).add(1, (Component)this.jPanel8, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)chromatogramJPanelLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.chromatogramPanelInfoJLabel).addPreferredGap(0, 538, Short.MAX_VALUE).add((Component)this.chromatogramPanelHelpJLabel, -2, -1, -2))).addContainerGap()));
        chromatogramJPanelLayout.setVerticalGroup((GroupLayout.Group)chromatogramJPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)chromatogramJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.jPanel8, -1, -1, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)chromatogramJPanelLayout.createParallelGroup(3).add((Component)this.chromatogramPanelHelpJLabel, -2, -1, -2).add((Component)this.chromatogramPanelInfoJLabel)).addContainerGap()));
        this.jTabbedPane.addTab("Chromatogram Panel - Demo", this.chromatogramJPanel);
        this.isotopicDistributionJPanel.setPreferredSize(new Dimension(1187, 652));
        this.isotopicDistributionCalculatorInfoJLabel.setFont(this.isotopicDistributionCalculatorInfoJLabel.getFont().deriveFont(this.isotopicDistributionCalculatorInfoJLabel.getFont().getStyle() | 2));
        this.isotopicDistributionCalculatorInfoJLabel.setText("Isotopic Distribution Calculator calculates and visualizes the isotopic distribution of peptides.");
        this.isotopicDistributionCalculatorHelpJLabel.setForeground(new Color(0, 0, 255));
        this.isotopicDistributionCalculatorHelpJLabel.setText("<html> <a href=\\\"dummy_link\">Click here for Help</a></html>");
        this.isotopicDistributionCalculatorHelpJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UtilitiesDemo.this.isotopicDistributionCalculatorHelpJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                UtilitiesDemo.this.isotopicDistributionCalculatorHelpJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                UtilitiesDemo.this.isotopicDistributionCalculatorHelpJLabelMouseExited(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Peptide Properties"));
        this.jLabel1.setText("Peptide A:");
        this.jLabel5.setText("NH2-");
        this.jLabel3.setText("NH2-");
        this.peptideSequenceAJTextField.setHorizontalAlignment(0);
        this.peptideSequenceAJTextField.setText("PEPTIDERPEPTIDER");
        this.peptideSequenceAJTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 22));
        this.peptideSequenceAJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UtilitiesDemo.this.peptideSequenceAJTextFieldKeyReleased(evt);
            }
        });
        this.peptideSequenceBJTextField.setHorizontalAlignment(0);
        this.peptideSequenceBJTextField.setText("PEPTIDERPEPTIDER");
        this.peptideSequenceBJTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 22));
        this.peptideSequenceBJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UtilitiesDemo.this.peptideSequenceBJTextFieldKeyReleased(evt);
            }
        });
        this.jLabel7.setText("-COOH");
        this.jLabel6.setText("-COOH");
        this.chargePeptideAJSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.chargePeptideAJSpinner.setMaximumSize(new Dimension(Short.MAX_VALUE, 22));
        this.chargePeptideAJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                UtilitiesDemo.this.chargePeptideAJSpinnerStateChanged(evt);
            }
        });
        this.chargePeptideBJSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.chargePeptideBJSpinner.setMaximumSize(new Dimension(Short.MAX_VALUE, 22));
        this.chargePeptideBJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                UtilitiesDemo.this.chargePeptideBJSpinnerStateChanged(evt);
            }
        });
        this.jLabel8.setText("Charge:");
        this.jLabel9.setText("Charge:");
        this.jLabel10.setText("Neutrons:");
        this.jLabel10.setToolTipText("<html>\nThe number of additional neutrons. <br>\nFor example due to SILAC labeling.\n</html>");
        this.jLabel11.setText("Neutrons:");
        this.jLabel11.setToolTipText("<html>\nThe number of additional neutrons. <br>\nFor example due to SILAC labeling.\n</html>");
        this.silacLabelPeptideAJComboBox.setMaximumRowCount(20);
        this.silacLabelPeptideAJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "+1", "+2", "+3", "+4", "+5", "+6", "+7", "+8", "+9", "+10"}));
        this.silacLabelPeptideAJComboBox.setSelectedIndex(2);
        this.silacLabelPeptideAJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.silacLabelPeptideAJComboBoxActionPerformed(evt);
            }
        });
        this.silacLabelPeptideBJComboBox.setMaximumRowCount(20);
        this.silacLabelPeptideBJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "+1", "+2", "+3", "+4", "+5", "+6", "+7", "+8", "+9", "+10"}));
        this.silacLabelPeptideBJComboBox.setSelectedIndex(5);
        this.silacLabelPeptideBJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.silacLabelPeptideBJComboBoxActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Peptide B:");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).add(18, 18, 18).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.peptideSequenceAJTextField, -1, 735, Short.MAX_VALUE).add((Component)this.peptideSequenceBJTextField, -1, 735, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel7).add(18, 18, 18).add((Component)this.jLabel9).addPreferredGap(0).add((Component)this.chargePeptideBJSpinner, -2, 73, -2).add(18, 18, 18).add((Component)this.jLabel11).addPreferredGap(0).add((Component)this.silacLabelPeptideBJComboBox, 0, 73, Short.MAX_VALUE)).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel6).add(18, 18, 18).add((Component)this.jLabel8).addPreferredGap(0).add((Component)this.chargePeptideAJSpinner, -1, 73, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jLabel10).addPreferredGap(0).add((Component)this.silacLabelPeptideAJComboBox, -2, -1, -2))).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.silacLabelPeptideAJComboBox, this.silacLabelPeptideBJComboBox}, 1);
        jPanel1Layout.linkSize(new Component[]{this.chargePeptideAJSpinner, this.chargePeptideBJSpinner}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(13, 13, 13).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(4).add((Component)this.silacLabelPeptideAJComboBox, -2, -1, -2).add((Component)this.jLabel10).add((Component)this.chargePeptideAJSpinner, -2, 22, -2).add((Component)this.jLabel8).add((Component)this.jLabel6).add((Component)this.peptideSequenceAJTextField, -2, -1, -2).add((Component)this.jLabel3).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(4).add((Component)this.jLabel2).add((Component)this.jLabel5).add((Component)this.peptideSequenceBJTextField, -1, 22, Short.MAX_VALUE).add((Component)this.jLabel7).add((Component)this.jLabel9).add((Component)this.chargePeptideBJSpinner, -1, 22, Short.MAX_VALUE).add((Component)this.jLabel11).add((Component)this.silacLabelPeptideBJComboBox, -2, -1, -2)).add(13, 13, 13)));
        jPanel1Layout.linkSize(new Component[]{this.chargePeptideAJSpinner, this.chargePeptideBJSpinner}, 2);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Peptide A"));
        this.jPanel2.setPreferredSize(new Dimension(246, 215));
        this.peptideAJXTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Isotope", "% Total", "% Max"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Double.class, Double.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.peptideAJXTable.setOpaque(false);
        this.peptideAJScrollPane.setViewportView((Component)this.peptideAJXTable);
        this.jLabel12.setText("m/z:");
        this.jLabel12.setToolTipText("The mass over charge ratio of the peptide");
        this.peptideACompositionJTextField.setEditable(false);
        this.peptideACompositionJTextField.setHorizontalAlignment(0);
        this.peptideACompositionJTextField.setToolTipText("The elemental composition of the peptide");
        this.jLabel13.setText("Comp.:");
        this.jLabel13.setToolTipText("The elemental composition of the peptide");
        this.peptideAMzJTextField.setEditable(false);
        this.peptideAMzJTextField.setHorizontalAlignment(0);
        this.peptideAMzJTextField.setToolTipText("The mass over charge ratio of the peptide");
        this.peptideAColorJPanel.setBorder(BorderFactory.createEtchedBorder());
        this.peptideAColorJPanel.setToolTipText("The color used for Peptide A");
        GroupLayout peptideAColorJPanelLayout = new GroupLayout((Container)this.peptideAColorJPanel);
        this.peptideAColorJPanel.setLayout((LayoutManager)peptideAColorJPanelLayout);
        peptideAColorJPanelLayout.setHorizontalGroup((GroupLayout.Group)peptideAColorJPanelLayout.createParallelGroup(1).add(0, 21, Short.MAX_VALUE));
        peptideAColorJPanelLayout.setVerticalGroup((GroupLayout.Group)peptideAColorJPanelLayout.createParallelGroup(1).add(0, 18, Short.MAX_VALUE));
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (Component)this.peptideAJScrollPane, -1, 277, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel13).add((Component)this.jLabel12)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.peptideAMzJTextField, -1, 207, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.peptideAColorJPanel, -2, -1, -2)).add((Component)this.peptideACompositionJTextField, -1, 238, Short.MAX_VALUE)))).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.peptideAJScrollPane, -1, 119, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.peptideAColorJPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel12).add((Component)this.peptideAMzJTextField, -1, 22, Short.MAX_VALUE))).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel13).add((Component)this.peptideACompositionJTextField, -2, -1, -2)).addContainerGap()));
        jPanel2Layout.linkSize(new Component[]{this.peptideAColorJPanel, this.peptideACompositionJTextField, this.peptideAMzJTextField}, 2);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Peptide B"));
        this.jPanel4.setPreferredSize(new Dimension(246, 215));
        this.peptideBJXTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Isotope", "% Total", "% Max"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Double.class, Double.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.peptideBJXTable.setOpaque(false);
        this.peptideBJScrollPane.setViewportView((Component)this.peptideBJXTable);
        this.jLabel14.setText("m/z:");
        this.jLabel14.setToolTipText("The mass over charge ratio of the peptide");
        this.peptideBCompositionJTextField.setEditable(false);
        this.peptideBCompositionJTextField.setHorizontalAlignment(0);
        this.peptideBCompositionJTextField.setToolTipText("The elemental composition of the peptide");
        this.jLabel15.setText("Comp.:");
        this.jLabel15.setToolTipText("The elemental composition of the peptide");
        this.peptideBMzJTextField.setEditable(false);
        this.peptideBMzJTextField.setHorizontalAlignment(0);
        this.peptideBMzJTextField.setToolTipText("The mass over charge ratio of the peptide");
        this.peptideBColorJPanel.setBorder(BorderFactory.createEtchedBorder());
        this.peptideBColorJPanel.setToolTipText("The color used for Peptide B");
        GroupLayout peptideBColorJPanelLayout = new GroupLayout((Container)this.peptideBColorJPanel);
        this.peptideBColorJPanel.setLayout((LayoutManager)peptideBColorJPanelLayout);
        peptideBColorJPanelLayout.setHorizontalGroup((GroupLayout.Group)peptideBColorJPanelLayout.createParallelGroup(1).add(0, 21, Short.MAX_VALUE));
        peptideBColorJPanelLayout.setVerticalGroup((GroupLayout.Group)peptideBColorJPanelLayout.createParallelGroup(1).add(0, 18, Short.MAX_VALUE));
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(2).add(1, (Component)this.peptideBJScrollPane, -1, 277, Short.MAX_VALUE).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jLabel15).add((Component)this.jLabel14)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.peptideBMzJTextField, -1, 207, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.peptideBColorJPanel, -2, -1, -2)).add((Component)this.peptideBCompositionJTextField, -1, 238, Short.MAX_VALUE)))).addContainerGap()));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((Component)this.peptideBJScrollPane, -1, 119, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(2, false).add((Component)this.peptideBColorJPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.peptideBMzJTextField).add((Component)this.jLabel14))).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.peptideBCompositionJTextField, -2, -1, -2).add((Component)this.jLabel15)).addContainerGap()));
        jPanel4Layout.linkSize(new Component[]{this.peptideBColorJPanel, this.peptideBCompositionJTextField, this.peptideBMzJTextField}, 2);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Isotopic Distribution"));
        this.isotopicDistributionAJPanel.setBackground(new Color(255, 255, 255));
        this.isotopicDistributionAJPanel.setBorder(BorderFactory.createEtchedBorder());
        this.isotopicDistributionAJPanel.setLayout(new BoxLayout(this.isotopicDistributionAJPanel, 2));
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((Component)this.isotopicDistributionAJPanel, -1, 831, Short.MAX_VALUE).addContainerGap()));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((Component)this.isotopicDistributionAJPanel, -1, 417, Short.MAX_VALUE).addContainerGap()));
        GroupLayout isotopicDistributionJPanelLayout = new GroupLayout((Container)this.isotopicDistributionJPanel);
        this.isotopicDistributionJPanel.setLayout((LayoutManager)isotopicDistributionJPanelLayout);
        isotopicDistributionJPanelLayout.setHorizontalGroup((GroupLayout.Group)isotopicDistributionJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)isotopicDistributionJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)isotopicDistributionJPanelLayout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)isotopicDistributionJPanelLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.isotopicDistributionCalculatorInfoJLabel).addPreferredGap(0, 641, Short.MAX_VALUE).add((Component)this.isotopicDistributionCalculatorHelpJLabel, -2, -1, -2)).add(2, (GroupLayout.Group)isotopicDistributionJPanelLayout.createSequentialGroup().add((Component)this.jPanel5, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)isotopicDistributionJPanelLayout.createParallelGroup(2, false).add((Component)this.jPanel2, -1, 309, Short.MAX_VALUE).add((Component)this.jPanel4, -1, 309, Short.MAX_VALUE)))).addContainerGap()));
        isotopicDistributionJPanelLayout.setVerticalGroup((GroupLayout.Group)isotopicDistributionJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)isotopicDistributionJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).add((GroupLayout.Group)isotopicDistributionJPanelLayout.createParallelGroup(2).add((GroupLayout.Group)isotopicDistributionJPanelLayout.createSequentialGroup().add(8, 8, 8).add((Component)this.jPanel2, -1, 229, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel4, -1, 229, Short.MAX_VALUE)).add((GroupLayout.Group)isotopicDistributionJPanelLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.jPanel5, -1, -1, Short.MAX_VALUE))).addPreferredGap(1).add((GroupLayout.Group)isotopicDistributionJPanelLayout.createParallelGroup(3).add((Component)this.isotopicDistributionCalculatorHelpJLabel, -2, -1, -2).add((Component)this.isotopicDistributionCalculatorInfoJLabel)).addContainerGap()));
        this.jTabbedPane.addTab("Isotopic Distribution Panel - Demo", this.isotopicDistributionJPanel);
        this.proteinDigestionJPanel.setPreferredSize(new Dimension(20, 20));
        this.proteinDigestionJLabel.setFont(this.proteinDigestionJLabel.getFont().deriveFont(this.proteinDigestionJLabel.getFont().getStyle() | 2));
        this.proteinDigestionJLabel.setText("In Silico Protein Digestion theoretically cleaves a protein sequence to calculate the number of peptides, the maximum protein coverage etc.");
        this.inSilicoDigestionHelpJLabel.setForeground(new Color(0, 0, 255));
        this.inSilicoDigestionHelpJLabel.setText("<html> <a href=\\\"dummy_link\">Click here for Help</a></html>");
        this.inSilicoDigestionHelpJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UtilitiesDemo.this.inSilicoDigestionHelpJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                UtilitiesDemo.this.inSilicoDigestionHelpJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                UtilitiesDemo.this.inSilicoDigestionHelpJLabelMouseExited(evt);
            }
        });
        this.jPanel11.setBorder(BorderFactory.createTitledBorder("Enzyme"));
        this.jLabel4.setText("Enzyme:");
        this.enzymesJComboBox.setMaximumRowCount(20);
        this.enzymesJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{" - Select -"}));
        this.enzymesJComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                UtilitiesDemo.this.enzymesJComboBoxPopupMenuWillBecomeVisible(evt);
            }
        });
        this.enzymesJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.enzymesJComboBoxActionPerformed(evt);
            }
        });
        this.jLabel16.setText("Site:");
        this.jLabel17.setText("Inhibitors:");
        this.jLabel18.setText("Position:");
        this.jLabel19.setText("Missed Cleavages:");
        this.missedCleavagesJSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.missedCleavagesJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                UtilitiesDemo.this.missedCleavagesJSpinnerStateChanged(evt);
            }
        });
        this.siteJTextField.setEditable(false);
        this.siteJTextField.setHorizontalAlignment(0);
        this.inhibitorsJTextField.setEditable(false);
        this.inhibitorsJTextField.setHorizontalAlignment(0);
        this.positionJTextField.setEditable(false);
        this.positionJTextField.setHorizontalAlignment(0);
        this.jLabel20.setText("Lower:");
        this.lowerMassJSpinner.setModel(new SpinnerNumberModel((Number)500, Integer.valueOf(0), null, (Number)100));
        this.lowerMassJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                UtilitiesDemo.this.lowerMassJSpinnerStateChanged(evt);
            }
        });
        this.jLabel21.setText("Upper:");
        this.upperMassJSpinner.setModel(new SpinnerNumberModel((Number)3500, Integer.valueOf(0), null, (Number)100));
        this.upperMassJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                UtilitiesDemo.this.upperMassJSpinnerStateChanged(evt);
            }
        });
        GroupLayout jPanel11Layout = new GroupLayout((Container)this.jPanel11);
        this.jPanel11.setLayout((LayoutManager)jPanel11Layout);
        jPanel11Layout.setHorizontalGroup((GroupLayout.Group)jPanel11Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel11Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel11Layout.createParallelGroup(1).add((Component)this.jLabel19).add((Component)this.jLabel4).add((Component)this.jLabel18).add((Component)this.jLabel17).add((Component)this.jLabel16)).addPreferredGap(0).add((GroupLayout.Group)jPanel11Layout.createParallelGroup(1).add((Component)this.inhibitorsJTextField, -1, 326, Short.MAX_VALUE).add(2, (Component)this.siteJTextField, -1, 326, Short.MAX_VALUE).add(2, (Component)this.positionJTextField, -1, 326, Short.MAX_VALUE).add((Component)this.enzymesJComboBox, 0, 326, Short.MAX_VALUE).add((GroupLayout.Group)jPanel11Layout.createSequentialGroup().add((Component)this.missedCleavagesJSpinner, -2, 69, -2).add(18, 18, 18).add((Component)this.jLabel20).addPreferredGap(0).add((Component)this.lowerMassJSpinner, -2, 63, -2).add(18, 18, 18).add((Component)this.jLabel21).addPreferredGap(0).add((Component)this.upperMassJSpinner, -2, 70, -2))).addContainerGap()));
        jPanel11Layout.linkSize(new Component[]{this.jLabel20, this.jLabel21}, 1);
        jPanel11Layout.linkSize(new Component[]{this.lowerMassJSpinner, this.upperMassJSpinner}, 1);
        jPanel11Layout.setVerticalGroup((GroupLayout.Group)jPanel11Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel11Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel11Layout.createParallelGroup(3).add((Component)this.enzymesJComboBox, -2, -1, -2).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)jPanel11Layout.createParallelGroup(3).add((Component)this.siteJTextField, -2, -1, -2).add((Component)this.jLabel16)).addPreferredGap(0).add((GroupLayout.Group)jPanel11Layout.createParallelGroup(3).add((Component)this.inhibitorsJTextField, -2, -1, -2).add((Component)this.jLabel17)).addPreferredGap(0).add((GroupLayout.Group)jPanel11Layout.createParallelGroup(3).add((Component)this.jLabel18).add((Component)this.positionJTextField, -2, -1, -2)).add(30, 30, 30).add((GroupLayout.Group)jPanel11Layout.createParallelGroup(3).add((Component)this.jLabel19).add((Component)this.missedCleavagesJSpinner, -2, -1, -2).add((Component)this.jLabel20).add((Component)this.lowerMassJSpinner, -2, -1, -2).add((Component)this.jLabel21).add((Component)this.upperMassJSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Protein Sequence"));
        this.jPanel3.setPreferredSize(new Dimension(200, 215));
        this.jLabel24.setText("Sequence File:");
        this.sequenceFileJTextField.setEditable(false);
        this.browseJButton.setText("Browse");
        this.browseJButton.setToolTipText("Find a PEFF or FASTA file");
        this.browseJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.browseJButtonActionPerformed(evt);
            }
        });
        this.nextJButton.setText("Next");
        this.nextJButton.setToolTipText("Go to the next sequence in the file");
        this.nextJButton.setEnabled(false);
        this.nextJButton.setPreferredSize(new Dimension(55, 14));
        this.nextJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilitiesDemo.this.nextJButtonActionPerformed(evt);
            }
        });
        this.peffAnnotationsJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Term", "F", "B", "  "}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, Integer.class, Integer.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.peffAnnotationsJTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UtilitiesDemo.this.peffAnnotationsJTableMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.peffAnnotationsJTable);
        GroupLayout jPanel9Layout = new GroupLayout((Container)this.jPanel9);
        this.jPanel9.setLayout((LayoutManager)jPanel9Layout);
        jPanel9Layout.setHorizontalGroup((GroupLayout.Group)jPanel9Layout.createParallelGroup(1).add(0, 684, Short.MAX_VALUE).add((GroupLayout.Group)jPanel9Layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 684, Short.MAX_VALUE)));
        jPanel9Layout.setVerticalGroup((GroupLayout.Group)jPanel9Layout.createParallelGroup(1).add(0, 79, Short.MAX_VALUE).add((GroupLayout.Group)jPanel9Layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 79, Short.MAX_VALUE)));
        this.sequenceJTabbedPane.addTab("Sequence Annotations", this.jPanel9);
        this.proteinHeaderJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Term", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane3.setViewportView(this.proteinHeaderJTable);
        GroupLayout jPanel12Layout = new GroupLayout((Container)this.jPanel12);
        this.jPanel12.setLayout((LayoutManager)jPanel12Layout);
        jPanel12Layout.setHorizontalGroup((GroupLayout.Group)jPanel12Layout.createParallelGroup(1).add(0, 684, Short.MAX_VALUE).add((GroupLayout.Group)jPanel12Layout.createParallelGroup(1).add((Component)this.jScrollPane3, -1, 684, Short.MAX_VALUE)));
        jPanel12Layout.setVerticalGroup((GroupLayout.Group)jPanel12Layout.createParallelGroup(1).add(0, 79, Short.MAX_VALUE).add((GroupLayout.Group)jPanel12Layout.createParallelGroup(1).add((Component)this.jScrollPane3, -1, 79, Short.MAX_VALUE)));
        this.sequenceJTabbedPane.addTab("Protein Details", this.jPanel12);
        this.peffHeaderJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Term", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.peffHeaderJTable);
        GroupLayout jPanel10Layout = new GroupLayout((Container)this.jPanel10);
        this.jPanel10.setLayout((LayoutManager)jPanel10Layout);
        jPanel10Layout.setHorizontalGroup((GroupLayout.Group)jPanel10Layout.createParallelGroup(1).add(0, 684, Short.MAX_VALUE).add((GroupLayout.Group)jPanel10Layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 684, Short.MAX_VALUE)));
        jPanel10Layout.setVerticalGroup((GroupLayout.Group)jPanel10Layout.createParallelGroup(1).add(0, 79, Short.MAX_VALUE).add((GroupLayout.Group)jPanel10Layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 79, Short.MAX_VALUE)));
        this.sequenceJTabbedPane.addTab("PEFF Header", this.jPanel10);
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.sequenceJTabbedPane).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel24).add(18, 18, 18).add((Component)this.sequenceFileJTextField).addPreferredGap(0).add((Component)this.browseJButton).addPreferredGap(0).add((Component)this.nextJButton, -2, -1, -2))).addContainerGap()));
        jPanel3Layout.linkSize(new Component[]{this.browseJButton, this.nextJButton}, 1);
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel24).add((Component)this.sequenceFileJTextField, -2, -1, -2).add((Component)this.nextJButton, -2, 21, -2).add((Component)this.browseJButton)).add(18, 18, 18).add((Component)this.sequenceJTabbedPane).addContainerGap()));
        jPanel3Layout.linkSize(new Component[]{this.browseJButton, this.nextJButton}, 2);
        this.peptidesJPanel.setBorder(BorderFactory.createTitledBorder("Peptides"));
        this.peptidesJPanel.setPreferredSize(new Dimension(317, 277));
        this.peptidesJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Sequence", "Mass", "Start", "End"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, Float.class, Integer.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.peptidesJTable.setOpaque(false);
        this.peptidesScrollPane.setViewportView(this.peptidesJTable);
        GroupLayout peptidesJPanelLayout = new GroupLayout((Container)this.peptidesJPanel);
        this.peptidesJPanel.setLayout((LayoutManager)peptidesJPanelLayout);
        peptidesJPanelLayout.setHorizontalGroup((GroupLayout.Group)peptidesJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)peptidesJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.peptidesScrollPane, -1, 419, Short.MAX_VALUE).addContainerGap()));
        peptidesJPanelLayout.setVerticalGroup((GroupLayout.Group)peptidesJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)peptidesJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.peptidesScrollPane, -1, 321, Short.MAX_VALUE).addContainerGap()));
        this.sequenceCoverageJPanel.setBorder(BorderFactory.createTitledBorder("Sequence Coverage"));
        this.sequenceCoverageJPanel.setPreferredSize(new Dimension(500, 341));
        this.sequenceCoverageJPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                UtilitiesDemo.this.sequenceCoverageJPanelComponentResized(evt);
            }
        });
        this.proteinCoverageJScrollPane.setHorizontalScrollBarPolicy(31);
        this.proteinSequenceCoverageJEditorPane.setContentType("text/html");
        this.proteinSequenceCoverageJEditorPane.setEditable(false);
        this.proteinSequenceCoverageJEditorPane.setText("<html>\r\n  <head>\r\n\r\n  </head>\r\n  <body>\r\n    <p style=\"margin-top: 0\">\r\n\n    </p>\r\n  </body>\r\n</html>\r\n");
        this.proteinSequenceCoverageJEditorPane.setMargin(new Insets(10, 10, 10, 10));
        this.proteinSequenceCoverageJEditorPane.setMinimumSize(new Dimension(22, 22));
        this.proteinSequenceCoverageJEditorPane.setPreferredSize(new Dimension(22, 22));
        this.proteinSequenceCoverageJEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                UtilitiesDemo.this.proteinSequenceCoverageJEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.proteinCoverageJScrollPane.setViewportView(this.proteinSequenceCoverageJEditorPane);
        GroupLayout sequenceCoverageJPanelLayout = new GroupLayout((Container)this.sequenceCoverageJPanel);
        this.sequenceCoverageJPanel.setLayout((LayoutManager)sequenceCoverageJPanelLayout);
        sequenceCoverageJPanelLayout.setHorizontalGroup((GroupLayout.Group)sequenceCoverageJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)sequenceCoverageJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.proteinCoverageJScrollPane).addContainerGap()));
        sequenceCoverageJPanelLayout.setVerticalGroup((GroupLayout.Group)sequenceCoverageJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)sequenceCoverageJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.proteinCoverageJScrollPane, -1, 321, Short.MAX_VALUE).addContainerGap()));
        GroupLayout proteinDigestionJPanelLayout = new GroupLayout((Container)this.proteinDigestionJPanel);
        this.proteinDigestionJPanel.setLayout((LayoutManager)proteinDigestionJPanelLayout);
        proteinDigestionJPanelLayout.setHorizontalGroup((GroupLayout.Group)proteinDigestionJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)proteinDigestionJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)proteinDigestionJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)proteinDigestionJPanelLayout.createSequentialGroup().add((GroupLayout.Group)proteinDigestionJPanelLayout.createParallelGroup(1, false).add((Component)this.peptidesJPanel, -1, 451, Short.MAX_VALUE).add((Component)this.jPanel11, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)proteinDigestionJPanelLayout.createParallelGroup(2).add((Component)this.sequenceCoverageJPanel, -1, 721, Short.MAX_VALUE).add(1, (Component)this.jPanel3, -1, 721, Short.MAX_VALUE))).add(2, (GroupLayout.Group)proteinDigestionJPanelLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.proteinDigestionJLabel).addPreferredGap(0, 415, Short.MAX_VALUE).add((Component)this.inSilicoDigestionHelpJLabel, -2, -1, -2))).addContainerGap()));
        proteinDigestionJPanelLayout.setVerticalGroup((GroupLayout.Group)proteinDigestionJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)proteinDigestionJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)proteinDigestionJPanelLayout.createParallelGroup(1).add((Component)this.jPanel3, 0, 197, Short.MAX_VALUE).add((Component)this.jPanel11, -1, -1, Short.MAX_VALUE)).add(8, 8, 8).add((GroupLayout.Group)proteinDigestionJPanelLayout.createParallelGroup(1).add((Component)this.sequenceCoverageJPanel, -1, 370, Short.MAX_VALUE).add((Component)this.peptidesJPanel, -1, 370, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)proteinDigestionJPanelLayout.createParallelGroup(3).add((Component)this.inSilicoDigestionHelpJLabel, -2, -1, -2).add((Component)this.proteinDigestionJLabel)).addContainerGap()));
        this.jTabbedPane.addTab("In Silico Protein Digestion - Demo", this.proteinDigestionJPanel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTabbedPane, -1, 1203, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTabbedPane, -1, 650, Short.MAX_VALUE));
        this.pack();
    }

    private void aIonsJCheckBoxActionPerformed(ActionEvent evt) {
        for (Integer key : this.linkedSpectrumPanels.keySet()) {
            SpectrumPanel currentSpectrumPanel = this.linkedSpectrumPanels.get(key);
            Vector<SpectrumAnnotation> currentAnnotations = this.allAnnotations.get(key);
            currentSpectrumPanel.setAnnotations(SpectrumPanel.filterAnnotations(currentAnnotations, this.getCurrentFragmentIonTypes(), this.getNeutralLosses(), this.chargeOneJCheckBox.isSelected(), this.chargeTwoJCheckBox.isSelected(), this.chargeOverTwoJCheckBox.isSelected()));
            currentSpectrumPanel.validate();
            currentSpectrumPanel.repaint();
        }
    }

    private void bIonsJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void cIonsJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void yIonsJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void xIonsJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void zIonsJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void chargeOneJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void chargeTwoJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void chargeOverTwoJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void informationJEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ENTERED.toString())) {
            this.setCursor(new Cursor(12));
        } else if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.EXITED.toString())) {
            this.setCursor(new Cursor(0));
        } else if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ACTIVATED.toString())) {
            if (evt.getDescription().startsWith("#")) {
                this.informationJEditorPane.scrollToReference(evt.getDescription());
            } else {
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL(evt.getDescription());
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void NH3IonsJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void H2OIonsJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void otherIonsJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void spectrumPanelHelpJLabelMouseClicked(MouseEvent evt) {
        this.openHelpDialog("/helpFiles/SpectrumPanel.html");
    }

    private void spectrumPanelHelpJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void spectrumPanelHelpJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void chromatogramPanelHelpJLabelMouseClicked(MouseEvent evt) {
        this.openHelpDialog("/helpFiles/ChromatogramPanel.html");
    }

    private void chromatogramPanelHelpJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void chromatogramPanelHelpJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void isotopicDistributionCalculatorHelpJLabelMouseClicked(MouseEvent evt) {
        this.openHelpDialog("/helpFiles/IsotopicDistributionPanel.html");
    }

    private void isotopicDistributionCalculatorHelpJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void isotopicDistributionCalculatorHelpJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void inSilicoDigestionHelpJLabelMouseClicked(MouseEvent evt) {
        this.openHelpDialog("/helpFiles/InSilicoProteinDigestion.html");
    }

    private void inSilicoDigestionHelpJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void inSilicoDigestionHelpJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void peptideSequenceAJTextFieldKeyReleased(KeyEvent evt) {
        this.chargePeptideAJSpinner.setEnabled(this.peptideSequenceAJTextField.getText().trim().length() != 0);
        this.silacLabelPeptideAJComboBox.setEnabled(this.peptideSequenceAJTextField.getText().length() != 0);
        this.chargePeptideBJSpinner.setEnabled(this.peptideSequenceBJTextField.getText().trim().length() != 0);
        this.peptideSequenceBJTextField.setEnabled(this.peptideSequenceAJTextField.getText().trim().length() != 0);
        this.silacLabelPeptideBJComboBox.setEnabled(this.peptideSequenceBJTextField.getText().length() != 0);
        if (this.peptideSequenceAJTextField.getText().trim().length() != 0) {
            this.setUpIsotopicDistributionPanelDemo();
        } else {
            this.peptideAMzJTextField.setText("");
            this.peptideACompositionJTextField.setText("");
            DefaultTableModel dm = (DefaultTableModel)this.peptideAJXTable.getModel();
            dm.getDataVector().removeAllElements();
            this.isotopicDistributionAJPanel.removeAll();
            this.isotopicDistributionAJPanel.validate();
            this.isotopicDistributionAJPanel.repaint();
        }
    }

    private void peptideSequenceBJTextFieldKeyReleased(KeyEvent evt) {
        this.chargePeptideBJSpinner.setEnabled(this.peptideSequenceBJTextField.getText().trim().length() != 0);
        this.silacLabelPeptideBJComboBox.setEnabled(this.peptideSequenceBJTextField.getText().length() != 0);
        if (this.peptideSequenceBJTextField.getText().trim().length() == 0) {
            this.peptideBMzJTextField.setText("");
            this.peptideBCompositionJTextField.setText("");
            DefaultTableModel dm = (DefaultTableModel)this.peptideBJXTable.getModel();
            dm.getDataVector().removeAllElements();
        }
        this.setUpIsotopicDistributionPanelDemo();
    }

    private void chargePeptideAJSpinnerStateChanged(ChangeEvent evt) {
        this.setUpIsotopicDistributionPanelDemo();
    }

    private void chargePeptideBJSpinnerStateChanged(ChangeEvent evt) {
        this.setUpIsotopicDistributionPanelDemo();
    }

    private void profileSpectrumJCheckBoxActionPerformed(ActionEvent evt) {
        this.spectrumAPanel.setProfileMode(this.profileSpectrumJCheckBox.isSelected());
        this.spectrumAPanel.validate();
        this.spectrumAPanel.repaint();
        this.spectrumBPanel.setProfileMode(this.profileSpectrumJCheckBox.isSelected());
        this.spectrumBPanel.validate();
        this.spectrumBPanel.repaint();
        this.allPeaksJCheckBox.setEnabled(!this.profileSpectrumJCheckBox.isSelected());
        if (this.profileSpectrumJCheckBox.isSelected()) {
            this.allPeaksJCheckBox.setSelected(true);
        }
        this.allPeaksJCheckBoxActionPerformed(null);
    }

    private void enzymesJComboBoxPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.setVariableComoboBoxPopupMenuWidth(evt);
    }

    private void enzymesJComboBoxActionPerformed(ActionEvent evt) {
        Enzyme selectedEnzyme = this.mascotEnzymeReader.getEnzyme(this.enzymesJComboBox.getSelectedItem().toString());
        if (selectedEnzyme.getCleavage() != null) {
            this.siteJTextField.setText(new String(selectedEnzyme.getCleavage()));
        } else {
            this.siteJTextField.setText("");
        }
        if (selectedEnzyme.getRestrict() != null) {
            this.inhibitorsJTextField.setText(new String(selectedEnzyme.getRestrict()));
        } else {
            this.inhibitorsJTextField.setText("");
        }
        this.positionJTextField.setText(selectedEnzyme.getPosition() == 0 ? "C-terminal" : "N-terminal");
        this.updateInSilicoDigestion();
    }

    private void updateInSilicoDigestion() {
        DefaultTableModel dm = (DefaultTableModel)this.peptidesJTable.getModel();
        dm.getDataVector().removeAllElements();
        this.proteinSequenceCoverageJEditorPane.setText("");
        if (this.currentSequence.length() > 0) {
            this.cleanProteinSequence = "";
            try {
                Enzyme selectedEnzyme = this.mascotEnzymeReader.getEnzyme(this.enzymesJComboBox.getSelectedItem().toString());
                selectedEnzyme.setMiscleavages((Integer)this.missedCleavagesJSpinner.getValue());
                Protein protein = new Protein(this.currentSequence);
                String fullHeader = protein.getHeader().getFullHeaderWithAddenda();
                dm = (DefaultTableModel)this.proteinHeaderJTable.getModel();
                dm.getDataVector().removeAllElements();
                if (this.peffFormat) {
                    this.keyValuePairs = this.getHeaderValuePairsPeffFormat(fullHeader);
                } else {
                    this.keyValuePairs = new TreeMap();
                    this.getHeaderValuesFastaFormat(protein.getHeader());
                }
                this.selectedAnnotationTypes = new HashMap();
                for (int i = 0; i < this.peffAnnotationsJTable.getRowCount(); ++i) {
                    if (!((Boolean)this.peffAnnotationsJTable.getValueAt(i, 4)).booleanValue()) continue;
                    this.selectedAnnotationTypes.put((String)this.peffAnnotationsJTable.getValueAt(i, 1) + "_Foreground", this.peffAnnotationsColorMap.get((Integer)this.peffAnnotationsJTable.getValueAt(i, 2)));
                    this.selectedAnnotationTypes.put((String)this.peffAnnotationsJTable.getValueAt(i, 1) + "_Background", this.peffAnnotationsColorMap.get((Integer)this.peffAnnotationsJTable.getValueAt(i, 3)));
                }
                int width = this.getPreferredColumnWidth(this.proteinHeaderJTable, this.proteinHeaderJTable.getColumn("Term").getModelIndex(), 6);
                this.proteinHeaderJTable.getColumn("Term").setMinWidth(width);
                this.proteinHeaderJTable.getColumn("Term").setMaxWidth(width);
                Protein[] cleavedPeptides = selectedEnzyme.cleave(protein);
                this.cleanProteinSequence = protein.getSequence().getSequence();
                int counter = 0;
                double maxMass = 0.0;
                for (int i = 0; i < cleavedPeptides.length; ++i) {
                    if (!(cleavedPeptides[i].getMass() >= (double)((Integer)this.lowerMassJSpinner.getValue()).intValue()) || !(cleavedPeptides[i].getMass() <= (double)((Integer)this.upperMassJSpinner.getValue()).intValue())) continue;
                    ((DefaultTableModel)this.peptidesJTable.getModel()).addRow(new Object[]{++counter, cleavedPeptides[i].getSequence().getSequence(), cleavedPeptides[i].getMass(), cleavedPeptides[i].getHeader().getStartLocation(), cleavedPeptides[i].getHeader().getEndLocation()});
                    if (!(maxMass < cleavedPeptides[i].getMass())) continue;
                    maxMass = cleavedPeptides[i].getMass();
                }
                ((JSparklinesBarChartTableCellRenderer)this.peptidesJTable.getColumn("Mass").getCellRenderer()).setMaxValue(maxMass);
                double coverage = this.formatProteinSequence();
                ((TitledBorder)this.sequenceCoverageJPanel.getBorder()).setTitle("Sequence Coverage (" + Util.roundDouble(coverage, 2) + "%)");
                this.sequenceCoverageJPanel.repaint();
            }
            catch (IllegalArgumentException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error Parsing Protein Sequence", 0);
            }
        }
        ((TitledBorder)this.peptidesJPanel.getBorder()).setTitle("Peptides (" + this.peptidesJTable.getRowCount() + ")");
        this.peptidesJPanel.repaint();
    }

    private TreeMap<String, String> getHeaderValuePairsPeffFormat(String header) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        String[] valuePairs = header.split("\\\\");
        if (valuePairs.length > 0) {
            String tempAccession = valuePairs[0].substring(1);
            if (tempAccession.indexOf(":") != -1) {
                tempAccession = tempAccession.substring(tempAccession.indexOf(":") + 1);
            }
            map.put("Accession", tempAccession);
            ((DefaultTableModel)this.proteinHeaderJTable.getModel()).addRow(new Object[]{this.proteinHeaderJTable.getRowCount() + 1, "Accession", tempAccession});
            for (int i = 1; i < valuePairs.length; ++i) {
                String temp = valuePairs[i].trim();
                String key = temp.substring(0, temp.indexOf("="));
                String values = temp.substring(temp.indexOf("=") + 1);
                map.put(key, values);
                ((DefaultTableModel)this.proteinHeaderJTable.getModel()).addRow(new Object[]{this.proteinHeaderJTable.getRowCount() + 1, key, values});
            }
        }
        return map;
    }

    private void getHeaderValuesFastaFormat(Header proteinHeader) {
        String accession = proteinHeader.getAccession();
        if (proteinHeader.getStartLocation() != -1) {
            accession = accession + " (" + proteinHeader.getStartLocation() + "-" + proteinHeader.getEndLocation() + ")";
        }
        ((DefaultTableModel)this.proteinHeaderJTable.getModel()).addRow(new Object[]{this.proteinHeaderJTable.getRowCount() + 1, "Accession", accession});
        ((DefaultTableModel)this.proteinHeaderJTable.getModel()).addRow(new Object[]{this.proteinHeaderJTable.getRowCount() + 1, "Database", proteinHeader.getDatabaseType()});
        ((DefaultTableModel)this.proteinHeaderJTable.getModel()).addRow(new Object[]{this.proteinHeaderJTable.getRowCount() + 1, "ID", proteinHeader.getID()});
        ((DefaultTableModel)this.proteinHeaderJTable.getModel()).addRow(new Object[]{this.proteinHeaderJTable.getRowCount() + 1, "Description", proteinHeader.getDescription()});
    }

    private void missedCleavagesJSpinnerStateChanged(ChangeEvent evt) {
        this.updateInSilicoDigestion();
    }

    private void lowerMassJSpinnerStateChanged(ChangeEvent evt) {
        this.updateInSilicoDigestion();
    }

    private void upperMassJSpinnerStateChanged(ChangeEvent evt) {
        this.updateInSilicoDigestion();
    }

    private void silacLabelPeptideAJComboBoxActionPerformed(ActionEvent evt) {
        this.setUpIsotopicDistributionPanelDemo();
    }

    private void silacLabelPeptideBJComboBoxActionPerformed(ActionEvent evt) {
        this.setUpIsotopicDistributionPanelDemo();
    }

    private void exportJButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser("user.home");
        chooser.setFileFilter(new PdfFileFilter());
        int selection = chooser.showSaveDialog(this);
        if (selection == 0) {
            try {
                int option;
                String selectedFile = chooser.getSelectedFile().getAbsolutePath();
                if (!selectedFile.endsWith(ImageType.PDF.getExtension())) {
                    selectedFile = selectedFile + ImageType.PDF.getExtension();
                }
                boolean saveFile = true;
                if (new File(selectedFile).exists() && (option = JOptionPane.showConfirmDialog(this, "The file " + selectedFile + " already exists. Overwrite?", "Overwrite?", 1)) != 0) {
                    saveFile = false;
                }
                if (saveFile) {
                    this.setCursor(new Cursor(3));
                    Export.exportComponent(this.spectraJPanel, this.spectraJPanel.getBounds(), new File(selectedFile), ImageType.PDF);
                    this.setCursor(new Cursor(0));
                    JOptionPane.showMessageDialog(this, "Spectra saved to " + selectedFile, "Spectra Saved", 1);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Unable to export spectra: " + e.getMessage(), "Error Exporting Spectra", 1);
            }
            catch (TranscoderException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Unable to export spectra: " + e.getMessage(), "Error Exporting Spectra", 1);
            }
        }
    }

    private void sequenceCoverageJPanelComponentResized(ComponentEvent evt) {
        this.formatProteinSequence();
    }

    private void proteinSequenceCoverageJEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.proteinSequenceCoverageJEditorPane.setToolTipText(evt.getDescription());
        } else if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String proteinAccession = this.keyValuePairs.get("Accession");
            String proteinUniProtUrl = "http://www.uniprot.org/uniprot/" + proteinAccession.trim() + "#section_features";
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL(proteinUniProtUrl);
            this.setCursor(new Cursor(0));
        } else {
            this.proteinSequenceCoverageJEditorPane.setToolTipText(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void browseJButtonActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser("user.home");
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith("fasta") || myFile.getName().toLowerCase().endsWith("fast") || myFile.getName().toLowerCase().endsWith("fas") || myFile.getName().toLowerCase().endsWith("peff") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "FASTA or PEFF (.fasta, .peff)";
            }
        };
        fileChooser.setFileFilter(filter);
        int returnVal = fileChooser.showOpenDialog(this.getParent());
        if (returnVal != 0) return;
        this.currentSequenceFile = fileChooser.getSelectedFile();
        this.sequenceFileJTextField.setText(this.currentSequenceFile.getPath());
        this.peffFormat = this.currentSequenceFile.getAbsolutePath().toLowerCase().endsWith(".peff");
        DefaultTableModel dm = (DefaultTableModel)this.peffHeaderJTable.getModel();
        dm.getDataVector().removeAllElements();
        dm = (DefaultTableModel)this.peffAnnotationsJTable.getModel();
        dm.getDataVector().removeAllElements();
        try {
            int colorCounter = 0;
            this.peffAnnotationsColorMap = new HashMap();
            this.peffAnnotationsColorMap.put(colorCounter++, Color.WHITE);
            this.peffAnnotationsColorMap.put(colorCounter++, new Color(102, 153, 255));
            this.peffAnnotationsColorMap.put(colorCounter++, Color.WHITE);
            this.peffAnnotationsColorMap.put(colorCounter++, new Color(255, 102, 102));
            this.peffAnnotationsColorMap.put(colorCounter++, Color.WHITE);
            this.peffAnnotationsColorMap.put(colorCounter++, new Color(0, 204, 51));
            this.peffAnnotationsColorMap.put(colorCounter++, Color.WHITE);
            this.peffAnnotationsColorMap.put(colorCounter++, new Color(0, 204, 51));
            this.peffAnnotationsColorMap.put(colorCounter++, Color.WHITE);
            this.peffAnnotationsColorMap.put(colorCounter++, Color.ORANGE);
            this.peffAnnotationsTooltipMap = new HashMap();
            for (int i = 0; i < colorCounter; ++i) {
                this.peffAnnotationsTooltipMap.put(i, "Double click to change color");
            }
            this.peffAnnotationsJTable.getColumn("B").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.PINK, this.peffAnnotationsColorMap, this.peffAnnotationsTooltipMap));
            this.peffAnnotationsJTable.getColumn("F").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.PINK, this.peffAnnotationsColorMap, this.peffAnnotationsTooltipMap));
            colorCounter = 0;
            if (this.peffFormat) {
                ((DefaultTableModel)this.peffAnnotationsJTable.getModel()).addRow(new Object[]{this.peffAnnotationsJTable.getRowCount() + 1, "ModRes", colorCounter++, colorCounter++, true});
                ((DefaultTableModel)this.peffAnnotationsJTable.getModel()).addRow(new Object[]{this.peffAnnotationsJTable.getRowCount() + 1, "Variant", colorCounter++, colorCounter++, true});
                ((DefaultTableModel)this.peffAnnotationsJTable.getModel()).addRow(new Object[]{this.peffAnnotationsJTable.getRowCount() + 1, "Signal", colorCounter++, colorCounter++, false});
                ((DefaultTableModel)this.peffAnnotationsJTable.getModel()).addRow(new Object[]{this.peffAnnotationsJTable.getRowCount() + 1, "Site", colorCounter++, colorCounter++, false});
                ((DefaultTableModel)this.peffAnnotationsJTable.getModel()).addRow(new Object[]{this.peffAnnotationsJTable.getRowCount() + 1, "Multiple", colorCounter++, colorCounter++, true});
            }
            this.sequenceJTabbedPane.setEnabledAt(2, this.peffFormat);
            FileReader peffFileReader = new FileReader(this.currentSequenceFile);
            this.currentPeffBufferedReader = new BufferedReader(peffFileReader);
            this.currentSequenceLine = this.currentPeffBufferedReader.readLine();
            while (this.currentSequenceLine.startsWith("#")) {
                if (this.peffFormat) {
                    if (this.currentSequenceLine.indexOf(" //") == -1) {
                        if (!this.currentSequenceLine.equalsIgnoreCase("# PEFF")) {
                            String term = this.currentSequenceLine.substring(this.currentSequenceLine.lastIndexOf("#") + 2, this.currentSequenceLine.lastIndexOf("=")).trim();
                            String value = this.currentSequenceLine.substring(this.currentSequenceLine.lastIndexOf("=") + 1).trim();
                            ((DefaultTableModel)this.peffHeaderJTable.getModel()).addRow(new Object[]{this.peffHeaderJTable.getRowCount() + 1, term, value});
                            if (!term.equalsIgnoreCase("SpecificValue")) {
                                // empty if block
                            }
                        }
                    } else {
                        ((DefaultTableModel)this.peffHeaderJTable.getModel()).addRow(new Object[]{this.peffHeaderJTable.getRowCount() + 1, "//"});
                    }
                }
                this.currentSequenceLine = this.currentPeffBufferedReader.readLine();
            }
            int width = this.getPreferredColumnWidth(this.peffHeaderJTable, this.peffHeaderJTable.getColumn("Term").getModelIndex(), 6);
            this.peffHeaderJTable.getColumn("Term").setMinWidth(width);
            this.peffHeaderJTable.getColumn("Term").setMaxWidth(width);
            while (!this.currentSequenceLine.startsWith(">")) {
                this.currentSequenceLine = this.currentPeffBufferedReader.readLine();
            }
            this.currentSequence = this.currentSequenceLine + "\n";
            this.currentSequenceLine = this.currentPeffBufferedReader.readLine();
            while (this.currentSequenceLine != null && !this.currentSequenceLine.startsWith(">")) {
                this.currentSequenceLine = this.currentSequenceLine.trim();
                this.currentSequenceLine = this.currentSequenceLine.replaceAll("\\W", "");
                this.currentSequence = this.currentSequence + this.currentSequenceLine + "\n";
                this.currentSequenceLine = this.currentPeffBufferedReader.readLine();
            }
            if (this.currentSequenceLine != null) {
                this.nextJButton.setEnabled(true);
            } else {
                this.nextJButton.setEnabled(false);
            }
            this.updateInSilicoDigestion();
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void nextJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        try {
            this.currentSequence = this.currentSequenceLine + "\n";
            this.currentSequenceLine = this.currentPeffBufferedReader.readLine();
            while (this.currentSequenceLine != null && !this.currentSequenceLine.startsWith(">")) {
                this.currentSequenceLine = this.currentSequenceLine.trim();
                this.currentSequenceLine = this.currentSequenceLine.replaceAll("\\W", "");
                this.currentSequence = this.currentSequence + this.currentSequenceLine + "\n";
                this.currentSequenceLine = this.currentPeffBufferedReader.readLine();
            }
            this.updateInSilicoDigestion();
            if (this.currentSequenceLine == null) {
                this.nextJButton.setEnabled(false);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    private void allPeaksJCheckBoxActionPerformed(ActionEvent evt) {
        this.spectrumAPanel.showAnnotatedPeaksOnly(!this.allPeaksJCheckBox.isSelected());
        this.spectrumBPanel.showAnnotatedPeaksOnly(!this.allPeaksJCheckBox.isSelected());
        this.spectrumAPanel.repaint();
        this.spectrumBPanel.repaint();
    }

    private void peffAnnotationsJTableMouseClicked(MouseEvent evt) {
        int row = this.peffAnnotationsJTable.getSelectedRow();
        int column = this.peffAnnotationsJTable.getSelectedColumn();
        if (row != -1) {
            Color tempColor;
            if (column == 4) {
                this.selectedAnnotationTypes = new HashMap();
                for (int i = 0; i < this.peffAnnotationsJTable.getRowCount(); ++i) {
                    if (!((Boolean)this.peffAnnotationsJTable.getValueAt(i, column)).booleanValue()) continue;
                    this.selectedAnnotationTypes.put((String)this.peffAnnotationsJTable.getValueAt(i, 1) + "_Foreground", this.peffAnnotationsColorMap.get((Integer)this.peffAnnotationsJTable.getValueAt(i, 2)));
                    this.selectedAnnotationTypes.put((String)this.peffAnnotationsJTable.getValueAt(i, 1) + "_Background", this.peffAnnotationsColorMap.get((Integer)this.peffAnnotationsJTable.getValueAt(i, 3)));
                }
                this.formatProteinSequence();
            } else if ((column == 2 || column == 3) && (tempColor = JColorChooser.showDialog(this, "Choose Color", this.peffAnnotationsColorMap.get((Integer)this.peffAnnotationsJTable.getValueAt(row, column)))) != null) {
                this.peffAnnotationsColorMap.put((Integer)this.peffAnnotationsJTable.getValueAt(row, column), tempColor);
                this.peffAnnotationsJTable.getColumn("B").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.PINK, this.peffAnnotationsColorMap, this.peffAnnotationsTooltipMap));
                this.peffAnnotationsJTable.getColumn("F").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.PINK, this.peffAnnotationsColorMap, this.peffAnnotationsTooltipMap));
                this.selectedAnnotationTypes = new HashMap();
                for (int i = 0; i < this.peffAnnotationsJTable.getRowCount(); ++i) {
                    if (!((Boolean)this.peffAnnotationsJTable.getValueAt(i, 4)).booleanValue()) continue;
                    this.selectedAnnotationTypes.put((String)this.peffAnnotationsJTable.getValueAt(i, 1) + "_Foreground", this.peffAnnotationsColorMap.get((Integer)this.peffAnnotationsJTable.getValueAt(i, 2)));
                    this.selectedAnnotationTypes.put((String)this.peffAnnotationsJTable.getValueAt(i, 1) + "_Background", this.peffAnnotationsColorMap.get((Integer)this.peffAnnotationsJTable.getValueAt(i, 3)));
                }
                this.formatProteinSequence();
            }
        }
    }

    private void openHelpDialog(String urlAsString) {
        new HelpWindow(this, this.getClass().getResource(urlAsString));
    }

    public double formatProteinSequence() {
        this.setCursor(new Cursor(3));
        double sequenceCoverage = 0.0;
        if (this.cleanProteinSequence != null) {
            int selectedPeptideStart = -1;
            int selectedPeptideEnd = -1;
            if (this.peptidesJTable.getSelectedRow() != -1) {
                selectedPeptideStart = (Integer)this.peptidesJTable.getValueAt(this.peptidesJTable.getSelectedRow(), 3);
                selectedPeptideEnd = (Integer)this.peptidesJTable.getValueAt(this.peptidesJTable.getSelectedRow(), 4);
            }
            int[] coverage = new int[this.cleanProteinSequence.length() + 1];
            for (int i = 0; i < this.peptidesJTable.getRowCount(); ++i) {
                int tempPeptideStart = (Integer)this.peptidesJTable.getValueAt(i, 3);
                int tempPeptideEnd = (Integer)this.peptidesJTable.getValueAt(i, 4);
                int j = tempPeptideStart;
                while (j <= tempPeptideEnd) {
                    int n = j++;
                    coverage[n] = coverage[n] + 1;
                }
            }
            sequenceCoverage = ProteinSequencePane.formatProteinSequence(this.proteinSequenceCoverageJEditorPane, this.cleanProteinSequence, selectedPeptideStart, selectedPeptideEnd, coverage, this.keyValuePairs, this.selectedAnnotationTypes);
        }
        this.setCursor(new Cursor(0));
        return sequenceCoverage;
    }

    private ArrayList<NeutralLoss> getNeutralLosses() {
        ArrayList<NeutralLoss> neutralLosses = new ArrayList<NeutralLoss>();
        if (this.H2OIonsJCheckBox.isSelected()) {
            neutralLosses.add(NeutralLoss.H2O);
        }
        if (this.NH3IonsJCheckBox.isSelected()) {
            neutralLosses.add(NeutralLoss.NH3);
        }
        if (this.otherIonsJCheckBox.isSelected()) {
            neutralLosses.add(NeutralLoss.CH4OS);
            neutralLosses.add(NeutralLoss.H3PO4);
            neutralLosses.add(NeutralLoss.HPO3);
        }
        return neutralLosses;
    }

    private HashMap<Ion.IonType, ArrayList<Integer>> getCurrentFragmentIonTypes() {
        HashMap<Ion.IonType, ArrayList<Integer>> fragmentIontypes = new HashMap<Ion.IonType, ArrayList<Integer>>();
        fragmentIontypes.put(Ion.IonType.PEPTIDE_FRAGMENT_ION, new ArrayList());
        if (this.aIonsJCheckBox.isSelected()) {
            ((ArrayList)fragmentIontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION)).add(0);
        }
        if (this.bIonsJCheckBox.isSelected()) {
            ((ArrayList)fragmentIontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION)).add(1);
        }
        if (this.cIonsJCheckBox.isSelected()) {
            ((ArrayList)fragmentIontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION)).add(2);
        }
        if (this.xIonsJCheckBox.isSelected()) {
            ((ArrayList)fragmentIontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION)).add(3);
        }
        if (this.yIonsJCheckBox.isSelected()) {
            ((ArrayList)fragmentIontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION)).add(4);
        }
        if (this.zIonsJCheckBox.isSelected()) {
            ((ArrayList)fragmentIontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION)).add(5);
        }
        if (this.otherIonsJCheckBox.isSelected()) {
            fragmentIontypes.put(Ion.IonType.IMMONIUM_ION, Ion.getPossibleSubtypes(Ion.IonType.IMMONIUM_ION));
            fragmentIontypes.put(Ion.IonType.PRECURSOR_ION, Ion.getPossibleSubtypes(Ion.IonType.PRECURSOR_ION));
            fragmentIontypes.put(Ion.IonType.REPORTER_ION, Ion.getPossibleSubtypes(Ion.IonType.REPORTER_ION));
        }
        return fragmentIontypes;
    }

    private void setVariableComoboBoxPopupMenuWidth(PopupMenuEvent evt) {
        JComboBox box = (JComboBox)evt.getSource();
        Accessible comp = box.getUI().getAccessibleChild(box, 0);
        if (!(comp instanceof JPopupMenu)) {
            return;
        }
        JPopupMenu popupMenu = (JPopupMenu)comp;
        JComponent scrollPane = (JComponent)popupMenu.getComponent(0);
        Dimension size = new Dimension();
        if (box.getPreferredSize().width > scrollPane.getPreferredSize().width) {
            size.width = box.getPreferredSize().width;
            size.height = scrollPane.getPreferredSize().height;
            scrollPane.setPreferredSize(size);
            scrollPane.setMaximumSize(size);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UtilitiesGUIDefaults.setLookAndFeel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new UtilitiesDemo();
            }
        });
    }

    public String getVersion() {
        Properties p = new Properties();
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("compomics-utilities.properties");
            p.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return p.getProperty("compomics-utilities.version");
    }

    public int getPreferredColumnWidth(JTable table, int colIndex, int margin) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn col = colModel.getColumn(colIndex);
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        int width = comp.getPreferredSize().width;
        for (int r = 0; r < table.getRowCount(); ++r) {
            renderer = table.getCellRenderer(r, colIndex);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, colIndex), false, false, r, colIndex);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        return width += 2 * margin;
    }
}

