/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.research.util;

import com.compomics.mascotdatfile.util.interfaces.MascotDatfileInf;
import com.compomics.mascotdatfile.util.mascot.MascotDatfile;
import com.compomics.mascotdatfile.util.mascot.MascotDatfile_Index;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DatfileLocation {
    private static Logger logger = Logger.getLogger(DatfileLocation.class);
    private String iPathAndFilename = null;
    private String[] iURLInformation = null;
    private int iDatfileLocationType = -1;
    public static final int HARDDISK = 0;
    public static final int URL = 1;

    public DatfileLocation(int aDatfileLocationType, String[] aParams) {
        this.iDatfileLocationType = aDatfileLocationType;
        switch (this.iDatfileLocationType) {
            case 0: {
                this.iPathAndFilename = aParams[0];
                break;
            }
            case 1: {
                this.iURLInformation = aParams;
            }
        }
    }

    public DatfileLocation(int aDatfileLocationType, String aParam) {
        this(aDatfileLocationType, new String[]{aParam});
    }

    public DatfileLocation(int aDatfileLocationType, int aParams) {
        this(aDatfileLocationType, new String[]{Integer.toString(aParams)});
    }

    public MascotDatfileInf getDatfile() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        return this.getDatfile(false);
    }

    public MascotDatfileInf getDatfile(boolean aIndexed) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        MascotDatfileInf mdf = null;
        if (this.iDatfileLocationType == 0) {
            mdf = aIndexed ? new MascotDatfile_Index(this.iPathAndFilename) : new MascotDatfile(this.iPathAndFilename);
        } else if (this.iDatfileLocationType == 1) {
            String lServer = this.iURLInformation[0];
            String lDate = this.iURLInformation[1];
            String lDatfileFilename = this.iURLInformation[2];
            String URL2 = lServer + "mascot/x-cgi/ms-status.exe?Autorefresh=false&Show=RESULTFILE&DateDir=" + lDate + "&ResJob=" + lDatfileFilename;
            try {
                URL lDatfileLocation = new URL(URL2);
                URLConnection lURLConnection = lDatfileLocation.openConnection();
                BufferedReader br = new BufferedReader(new InputStreamReader(lURLConnection.getInputStream()));
                mdf = new MascotDatfile(br);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return mdf;
    }

    public String toString() {
        String toString = null;
        switch (this.iDatfileLocationType) {
            case 0: {
                toString = "Harddisk";
                break;
            }
            case 1: {
                toString = "URL";
            }
        }
        return toString;
    }
}

