/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.research.script;

import com.compomics.mascotdatfile.util.interfaces.Modification;
import com.compomics.mascotdatfile.util.mascot.FixedModification;
import com.compomics.mascotdatfile.util.mascot.MascotDatfile;
import com.compomics.mascotdatfile.util.mascot.ModificationList;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.QueryToPeptideMap;
import com.compomics.mascotdatfile.util.mascot.VariableModification;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ModifiedPeptidehits {
    private static Logger logger = Logger.getLogger(ModifiedPeptidehits.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 6 && args.length != 2) {
            ModifiedPeptidehits.printUsage();
        }
        String lDatfilePathAndFilename = args[0];
        if (args[1].equals("-m")) {
            ModifiedPeptidehits.printPossibleModifications(lDatfilePathAndFilename);
        } else if (args[1].equals("-csv")) {
            String lTargetPath = args[2];
            String lTargetFilename = args[3];
            String lMods = args[4];
            double lConfidence = Double.parseDouble(args[5]);
            BufferedWriter bw = null;
            File lTargetPathFile = null;
            File lTarget = null;
            ArrayList<String> lModsArray = new ArrayList<String>();
            if (lMods.indexOf(124) == -1) {
                lModsArray.add(lMods);
            } else {
                StringTokenizer st = new StringTokenizer(lMods, "|");
                while (st.countTokens() > 0) {
                    lModsArray.add(st.nextToken());
                }
            }
            try {
                lTargetPathFile = new File(lTargetPath);
                lTargetPathFile.mkdirs();
                lTarget = new File(lTargetPathFile, lTargetFilename);
                lTarget.createNewFile();
                bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(lTarget)));
                ModifiedPeptidehits.printCSVheaders(bw, lDatfilePathAndFilename);
                MascotDatfile mdf = new MascotDatfile(lDatfilePathAndFilename);
                QueryToPeptideMap lQuery2P = mdf.getQueryToPeptideMap();
                for (int i = 0; i < lQuery2P.getNumberOfQueries(); ++i) {
                    PeptideHit lPeptidehit = lQuery2P.getPeptideHitOfOneQuery(i + 1);
                    if (lPeptidehit == null || !lPeptidehit.scoresAboveIdentityThreshold(0.05) || !ModifiedPeptidehits.containsAllModifications(lPeptidehit, lModsArray)) continue;
                    ModifiedPeptidehits.printPeptideHitToFile(lPeptidehit, bw, i, lConfidence);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (NullPointerException npe) {
                    npe.printStackTrace();
                }
            }
        }
    }

    private static boolean containsAllModifications(PeptideHit aPeptideHit, ArrayList aModsArray) {
        int i;
        boolean containsAllMods = true;
        Modification[] lPHmods = aPeptideHit.getModifications();
        boolean[] boolModsArray = new boolean[aModsArray.size()];
        for (i = 0; i < boolModsArray.length; ++i) {
            boolModsArray[i] = false;
        }
        for (int j = 0; j < lPHmods.length; ++j) {
            Modification lMod = lPHmods[j];
            if (lMod == null) continue;
            String lShortType = lMod.getShortType();
            for (int k = 0; k < aModsArray.size(); ++k) {
                if (!lShortType.equals(aModsArray.get(k))) continue;
                boolModsArray[k] = true;
            }
        }
        for (i = 0; i < boolModsArray.length; ++i) {
            boolean aBoolean = boolModsArray[i];
            if (boolModsArray[i]) continue;
            containsAllMods = false;
            break;
        }
        return containsAllMods;
    }

    private static void printUsage() {
        String lMessage = "\"Usage:\tModifiedPeptideHits <1. Path and filename from datfile> <2. option> <3. option related parameters>\"\n\nOptions:\n\t-m\n\t---> Print all availlable modifications in the specified datfile.\n\n\t-cvs <3a. Target path> <3b. Target File> <3c. modification1(|modification2|modification3)(short)> <3d. Confidence(alpha)>\n\t---> Write all the peptidehits (confidence > 1-alpha) containing all the modification(s) in a csv file.\n\nExample: \n\tModifiedPeptidehits C:\\mascot\\datfiles\\F010345.dat -csv C:\\target F013345_ace_modified.csv Ace 0.10";
        ModifiedPeptidehits.printMessage(lMessage);
        System.exit(0);
    }

    private static void printPossibleModifications(String aDatfilePathAndFilename) {
        Modification fmod;
        int i;
        StringBuffer sb = new StringBuffer();
        MascotDatfile lMDF = new MascotDatfile(aDatfilePathAndFilename);
        ModificationList lModsList = lMDF.getModificationList();
        Vector lMods = null;
        sb.append("**Fixed Modifications**");
        lMods = lModsList.getFixedModifications();
        for (i = 0; i < lMods.size(); ++i) {
            fmod = (FixedModification)lMods.elementAt(i);
            sb.append("\n\t" + (i + 1) + ".  " + ((FixedModification)fmod).getShortType() + " (short) \t" + ((FixedModification)fmod).getType() + " " + ((FixedModification)fmod).getLocation() + " (full)");
        }
        sb.append("\n\n");
        sb.append("**Variable Modifications**");
        lMods = lModsList.getVariableModifications();
        for (i = 0; i < lMods.size(); ++i) {
            fmod = (VariableModification)lMods.elementAt(i);
            sb.append("\n\t" + (i + 1) + ".  " + ((VariableModification)fmod).getShortType() + " (short) \t" + ((VariableModification)fmod).getType() + " " + ((VariableModification)fmod).getLocation() + " (full)");
        }
        ModifiedPeptidehits.printMessage(sb.toString());
        System.exit(0);
    }

    private static void printCSVheaders(BufferedWriter bw, String aDatfilePathAndFilename) throws IOException {
        bw.write("ModifiedPeptidehits.java analysis of " + aDatfilePathAndFilename + ".");
        bw.newLine();
        bw.write("Query_ID;ModifiedPeptideSequence;PeptideSequence;PeptideLength;PeptideScore;PeptideThreshold");
        bw.newLine();
        bw.flush();
    }

    private static void printPeptideHitToFile(PeptideHit aPeptideHit, BufferedWriter bw, int aQueryNumber, double aConfidence) throws IOException {
        bw.write("Query _ " + (aQueryNumber + 1) + ";" + aPeptideHit.getModifiedSequence() + ";" + aPeptideHit.getSequence() + ";" + aPeptideHit.getSequence().length() + ";" + aPeptideHit.getIonsScore() + ";" + aPeptideHit.calculateIdentityThreshold(aConfidence));
        bw.newLine();
        bw.flush();
    }

    private static void printMessage(String aMessage) {
        System.out.println(aMessage);
    }

    private static void printError(String aError) {
        System.err.println(aError);
        System.exit(0);
    }
}

