/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.loader;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.DNASequence;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.compound.AminoAcidCompound;
import org.biojava3.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava3.core.sequence.compound.DNACompoundSet;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.features.DBReferenceInfo;
import org.biojava3.core.sequence.features.DatabaseReferenceInterface;
import org.biojava3.core.sequence.features.FeaturesKeyWordInterface;
import org.biojava3.core.sequence.io.GenbankSequenceParser;
import org.biojava3.core.sequence.io.GenericGenbankHeaderParser;
import org.biojava3.core.sequence.loader.StringProxySequenceReader;
import org.biojava3.core.sequence.loader.UniprotProxySequenceReader;
import org.biojava3.core.sequence.template.AbstractSequence;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;

public class GenbankProxySequenceReader<C extends Compound>
extends StringProxySequenceReader<C>
implements FeaturesKeyWordInterface,
DatabaseReferenceInterface {
    private static final Logger logger = Logger.getLogger(UniprotProxySequenceReader.class.getName());
    private static final String eutilBaseURL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/";
    private String genbankDirectoryCache = null;
    private GenbankSequenceParser<AbstractSequence<C>, C> genbankParser;
    private GenericGenbankHeaderParser<AbstractSequence<C>, C> headerParser;
    private String header;

    public GenbankProxySequenceReader(String genbankDirectoryCache, String accessionID, CompoundSet<C> compoundSet) throws Exception {
        this.setGenbankDirectoryCache(genbankDirectoryCache);
        this.setCompoundSet(compoundSet);
        String db = compoundSet instanceof AminoAcidCompoundSet ? "protein" : "nuccore";
        BufferedInputStream inStream = this.getBufferedInputStream(accessionID, db);
        this.genbankParser = new GenbankSequenceParser();
        this.setContents(this.genbankParser.getSequence(new BufferedReader(new InputStreamReader(inStream)), 0));
        this.headerParser = this.genbankParser.getSequenceHeaderParser();
        this.header = this.genbankParser.getHeader();
        ((InputStream)inStream).close();
    }

    private BufferedInputStream getBufferedInputStream(String accessionID, String db) throws IOException, InterruptedException {
        BufferedInputStream inStream = null;
        if (this.genbankDirectoryCache != null && this.genbankDirectoryCache.length() > 0) {
            File f = new File(this.genbankDirectoryCache + File.separatorChar + accessionID + ".gb");
            if (f.exists()) {
                logger.info("Reading " + f.toString());
                inStream = new BufferedInputStream(new FileInputStream(f));
            } else {
                InputStream in = this.getEutilsInputStream(accessionID, db);
                this.copyInputStreamToFile(in, f);
                inStream = new BufferedInputStream(new FileInputStream(f));
            }
        } else {
            inStream = new BufferedInputStream(this.getEutilsInputStream(accessionID, db));
        }
        return inStream;
    }

    private void copyInputStreamToFile(InputStream in, File f) throws IOException, InterruptedException {
        FileOutputStream out = new FileOutputStream(f);
        byte[] buffer = new byte[1024];
        int len = in.read(buffer);
        while (len != -1) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
            if (!Thread.interrupted()) continue;
            in.close();
            out.close();
            throw new InterruptedException();
        }
        in.close();
        out.close();
    }

    private InputStream getEutilsInputStream(String accessionID, String db) throws IOException {
        String genbankURL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=" + db + "&id=" + accessionID + "&rettype=gb&retmode=text";
        logger.info("Loading " + genbankURL);
        URL genbank = new URL(genbankURL);
        URLConnection genbankConnection = genbank.openConnection();
        return genbankConnection.getInputStream();
    }

    public String getGenbankDirectoryCache() {
        return this.genbankDirectoryCache;
    }

    public void setGenbankDirectoryCache(String genbankDirectoryCache) {
        File f = new File(genbankDirectoryCache);
        if (!f.exists()) {
            f.mkdirs();
        }
        this.genbankDirectoryCache = genbankDirectoryCache;
    }

    public String getHeader() {
        return this.header;
    }

    public GenericGenbankHeaderParser<AbstractSequence<C>, C> getHeaderParser() {
        return this.headerParser;
    }

    @Override
    public LinkedHashMap<String, ArrayList<DBReferenceInfo>> getDatabaseReferences() throws Exception {
        return this.genbankParser.getDatabaseReferences();
    }

    @Override
    public ArrayList<String> getKeyWords() throws Exception {
        return this.genbankParser.getKeyWords();
    }

    public static void main(String[] args) throws Exception {
        GenbankProxySequenceReader<AminoAcidCompound> genbankProteinReader = new GenbankProxySequenceReader<AminoAcidCompound>("/tmp", "NP_000257", AminoAcidCompoundSet.getAminoAcidCompoundSet());
        ProteinSequence proteinSequence = new ProteinSequence(genbankProteinReader);
        genbankProteinReader.getHeaderParser().parseHeader(genbankProteinReader.getHeader(), proteinSequence);
        System.out.println("Sequence(" + proteinSequence.getAccession() + "," + proteinSequence.getLength() + ")=" + proteinSequence.getSequenceAsString().substring(0, 10) + "...");
        System.out.println("Keywords" + genbankProteinReader.getKeyWords());
        System.out.println("DatabaseReferences" + genbankProteinReader.getDatabaseReferences());
        GenbankProxySequenceReader<NucleotideCompound> genbankDNAReader = new GenbankProxySequenceReader<NucleotideCompound>("/tmp", "NM_001126", DNACompoundSet.getDNACompoundSet());
        DNASequence dnaSequence = new DNASequence(genbankDNAReader);
        genbankDNAReader.getHeaderParser().parseHeader(genbankDNAReader.getHeader(), dnaSequence);
        dnaSequence.setAccession(new AccessionID("NM_001126"));
        System.out.println("Sequence(" + dnaSequence.getAccession() + "," + dnaSequence.getLength() + ")=" + dnaSequence.getSequenceAsString().substring(0, 10) + "...");
        System.out.println("Keywords" + genbankDNAReader.getKeyWords());
        System.out.println("DatabaseReferences" + genbankDNAReader.getDatabaseReferences());
        genbankDNAReader = new GenbankProxySequenceReader<NucleotideCompound>("/tmp", "NM_000266", DNACompoundSet.getDNACompoundSet());
        dnaSequence = new DNASequence(genbankDNAReader);
        genbankDNAReader.getHeaderParser().parseHeader(genbankDNAReader.getHeader(), dnaSequence);
        System.out.println("Sequence(" + dnaSequence.getAccession() + "," + dnaSequence.getLength() + ")=" + dnaSequence.getSequenceAsString().substring(0, 10) + "...");
        System.out.println("Keywords" + genbankDNAReader.getKeyWords());
        System.out.println("DatabaseReferences" + genbankDNAReader.getDatabaseReferences());
        genbankDNAReader = new GenbankProxySequenceReader<NucleotideCompound>("/tmp", "AV254721", DNACompoundSet.getDNACompoundSet());
        dnaSequence = new DNASequence(genbankDNAReader);
        genbankDNAReader.getHeaderParser().parseHeader(genbankDNAReader.getHeader(), dnaSequence);
        System.out.println("Sequence(" + dnaSequence.getAccession() + "," + dnaSequence.getLength() + ")=" + dnaSequence.getSequenceAsString().substring(0, 10) + "...");
        System.out.println("Keywords" + genbankDNAReader.getKeyWords());
        System.out.println("DatabaseReferences" + genbankDNAReader.getDatabaseReferences());
        genbankDNAReader = new GenbankProxySequenceReader<NucleotideCompound>("/tmp", "AV254721.2", DNACompoundSet.getDNACompoundSet());
        dnaSequence = new DNASequence(genbankDNAReader);
        genbankDNAReader.getHeaderParser().parseHeader(genbankDNAReader.getHeader(), dnaSequence);
        System.out.println("Sequence(" + dnaSequence.getAccession() + "," + dnaSequence.getLength() + ")=" + dnaSequence.getSequenceAsString().substring(0, 10) + "...");
        System.out.println("Keywords" + genbankDNAReader.getKeyWords());
        System.out.println("DatabaseReferences" + genbankDNAReader.getDatabaseReferences());
        genbankDNAReader = new GenbankProxySequenceReader<NucleotideCompound>("/tmp", "U49845", DNACompoundSet.getDNACompoundSet());
        dnaSequence = new DNASequence(genbankDNAReader);
        genbankDNAReader.getHeaderParser().parseHeader(genbankDNAReader.getHeader(), dnaSequence);
        System.out.println("Sequence(" + dnaSequence.getAccession() + "," + dnaSequence.getLength() + ")=" + dnaSequence.getSequenceAsString().substring(0, 10) + "...");
        System.out.println("Keywords" + genbankDNAReader.getKeyWords());
        System.out.println("DatabaseReferences" + genbankDNAReader.getDatabaseReferences());
        genbankDNAReader = new GenbankProxySequenceReader<NucleotideCompound>("/tmp", "GI:1293613", DNACompoundSet.getDNACompoundSet());
        dnaSequence = new DNASequence(genbankDNAReader);
        genbankDNAReader.getHeaderParser().parseHeader(genbankDNAReader.getHeader(), dnaSequence);
        System.out.println("Sequence(" + dnaSequence.getAccession() + "," + dnaSequence.getLength() + ")=" + dnaSequence.getSequenceAsString().substring(0, 10) + "...");
        System.out.println("Keywords" + genbankDNAReader.getKeyWords());
        System.out.println("DatabaseReferences" + genbankDNAReader.getDatabaseReferences());
        genbankDNAReader = new GenbankProxySequenceReader<NucleotideCompound>("/tmp", "14109166", DNACompoundSet.getDNACompoundSet());
        dnaSequence = new DNASequence(genbankDNAReader);
        genbankDNAReader.getHeaderParser().parseHeader(genbankDNAReader.getHeader(), dnaSequence);
        System.out.println("Sequence(" + dnaSequence.getAccession() + "," + dnaSequence.getLength() + ")=" + dnaSequence.getSequenceAsString().substring(0, 10) + "...");
        System.out.println("Keywords" + genbankDNAReader.getKeyWords());
        System.out.println("DatabaseReferences" + genbankDNAReader.getDatabaseReferences());
    }
}

