/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.io;

import java.util.ArrayList;
import org.biojava3.core.exceptions.ParserException;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.io.template.SequenceHeaderParserInterface;
import org.biojava3.core.sequence.template.AbstractSequence;
import org.biojava3.core.sequence.template.Compound;

public class GenericGenbankHeaderParser<S extends AbstractSequence<C>, C extends Compound>
implements SequenceHeaderParserInterface<S, C> {
    private String accession = null;
    private String identifier = null;
    private String name = null;
    private int version;
    private boolean versionSeen;
    private ArrayList<String> comments = new ArrayList();
    private String description;

    @Override
    public void parseHeader(String header, S sequence) {
        ((AbstractSequence)sequence).setOriginalHeader(header);
        ((AbstractSequence)sequence).setAccession(new AccessionID(this.accession));
        ((AbstractSequence)sequence).setDescription(this.description);
    }

    private void reset() {
        this.version = 0;
        this.versionSeen = false;
        this.accession = null;
        this.description = null;
        this.identifier = null;
        this.name = null;
        this.comments.clear();
    }

    public void setVersion(int version) throws ParserException {
        if (this.versionSeen) {
            throw new ParserException("Current BioEntry already has a version");
        }
        try {
            this.version = version;
            this.versionSeen = true;
        }
        catch (NumberFormatException e) {
            throw new ParserException("Could not parse version as an integer");
        }
    }

    public void setAccession(String accession) throws ParserException {
        if (accession == null) {
            throw new ParserException("Accession cannot be null");
        }
        this.accession = accession;
    }

    public void setDescription(String description) throws ParserException {
        if (this.description != null) {
            throw new ParserException("Current BioEntry already has a description");
        }
        this.description = description;
    }

    public void setIdentifier(String identifier) throws ParserException {
        if (identifier == null) {
            throw new ParserException("Identifier cannot be null");
        }
        if (this.identifier != null) {
            throw new ParserException("Current BioEntry already has a identifier");
        }
        this.identifier = identifier;
    }

    public void setName(String name) throws ParserException {
        if (name == null) {
            throw new ParserException("Name cannot be null");
        }
        if (this.name != null) {
            throw new ParserException("Current BioEntry already has a name");
        }
        this.name = name;
    }

    public void setComment(String comment) throws ParserException {
        if (comment == null) {
            throw new ParserException("Comment cannot be null");
        }
        this.comments.add(comment);
    }
}

