/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io;

import com.compomics.util.io.MonitorableInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class MonitorableFileInputStream
extends MonitorableInputStream {
    Logger logger = Logger.getLogger(MonitorableFileInputStream.class);
    private long iMaximum = 0L;
    private long iCurrent = 0L;
    private int iFactor = 0;

    public MonitorableFileInputStream(File aFile) throws IOException {
        super(new FileInputStream(aFile));
        long length = aFile.length();
        int factor = 0;
        long max = Integer.MAX_VALUE;
        while (length >= max) {
            length /= 1024L;
            ++factor;
        }
        this.iMaximum = aFile.length();
        this.iFactor = factor;
    }

    public MonitorableFileInputStream(String aFile) throws IOException {
        this(new File(aFile));
    }

    @Override
    public int getMaximum() {
        return (int)((double)this.iMaximum / Math.pow(1024.0, this.iFactor));
    }

    @Override
    public int monitorProgress() {
        int result = (int)((double)(this.iMaximum - (this.iMaximum - this.iCurrent)) / Math.pow(1024.0, this.iFactor));
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = super.read(b);
        this.iCurrent += (long)result;
        return result;
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        ++this.iCurrent;
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        this.iCurrent += (long)result;
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = super.skip(n);
        this.iCurrent += n;
        return result;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.iCurrent = 0L;
    }
}

