/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.renderers;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class AlignedTableCellRenderer
implements TableCellRenderer {
    private int align;
    private Color backgroundColor;

    public AlignedTableCellRenderer(int align) {
        this.align = align;
    }

    public AlignedTableCellRenderer(int align, Color background) {
        this.align = align;
        this.backgroundColor = background;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Color bg = label.getBackground();
        label.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
        if (this.backgroundColor != null && !isSelected) {
            label.setBackground(this.backgroundColor);
        }
        label.setHorizontalAlignment(this.align);
        return label;
    }
}

