/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.general;

import com.compomics.util.gui.JOptionEditorPane;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ExceptionHandler {
    private ArrayList<String> exceptionCaught = new ArrayList();
    private JFrame parent = null;
    private String toolIssuesPage;
    private boolean ignoreExceptions = false;

    public ExceptionHandler(JFrame parent, String toolIssuesPage) {
        this.parent = parent;
        this.toolIssuesPage = toolIssuesPage;
    }

    public ExceptionHandler() {
    }

    public void catchException(Exception e) {
        if (!this.ignoreExceptions && !this.exceptionCaught.contains(ExceptionHandler.getExceptionType(e))) {
            e.printStackTrace();
            this.exceptionCaught.add(ExceptionHandler.getExceptionType(e));
            if (this.parent != null) {
                if (ExceptionHandler.getExceptionType(e).equals("Protein not found")) {
                    JOptionPane.showMessageDialog(this.parent, JOptionEditorPane.getJOptionEditorPane(e.getLocalizedMessage() + "<br>" + "Please see the <a href=\"http://code.google.com/p/peptide-shaker/#Database_Help\">Database help page</a>.<br>" + "This message will appear only once."), "Error", 0);
                } else if (ExceptionHandler.getExceptionType(e).equals("Serialization")) {
                    if (this.toolIssuesPage != null) {
                        JOptionPane.showMessageDialog(this.parent, JOptionEditorPane.getJOptionEditorPane(e.getLocalizedMessage() + "<br>" + "Please <a href=\"" + this.toolIssuesPage + "\">contact the developers</a>.<br>" + "This message will appear only once."), "Error", 0);
                    } else {
                        JOptionPane.showMessageDialog(this.parent, JOptionEditorPane.getJOptionEditorPane(e.getLocalizedMessage() + "<br>" + "Please contact the developers.<br>" + "This message will appear only once."), "Error", 0);
                    }
                } else {
                    String error = "";
                    if (e.getLocalizedMessage() != null) {
                        error = e.getLocalizedMessage();
                    }
                    if (!error.endsWith(".")) {
                        error = error + ".";
                    }
                    if (this.toolIssuesPage != null) {
                        JOptionPane.showMessageDialog(this.parent, JOptionEditorPane.getJOptionEditorPane("An error occured: " + error + "<br>" + "If the problem persists, please <a href=\"" + this.toolIssuesPage + "\">contact the developers</a>."), "Error", 0);
                    } else {
                        JOptionPane.showMessageDialog(this.parent, JOptionEditorPane.getJOptionEditorPane("An error occured: " + error + "<br>" + "If the problem persists, please contact the developers."), "Error", 0);
                    }
                }
            }
        }
    }

    public static String getExceptionType(Exception e) {
        if (e.getLocalizedMessage() == null) {
            return "null pointer";
        }
        if (e.getLocalizedMessage().startsWith("Protein not found")) {
            return "Protein not found";
        }
        if (e.getLocalizedMessage().startsWith("Error while loading") || e.getLocalizedMessage().startsWith("Error while writing")) {
            return "Serialization";
        }
        return e.getLocalizedMessage();
    }

    public void setIgnoreExceptions(boolean ignoreExceptions) {
        this.ignoreExceptions = ignoreExceptions;
    }
}

