/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot;

import com.compomics.mascotdatfile.util.io.IndexElementExtension;
import com.compomics.mascotdatfile.util.io.XmlElementExtension;
import com.compomics.mascotdatfile.util.mascot.quantitation.Component;
import com.compomics.mascotdatfile.util.mascot.quantitation.Ratio;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import psidev.psi.tools.xxindex.StandardXpathAccess;
import psidev.psi.tools.xxindex.index.IndexElement;
import psidev.psi.tools.xxindex.index.StandardXpathIndex;
import psidev.psi.tools.xxindex.index.XmlXpathIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Quantitation {
    private static Logger logger = Logger.getLogger(Quantitation.class);
    private Component[] iComponents;
    private Ratio[] iRatios;
    private HashMap iMethod = new HashMap();
    private String iQuantitationType;

    public Quantitation(String s) {
        try {
            int i;
            File lFile = File.createTempFile("quant." + System.currentTimeMillis(), ".dat");
            FileOutputStream fos = new FileOutputStream(lFile);
            fos.write(s.getBytes());
            fos.flush();
            fos.close();
            StandardXpathAccess sxa = new StandardXpathAccess(lFile);
            ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
            StandardXpathIndex sxi = XmlXpathIndexer.buildIndex((InputStream)is);
            Vector<XmlElementExtension> lElementExtensions = this.getXmlElements(sxi, sxa, "/quantitation/method/component");
            this.iComponents = new Component[lElementExtensions.size()];
            for (i = 0; i < lElementExtensions.size(); ++i) {
                XmlElementExtension lComponentExtension = lElementExtensions.elementAt(i);
                String lName = lComponentExtension.getAttribute("name");
                Vector<XmlElementExtension> lMoverZ = lComponentExtension.getChildByTitle("moverz");
                XmlElementExtension lMoverZExtension = (XmlElementExtension)lMoverZ.get(0);
                double lAverage = Double.parseDouble(lMoverZExtension.getAttribute("average"));
                double lMonoIsotopic = Double.parseDouble(lMoverZExtension.getAttribute("monoisotopic"));
                this.iComponents[i] = new Component(lName, lAverage, lMonoIsotopic);
            }
            lElementExtensions = this.getXmlElements(sxi, sxa, "/quantitation/method/report_ratio");
            this.iRatios = new Ratio[lElementExtensions.size()];
            for (i = 0; i < lElementExtensions.size(); ++i) {
                XmlElementExtension lRatioExtension = lElementExtensions.elementAt(i);
                String lNumeratorName = null;
                Double lNumeratorCoeficient = 1.0;
                Component lNumeratorComponent = null;
                String lDenominatorName = null;
                Double lDenominatorCoeficient = 1.0;
                Component lDenominatorComponent = null;
                Vector<XmlElementExtension> lNumeratorExtension = lRatioExtension.getChildByTitle("numerator_component");
                XmlElementExtension lChild = lNumeratorExtension.elementAt(0);
                lNumeratorName = lChild.getAttribute("name");
                lNumeratorCoeficient = Double.parseDouble(lChild.getAttribute("coefficient"));
                Vector<XmlElementExtension> lDenominatorExtension = lRatioExtension.getChildByTitle("denominator_component");
                lChild = lDenominatorExtension.elementAt(0);
                lDenominatorName = lChild.getAttribute("name");
                lDenominatorCoeficient = Double.parseDouble(lChild.getAttribute("coefficient"));
                for (int j = 0; j < this.iComponents.length; ++j) {
                    Component lComponent = this.iComponents[j];
                    if (lComponent.getName().equals(lNumeratorName)) {
                        lNumeratorComponent = lComponent;
                        continue;
                    }
                    if (!lComponent.getName().equals(lDenominatorName)) continue;
                    lDenominatorComponent = lComponent;
                }
                this.iRatios[i] = new Ratio(lNumeratorComponent, lDenominatorComponent, lNumeratorCoeficient, lDenominatorCoeficient);
            }
            lElementExtensions = this.getXmlElements(sxi, sxa, "/quantitation/method");
            XmlElementExtension method = lElementExtensions.get(0);
            this.iMethod = method.getAttributes();
            this.iQuantitationType = (String)this.iMethod.get("name");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Component[] getComponents() {
        return this.iComponents;
    }

    public Ratio[] getRatios() {
        return this.iRatios;
    }

    public String getQuantitationType() {
        return this.iQuantitationType;
    }

    public Vector<XmlElementExtension> getXmlElements(StandardXpathIndex lIndex, StandardXpathAccess lAccess, String lXmlPath) throws IOException {
        List lIndexElements = lIndex.getElements(lXmlPath);
        Vector<IndexElementExtension> lRatioIndexedElements = new Vector<IndexElementExtension>();
        for (IndexElement element : lIndexElements) {
            lRatioIndexedElements.add(new IndexElementExtension(element, lXmlPath, lAccess));
        }
        Vector<XmlElementExtension> lElements = new Vector<XmlElementExtension>();
        for (int i = 0; i < lRatioIndexedElements.size(); ++i) {
            Vector<XmlElementExtension> tse = ((IndexElementExtension)lRatioIndexedElements.get(i)).getExtendedXmlElement();
            for (int x = 0; x < tse.size(); ++x) {
                lElements.add(tse.get(x));
            }
        }
        return lElements;
    }

    public String getMethodAttribute(String aAttributeName) {
        return (String)this.iMethod.get(aAttributeName);
    }
}

