### R code from vignette source 'sampleClassifier.Rnw'

###################################################
### code chunk number 1: style-Sweave
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: load_package
###################################################
library("sampleClassifier")
ls("package:sampleClassifier")


###################################################
### code chunk number 3: sampleClassifier.Rnw:171-173 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("sampleClassifier")


###################################################
### code chunk number 4: load_rnaseqdata
###################################################
library(sampleClassifierData)
data("se_rnaseq_refmat")
rnaseq_refmat <- assay(se_rnaseq_refmat)


###################################################
### code chunk number 5: load_microdata_1
###################################################
library(sampleClassifierData)
data("se_micro_refmat")
micro_refmat <- assay(se_micro_refmat)
dim(micro_refmat)


###################################################
### code chunk number 6: load_microdata_2
###################################################
data("se_micro_testmat")
micro_testmat <- assay(se_micro_testmat)
dim(micro_testmat)


###################################################
### code chunk number 7: options2
###################################################
options(width=60)


###################################################
### code chunk number 8: classify_microdata
###################################################
res1.list <- classifyProfile(ref_matrix=micro_refmat, query_mat=micro_testmat,
chip1="hgu133plus2",chip2="hgu133a", write2File=FALSE)


###################################################
### code chunk number 9: show_results_1
###################################################
lapply(res1.list,"[",c(1,2),,drop=FALSE)


###################################################
### code chunk number 10: sampleClassifier.Rnw:226-227
###################################################
names(res1.list) <- unlist(strsplit(names(res1.list),split= " : "))[seq(2,32,2)]


###################################################
### code chunk number 11: options3
###################################################
options(width=90)


###################################################
### code chunk number 12: heatmap
###################################################
get.heatmap(res1.list)


###################################################
### code chunk number 13: classify_microdata_svm
###################################################
res1.svm.df <- classifyProfile.svm(ref_matrix=micro_refmat, query_mat=micro_testmat,
chip1="hgu133plus2",chip2="hgu133a")
res1.svm.df


###################################################
### code chunk number 14: classify_rnaseq
###################################################
library(sampleClassifierData)
data("se_rnaseq_refmat")
rnaseq_refmat <- assay(se_rnaseq_refmat)
dim(rnaseq_refmat)


###################################################
### code chunk number 15: load_testrnaseq
###################################################
data("se_rnaseq_testmat")
rnaseq_testmat <- assay(se_rnaseq_testmat)
dim(rnaseq_testmat)


###################################################
### code chunk number 16: options4
###################################################
options(width=60)


###################################################
### code chunk number 17: classify_rnaseq2
###################################################
res2.list <- classifyProfile.rnaseq(ref_matrix=rnaseq_refmat, query_mat=rnaseq_testmat, 
gene.ids.type="ensembl",write2File=FALSE)


###################################################
### code chunk number 18: show_results2
###################################################
lapply(res2.list,"[",c(1,2),,drop=FALSE)


###################################################
### code chunk number 19: options3
###################################################
options(width=80)


###################################################
### code chunk number 20: heatmap2
###################################################
get.heatmap(res2.list)


###################################################
### code chunk number 21: show_results3
###################################################
res2.svm.df <- classifyProfile.rnaseq.svm(ref_matrix=rnaseq_refmat, query_mat=rnaseq_testmat, 
gene.ids.type="ensembl")
res2.svm.df


###################################################
### code chunk number 22: show_results4
###################################################
misclas.inds <- which(as.character(res2.svm.df[,1])!=as.character(res2.svm.df[,2]))
colnames(res2.svm.df) <- c("query_real_class","predicted_class_by_SVM")
pred.classifyProfile.rnaseq <- as.character(unlist(lapply(res2.list[which(names(res2.list) %in%
as.character(res2.svm.df[misclas.inds,1]))],"[",1,1,drop=TRUE)))
comp.df <- cbind(res2.svm.df[misclas.inds,],
predicted_by_classifyProfile.rnaseq=pred.classifyProfile.rnaseq)
comp.df


###################################################
### code chunk number 23: sessionInfo
###################################################
sessionInfo()


