/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.stat;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdevCal {
    public static Std calStd(ArrayList<Double> valList) {
        double totalCount = 0.0;
        double valSum = 0.0;
        for (Double d : valList) {
            if (d.isNaN()) continue;
            valSum += d.doubleValue();
            totalCount += 1.0;
        }
        double mean = valSum / totalCount;
        double sum = 0.0;
        for (Double d : valList) {
            if (d.isNaN()) continue;
            sum += Math.pow(d - mean, 2.0);
        }
        double stdev = Math.sqrt(sum / (totalCount - 1.0));
        Std stdResult = new Std(totalCount, mean, stdev);
        return stdResult;
    }

    public static void main(String[] args) {
        ArrayList<Double> valList = new ArrayList<Double>();
        valList.add(5.0);
        valList.add(12.0);
        valList.add(16.0);
        valList.add(21.0);
        valList.add(14.0);
        valList.add(15.0);
        Std result = StdevCal.calStd(valList);
        System.out.println("totalCount= " + result.totalCount + " mean= " + result.mean + " std=" + result.stdev);
    }

    public static class Std {
        private double totalCount;
        private double mean;
        private double stdev;

        Std(double t, double m, double s) {
            this.totalCount = t;
            this.mean = m;
            this.stdev = s;
        }

        public double getTotalCount() {
            return this.totalCount;
        }

        public double getMean() {
            return this.mean;
        }

        public double getStdev() {
            return this.stdev;
        }
    }
}

