/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.pairwise;

import edu.msu.cme.rdp.alignment.AlignmentMode;
import edu.msu.cme.rdp.alignment.pairwise.PairwiseAligner;
import edu.msu.cme.rdp.alignment.pairwise.PairwiseAlignment;
import edu.msu.cme.rdp.alignment.pairwise.ScoringMatrix;
import edu.msu.cme.rdp.alignment.pairwise.rna.DistanceModel;
import edu.msu.cme.rdp.alignment.pairwise.rna.IdentityDistanceModel;
import edu.msu.cme.rdp.readseq.SequenceType;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import edu.msu.cme.rdp.readseq.utils.IUBUtilities;
import edu.msu.cme.rdp.readseq.utils.SeqUtils;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairwiseKNN {
    private static <T> void insert(T n, List<T> list, Comparator<T> comp, int k) {
        list.add(n);
        for (int i = list.size(); i > 0 && comp.compare(list.get(i), list.get(i - 1)) > 0; --i) {
            Collections.swap(list, i, i - 1);
        }
        if (list.size() > k) {
            list.remove(k);
        }
    }

    public static List<Neighbor> getKNN(Sequence query, List<Sequence> dbSeqs, AlignmentMode mode, int k) {
        ArrayList<Neighbor> ret = new ArrayList<Neighbor>();
        Comparator<Neighbor> c = new Comparator<Neighbor>(){

            @Override
            public int compare(Neighbor t, Neighbor t1) {
                return t.alignment.getScore() - t1.alignment.getScore();
            }
        };
        SequenceType seqType = SeqUtils.guessSequenceType((Sequence)query);
        ScoringMatrix matrix = seqType == SequenceType.Nucleotide ? ScoringMatrix.getDefaultNuclMatrix() : ScoringMatrix.getDefaultProteinMatrix();
        matrix = ScoringMatrix.getDefaultProteinMatrix();
        for (Sequence dbSeq : dbSeqs) {
            Neighbor n = new Neighbor();
            n.dbSeq = dbSeq;
            PairwiseAlignment fwd = PairwiseAligner.align(dbSeq.getSeqString(), query.getSeqString(), matrix, mode);
            if (seqType == SequenceType.Nucleotide) {
                PairwiseAlignment rc = PairwiseAligner.align(dbSeq.getSeqString(), IUBUtilities.reverseComplement((String)query.getSeqString()), matrix, mode);
                if (rc.getScore() > fwd.getScore()) {
                    n.alignment = rc;
                    n.reverse = true;
                } else {
                    n.alignment = fwd;
                    n.reverse = false;
                }
            } else {
                n.alignment = fwd;
                n.reverse = false;
            }
            PairwiseKNN.insert(n, ret, c, k);
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        Sequence seq;
        List dbSeqs;
        SequenceReader queryReader;
        AlignmentMode mode = AlignmentMode.glocal;
        int k = 1;
        PrintStream out = new PrintStream(System.out);
        Options options = new Options();
        options.addOption("m", "mode", true, "Alignment mode {global, glocal, local, overlap, overlap_trimmed} (default= glocal)");
        options.addOption("k", true, "K-nearest neighbors to return");
        options.addOption("o", "out", true, "Redirect output to file instead of stdout");
        try {
            CommandLine line = new PosixParser().parse(options, args);
            if (line.hasOption("mode")) {
                mode = AlignmentMode.valueOf(line.getOptionValue("mode"));
            }
            if (line.hasOption('k')) {
                k = Integer.valueOf(line.getOptionValue('k'));
            }
            if (line.hasOption("out")) {
                out = new PrintStream(line.getOptionValue("out"));
            }
            if ((args = line.getArgs()).length != 2) {
                throw new Exception("Unexpected number of command line arguments");
            }
            queryReader = new SequenceReader(new File(args[0]));
            dbSeqs = SequenceReader.readFully((File)new File(args[1]));
        }
        catch (Exception e) {
            new HelpFormatter().printHelp("PairwiseKNN <options> <queryFile> <dbFile>", options);
            System.err.println("ERROR: " + e.getMessage());
            return;
        }
        IdentityDistanceModel dist = new IdentityDistanceModel();
        out.println("#query file: " + args[0] + " db file: " + args[1] + " k: " + k + " mode: " + (Object)((Object)mode));
        out.println("#seqname\tk\tref seqid\tref desc\torientation\tscore\tident\tquery start\tquery end\tquery length\tref start\tref end");
        while ((seq = queryReader.readNextSequence()) != null) {
            List<Neighbor> alignments = PairwiseKNN.getKNN(seq, dbSeqs, mode, k);
            for (int index = 0; index < alignments.size(); ++index) {
                Neighbor n = alignments.get(index);
                PairwiseAlignment alignment = n.alignment;
                double ident = 1.0 - ((DistanceModel)dist).getDistance(alignment.getAlignedSeqi().getBytes(), alignment.getAlignedSeqj().getBytes(), 0);
                out.println("@" + seq.getSeqName() + "\t" + (index + 1) + "\t" + n.dbSeq.getSeqName() + "\t" + n.dbSeq.getDesc() + "\t" + (n.reverse ? "-" : "+") + "\t" + alignment.getScore() + "\t" + ident + "\t" + alignment.getStartj() + "\t" + alignment.getEndj() + "\t" + seq.getSeqString().length() + "\t" + alignment.getStarti() + "\t" + alignment.getEndi());
                out.println(">" + alignment.getAlignedSeqj());
                out.println(">" + alignment.getAlignedSeqi());
            }
        }
    }

    public static class Neighbor {
        PairwiseAlignment alignment;
        boolean reverse;
        Sequence dbSeq;
    }
}

