/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment;

import edu.msu.cme.rdp.alignment.AlignmentMode;
import edu.msu.cme.rdp.alignment.pairwise.PairwiseAligner;
import edu.msu.cme.rdp.alignment.pairwise.PairwiseAlignment;
import edu.msu.cme.rdp.alignment.pairwise.ScoringMatrix;
import edu.msu.cme.rdp.readseq.readers.IndexedSeqReader;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import edu.msu.cme.rdp.readseq.utils.IUBUtilities;
import edu.msu.cme.rdp.readseq.writers.FastaWriter;
import java.io.File;
import java.io.IOException;
import java.util.Set;

public class PairedReadAssembler {
    private ScoringMatrix scoringMatrix;

    public PairedReadAssembler(ScoringMatrix scoringMatrix) {
        this.scoringMatrix = scoringMatrix;
    }

    public AssemblyResult assemble(Sequence left, Sequence right) {
        PairwiseAlignment align = PairwiseAligner.align(left.getSeqString(), IUBUtilities.reverseComplement((String)right.getSeqString()), this.scoringMatrix, AlignmentMode.overlap);
        char[] alignedLeft = align.getAlignedSeqi().toCharArray();
        char[] alignedRight = align.getAlignedSeqj().toCharArray();
        int overlapStart = -1;
        int overlapEnd = -1;
        int overlapErrors = 0;
        OverlapMode overlap = OverlapMode.left;
        StringBuilder assembledSeqStr = new StringBuilder();
        block4: for (int index = 0; index < alignedLeft.length; ++index) {
            if (alignedLeft[index] == '-' && overlapEnd == -1) {
                overlapEnd = index;
                overlap = OverlapMode.right;
            }
            if (alignedRight[index] != '-' && overlapStart == -1) {
                overlapStart = index;
                overlap = OverlapMode.overlap;
            }
            if (overlap == OverlapMode.overlap && alignedLeft[index] != alignedRight[index]) {
                ++overlapErrors;
                assembledSeqStr.append("N");
                continue;
            }
            switch (overlap) {
                case left: 
                case overlap: {
                    assembledSeqStr.append(alignedLeft[index]);
                    continue block4;
                }
                case right: {
                    assembledSeqStr.append(alignedRight[index]);
                }
            }
        }
        String assembledId = left.getSeqName();
        if (assembledId.contains(".")) {
            assembledId = assembledId.substring(0, assembledId.lastIndexOf("."));
        }
        return new AssemblyResult(new Sequence(assembledId, left.getDesc(), assembledSeqStr.toString()), overlapStart, overlapEnd, overlapErrors);
    }

    public static void main(String[] args) throws Exception {
        Sequence fseq;
        if (args.length != 5) {
            System.err.println("USAGE: PairedReadAssembler <fseq_file> <rseq_file> <min_ident> <min_overlap> <assembled_out_file>");
            return;
        }
        File fSeqFile = new File(args[0]);
        File rSeqFile = new File(args[1]);
        float maxError = 1.0f - Float.parseFloat(args[2]);
        int minOverlap = Integer.parseInt(args[3]);
        FastaWriter seqOut = new FastaWriter(new File(args[4]));
        PairedReadAssembler assembler = new PairedReadAssembler(ScoringMatrix.getDefaultNuclMatrix());
        SequenceReader fSeqReader = new SequenceReader(fSeqFile);
        IndexedSeqReader rSeqReader = new IndexedSeqReader(rSeqFile);
        Set rseqIds = rSeqReader.getSeqIdSet();
        System.out.println("fseq_id\trseq_id\tassembled_length\toverlap_start\toverlap_end\ttotal_overlap\tmismatches\terror_ratio\tassembled?");
        while ((fseq = fSeqReader.readNextSequence()) != null) {
            if (!rseqIds.contains(fseq.getSeqName())) {
                System.out.println(fseq.getSeqName() + "\tnot found in rseq file");
                continue;
            }
            Sequence rseq = rSeqReader.readSeq(fseq.getSeqName());
            if (!fseq.getSeqName().equals(rseq.getSeqName())) {
                throw new IOException("Read " + fseq.getSeqName() + " from fseq file and " + rseq.getSeqName() + " from rseq file, can't match sequences with different names");
            }
            AssemblyResult result = assembler.assemble(fseq, rseq);
            float errorRatio = (float)result.getOverlapErrors() / (float)result.getOverlap();
            boolean assembled = false;
            if (result.getOverlap() > minOverlap && errorRatio < maxError) {
                seqOut.writeSeq(result.getAssembledSeq());
                assembled = true;
            }
            System.out.println(fseq.getSeqName() + "\t" + result.getAssembledSeq().getSeqString().length() + "\t" + result.getOverlapStart() + "\t" + result.getOverlapEnd() + "\t" + result.getOverlap() + "\t" + result.getOverlapErrors() + "\t" + errorRatio + "\t" + assembled);
        }
        seqOut.close();
        fSeqReader.close();
        rSeqReader.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OverlapMode {
        left,
        overlap,
        right;

    }

    public static class AssemblyResult {
        private Sequence assembledSeq;
        private int overlapStart;
        private int overlapEnd;
        private int overlapErrors;

        public AssemblyResult(Sequence assembledSeq, int overlapStart, int overlapEnd, int overlapErrors) {
            this.assembledSeq = assembledSeq;
            this.overlapStart = overlapStart;
            this.overlapEnd = overlapEnd;
            this.overlapErrors = overlapErrors;
        }

        public Sequence getAssembledSeq() {
            return this.assembledSeq;
        }

        public int getOverlap() {
            return this.overlapEnd - this.overlapStart;
        }

        public int getOverlapEnd() {
            return this.overlapEnd;
        }

        public int getOverlapStart() {
            return this.overlapStart;
        }

        public int getOverlapErrors() {
            return this.overlapErrors;
        }
    }
}

