/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.unifrac;

import edu.msu.cme.rdp.multicompare.MCSample;
import edu.msu.cme.rdp.multicompare.taxon.MCTaxon;
import edu.msu.cme.rdp.unifrac.UnifracTreeBuilder;
import java.util.List;

public class UnifracTaxon
extends MCTaxon {
    private float bl;

    public UnifracTaxon(int taxid, String name, String rank, float bl) {
        this(taxid, name, rank, bl, false);
    }

    public UnifracTaxon(int taxid, String name, String rank, float bl, boolean unclassified) {
        super(taxid, name, rank, unclassified);
        this.bl = bl;
    }

    public UnifracTaxon(MCTaxon taxon, float bl) {
        this(taxon.getTaxid(), taxon.getName(), taxon.getRank(), bl);
        for (MCSample sample : taxon.getSamples()) {
            this.setSampleCount(sample, taxon.getCount(sample));
        }
    }

    public float getBl() {
        return this.bl;
    }

    public boolean containsSample(MCSample sample) {
        return this.sampleCountMap.containsKey(sample) && (Integer)this.sampleCountMap.get(sample) > 0;
    }

    public void resetSamples() {
        this.sampleCountMap.clear();
    }

    public void setSampleCount(MCSample sample, int count) {
        this.sampleCountMap.put(sample, count);
    }

    public void addSampleCount(MCSample sample, int count) {
        if (!this.sampleCountMap.containsKey(sample)) {
            this.sampleCountMap.put(sample, 0);
        }
        this.sampleCountMap.put(sample, (Integer)this.sampleCountMap.get(sample) + count);
    }

    public void resetSamples(List<UnifracTreeBuilder.UnifracSample> samplePool) {
        int sampleCount = this.sampleCountMap.size();
        this.resetSamples();
        for (int index = 0; index < sampleCount; ++index) {
            UnifracTreeBuilder.UnifracSample sample = samplePool.remove(0);
            this.addSampleCount(sample.sample, sample.count);
        }
    }
}

