/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train.validation.movingwindow;

import edu.msu.cme.rdp.classifier.train.LineageSequence;
import edu.msu.cme.rdp.classifier.train.validation.CorrectAssignment;
import edu.msu.cme.rdp.classifier.train.validation.DecisionMaker;
import edu.msu.cme.rdp.classifier.train.validation.HierarchyTree;
import edu.msu.cme.rdp.classifier.train.validation.TreeFactory;
import edu.msu.cme.rdp.classifier.train.validation.ValidClassificationResultFacade;
import edu.msu.cme.rdp.classifier.train.validation.ValidationClassificationResult;
import edu.msu.cme.rdp.classifier.train.validation.movingwindow.MainMovingWindow;
import edu.msu.cme.rdp.classifier.train.validation.movingwindow.Window;
import edu.msu.cme.rdp.readseq.utils.orientation.GoodWordIterator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WindowTester {
    BufferedWriter outFile;
    private boolean bootstrap = true;
    private int windowIndex = 0;
    private String testRank = "GENUS";
    private Map num_hierLevel = new HashMap();
    List missSeqList = new ArrayList();

    public WindowTester(Writer writer) throws IOException {
        this.outFile = (BufferedWriter)writer;
    }

    public void classify(TreeFactory factory, ArrayList seqList, Window window, int windowIndex, int min_bootstrap_words) throws IOException {
        this.windowIndex = windowIndex;
        ArrayList<ValidClassificationResultFacade> resultList = new ArrayList<ValidClassificationResultFacade>();
        DecisionMaker dm = new DecisionMaker(factory);
        HierarchyTree root = factory.getRoot();
        HashMap<String, HierarchyTree> genusNodeMap = new HashMap<String, HierarchyTree>();
        factory.getRoot().getNodeMap(this.testRank, genusNodeMap);
        if (genusNodeMap.isEmpty()) {
            throw new IllegalArgumentException("\nThere is no node in GENUS level!");
        }
        int i = 0;
        for (LineageSequence pSeq : seqList) {
            GoodWordIterator wordIterator = this.getPartialSeqIteratorbyWindow(pSeq, window);
            if (wordIterator == null) continue;
            HierarchyTree curTree = genusNodeMap.get(pSeq.getAncestors().get(pSeq.getAncestors().size() - 1));
            curTree.hideSeq(wordIterator);
            List<ValidationClassificationResult> result = dm.getBestClasspath(wordIterator, genusNodeMap, false, min_bootstrap_words);
            ValidClassificationResultFacade resultFacade = new ValidClassificationResultFacade(pSeq, result);
            resultFacade.setLabeledNode(curTree);
            this.compareClassificationResult(resultFacade);
            resultList.add(resultFacade);
            ++i;
            curTree.unhideSeq(wordIterator);
        }
        this.displayStat();
    }

    private GoodWordIterator getPartialSeqIteratorbyWindow(LineageSequence pSeq, Window w) throws IOException {
        int firstbase = this.findFirstBase(pSeq.getSeqString());
        int lastbase = this.findLastBase(pSeq.getSeqString());
        if (firstbase > w.getStart() || lastbase < w.getStop()) {
            return null;
        }
        int stop = w.getStop();
        if (stop > pSeq.getSeqString().length()) {
            stop = pSeq.getSeqString().length();
        }
        String seqString = pSeq.getSeqString().substring(w.getStart() - 1, stop);
        if ((seqString = seqString.replaceAll("-", "")).length() < 100) {
            return null;
        }
        GoodWordIterator wordIterator = new GoodWordIterator(seqString);
        if (wordIterator.getNumofWords() == 0) {
            wordIterator = null;
        }
        return wordIterator;
    }

    private int findFirstBase(String s) throws IOException {
        int c;
        StringReader reader = new StringReader(s);
        int index = 1;
        while ((c = reader.read()) != -1) {
            char ch = (char)c;
            if (ch != '-') {
                return index;
            }
            ++index;
        }
        reader.close();
        return -1;
    }

    private int findLastBase(String s) throws IOException {
        int c;
        StringReader reader = new StringReader(s);
        int index = 1;
        int lastBase = 0;
        while ((c = reader.read()) != -1) {
            char ch = (char)c;
            if (ch != '-') {
                lastBase = index;
            }
            ++index;
        }
        reader.close();
        return lastBase;
    }

    public void displayTreeErrorRate(HierarchyTree root, int indent) throws IOException {
        for (int k = 0; k < indent; ++k) {
            this.outFile.write("  ");
        }
        this.outFile.write(root.getName() + "\t" + root.getTotalSeqs() + "\t" + root.getMissCount() + "\n");
        Iterator<HierarchyTree> i = root.getSubclasses().iterator();
        while (i.hasNext()) {
            this.displayTreeErrorRate(i.next(), indent + 1);
        }
    }

    private void displayResult(List seqs, List aPath) throws IOException {
        int i = 0;
        int size1 = seqs.size();
        for (i = 0; i < size1; ++i) {
            this.outFile.write((String)seqs.get(i) + "*");
            int size = ((List)aPath.get(i)).size();
            if (size == 0) {
                this.outFile.write("\n");
                continue;
            }
            ValidationClassificationResult result = (ValidationClassificationResult)((List)aPath.get(i)).get(size - 1);
            this.outFile.write(result.getBestClass().getTaxonomy().getTaxID() + "\n");
        }
    }

    private void displayClassification(List seqs) throws IOException {
        CorrectAssignment assign;
        int i = 0;
        this.outFile.write("\n missclassified getSequence()s: \n");
        for (i = 0; i < seqs.size(); ++i) {
            ValidClassificationResultFacade resultFacade = (ValidClassificationResultFacade)seqs.get(i);
            if (!resultFacade.isMissed()) continue;
            this.printPath(resultFacade, this.outFile);
        }
        DecimalFormat df = new DecimalFormat("0.###");
        this.outFile.write("\n\n**The statistics for each hierarchy level: \n 1: number of correct assigned getSequence()s / number of total getSequence()s for that bin rage\n");
        this.outFile.write("Level\t100-95\t\t94-90");
        for (i = 9; i > 0; --i) {
            this.outFile.write("\t\t" + (i * 10 - 1) + "-" + (i - 1) * 10);
        }
        this.outFile.write("\n");
        System.err.print("\t");
        for (String name : this.num_hierLevel.keySet()) {
            this.outFile.write(name + "\t");
            if (!(this.windowIndex != MainMovingWindow.getBeginIndex() || name.equals("domain") || name.equals("norank") || name.startsWith("sub"))) {
                System.err.print(name + "\t");
            }
            assign = (CorrectAssignment)this.num_hierLevel.get(name);
            this.calStandardError(assign);
            for (i = assign.bins - 1; i >= 0; --i) {
                this.outFile.write(assign.numCorrect[i] + "\t" + assign.numTotal[i] + "\t");
            }
            this.outFile.write("\n");
        }
        this.outFile.write("\n\n** 2. The average votes for each bin range \n");
        for (String name : this.num_hierLevel.keySet()) {
            this.outFile.write(name + " \t ");
            assign = (CorrectAssignment)this.num_hierLevel.get(name);
            for (i = assign.bins - 1; i >= 0; --i) {
                if (assign.numTotal[i] == 0) {
                    this.outFile.write("0\t");
                    continue;
                }
                this.outFile.write(df.format(assign.sumOfVotes[i] * 100.0f / (float)assign.numTotal[i]) + "\t");
            }
            this.outFile.write(" \n");
        }
        this.outFile.write("\n\n** 3. The percentage of correctness for each bin range (the percentage of #1)\n");
        for (String name : this.num_hierLevel.keySet()) {
            this.outFile.write(name + " \t ");
            assign = (CorrectAssignment)this.num_hierLevel.get(name);
            for (i = assign.bins - 1; i >= 0; --i) {
                if (assign.numTotal[i] == 0) {
                    this.outFile.write("0\t");
                    continue;
                }
                this.outFile.write(df.format((float)assign.numCorrect[i] / (float)assign.numTotal[i]) + "\t");
            }
            this.outFile.write(" \n");
        }
        this.outFile.write("\n\n** 4. The standard error for each bin range \n");
        for (String name : this.num_hierLevel.keySet()) {
            this.outFile.write(name + " \t ");
            assign = (CorrectAssignment)this.num_hierLevel.get(name);
            for (i = assign.bins - 1; i >= 0; --i) {
                this.outFile.write(df.format(assign.standardError[i]) + "\t");
            }
            this.outFile.write(" \n");
        }
    }

    private void displayStat() throws IOException {
        CorrectAssignment assign;
        this.outFile.write("\t");
        for (String name : this.num_hierLevel.keySet()) {
            if (!(this.windowIndex != MainMovingWindow.getBeginIndex() || name.equals("domain") || name.equals("norank") || name.startsWith("sub"))) {
                this.outFile.write(name + "\t");
            }
            assign = (CorrectAssignment)this.num_hierLevel.get(name);
            this.calStandardError(assign);
        }
        this.outFile.write("\n");
        this.outFile.write("V\t" + this.windowIndex);
        for (String name : this.num_hierLevel.keySet()) {
            if (name.equals("domain") || name.equals("norank") || name.startsWith("sub")) continue;
            assign = (CorrectAssignment)this.num_hierLevel.get(name);
            this.outFile.write("\t" + this.getAvgVotes(assign));
        }
        this.outFile.write("\nC\t" + this.windowIndex);
        for (String name : this.num_hierLevel.keySet()) {
            if (name.equals("domain") || name.equals("norank") || name.startsWith("sub")) continue;
            assign = (CorrectAssignment)this.num_hierLevel.get(name);
            this.outFile.write("\t" + this.getCorrectRate(assign));
        }
    }

    private void printPath(ValidClassificationResultFacade resultFacade, BufferedWriter out) throws IOException {
        out.write("SEQ: " + resultFacade.getSeqName() + "\n");
        Iterator<Object> i = resultFacade.getAncestors().iterator();
        while (i.hasNext()) {
            out.write(i.next() + "\t");
        }
        out.write("\n");
        for (ValidationClassificationResult result : resultFacade.getRankAssignment()) {
            out.write(result.getBestClass().getName() + "\t");
        }
        out.write("\n");
        i = resultFacade.getRankAssignment().iterator();
        while (i.hasNext()) {
            out.write(((ValidationClassificationResult)i.next()).getNumOfVotes() + "\t");
        }
        out.write("\n");
    }

    private void compareClassificationResult(ValidClassificationResultFacade resultFacade) {
        List<ValidationClassificationResult> hitList = resultFacade.getRankAssignment();
        for (HierarchyTree trueParent = resultFacade.getLabeledNode(); trueParent != null; trueParent = trueParent.getParent()) {
            if (trueParent.isSingleton()) continue;
            ValidationClassificationResult hit = null;
            for (int i = 0; i < hitList.size(); ++i) {
                ValidationClassificationResult tmp = hitList.get(i);
                if (!trueParent.getTaxonomy().getHierLevel().equals(tmp.getBestClass().getTaxonomy().getHierLevel())) continue;
                hit = tmp;
                break;
            }
            if (trueParent.getTaxonomy().getHierLevel().equals(this.testRank)) {
                trueParent.incNumTotalTestedseq();
            }
            boolean correct = false;
            if (hit != null && trueParent.getTaxonomy().getTaxID() == hit.getBestClass().getTaxonomy().getTaxID()) {
                correct = true;
            } else {
                if (trueParent.getTaxonomy().getHierLevel().equals(this.testRank)) {
                    trueParent.incMissCount();
                }
                resultFacade.setMissedRank(trueParent.getTaxonomy().getHierLevel());
            }
            if (hit == null) continue;
            this.increaseCount(hit, trueParent.getTaxonomy().getHierLevel(), correct, this.num_hierLevel);
        }
    }

    private void increaseCount(ValidationClassificationResult aResult, String level, boolean correct, Map aMap) {
        int binIndex;
        CorrectAssignment assign = (CorrectAssignment)aMap.get(level);
        if (assign == null) {
            assign = new CorrectAssignment();
            aMap.put(level, assign);
        }
        if ((binIndex = (int)Math.floor(aResult.getNumOfVotes() * 10.0f)) == 9 && (double)aResult.getNumOfVotes() >= 0.95) {
            binIndex = 10;
        }
        int n = binIndex;
        assign.numTotal[n] = assign.numTotal[n] + 1;
        int n2 = binIndex;
        assign.sumOfVotes[n2] = assign.sumOfVotes[n2] + aResult.getNumOfVotes();
        if (correct) {
            int n3 = binIndex;
            assign.numCorrect[n3] = assign.numCorrect[n3] + 1;
        }
    }

    private void calStandardError(CorrectAssignment assign) {
        for (int i = 0; i < assign.bins; ++i) {
            if (assign.numTotal[i] == 0) {
                assign.standardError[i] = 0.0f;
                continue;
            }
            float p = (float)assign.numCorrect[i] / (float)assign.numTotal[i];
            assign.standardError[i] = (float)Math.sqrt(p * (1.0f - p) / (float)assign.numTotal[i]);
        }
    }

    private float getCorrectRate(CorrectAssignment assign) {
        int total = 0;
        int numCorrect = 0;
        for (int i = assign.bins - 1; i >= 0; --i) {
            total += assign.numTotal[i];
            numCorrect += assign.numCorrect[i];
        }
        float retval = 0.0f;
        if (total > 0) {
            retval = (float)numCorrect / (float)total;
        }
        return retval;
    }

    private float getAvgVotes(CorrectAssignment assign) {
        int totalNumOfSeq = 0;
        float sumOfVotes = 0.0f;
        for (int i = 0; i < assign.bins; ++i) {
            totalNumOfSeq += assign.numTotal[i];
            sumOfVotes += assign.sumOfVotes[i];
        }
        float avg = 0.0f;
        if (totalNumOfSeq > 0) {
            avg = sumOfVotes / (float)totalNumOfSeq;
        }
        return avg;
    }
}

