/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.io;

import edu.msu.cme.rdp.classifier.HierarchyTree;
import edu.msu.cme.rdp.classifier.TrainingDataException;
import edu.msu.cme.rdp.classifier.utils.HierarchyVersion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TreeFileParser
extends DefaultHandler {
    private Stack treeNodeStack = new Stack();
    private HierarchyTree root;

    public HierarchyTree createTree(Reader in, HierarchyVersion version) throws IOException, TrainingDataException {
        BufferedReader infile = new BufferedReader(in);
        String line = infile.readLine();
        if (line != null) {
            HierarchyVersion thisVersion = new HierarchyVersion(line);
            int trainsetNo = thisVersion.getTrainsetNo();
            if (thisVersion.getVersion() == null) {
                throw new TrainingDataException("Error: There is no version information in the bergeyTree file");
            }
            if (version == null) {
                version = thisVersion;
            } else if (!version.getVersion().equals(thisVersion.getVersion()) || version.getTrainsetNo() != thisVersion.getTrainsetNo()) {
                throw new TrainingDataException("Error: The version information in the bergeyTree file is different from the version of the other training files.");
            }
        }
        while ((line = infile.readLine()) != null) {
            this.load(line);
        }
        infile.close();
        return this.root;
    }

    private void load(String document) throws TrainingDataException, IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new InputSource(new StringReader(document)), (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new TrainingDataException(e);
        }
        catch (SAXException e) {
            throw new TrainingDataException(e);
        }
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        try {
            if (attrs == null || attrs.getLength() != 6) {
                throw new TrainingDataException("Error: the attribute for element: " + qName + " is missing or do not have exactly 6 attributes");
            }
            int taxid = Integer.parseInt(attrs.getValue(1));
            int parentTaxid = Integer.parseInt(attrs.getValue(3));
            int leaveCount = Integer.parseInt(attrs.getValue(4));
            int genusIndex = Integer.parseInt(attrs.getValue(5));
            HierarchyTree aTree = new HierarchyTree(attrs.getValue(0), taxid, attrs.getValue(2), leaveCount, genusIndex);
            if (this.root == null) {
                aTree.addParent(null);
                this.root = aTree;
            } else {
                HierarchyTree parent = null;
                while (!this.treeNodeStack.empty()) {
                    HierarchyTree topNode = (HierarchyTree)this.treeNodeStack.peek();
                    if (topNode.getTaxid() == parentTaxid) {
                        parent = topNode;
                        break;
                    }
                    this.treeNodeStack.pop();
                }
                if (parent == null) {
                    throw new TrainingDataException("Error: The parent for treenode name=: " + attrs.getValue(0) + " rank=" + attrs.getValue(2) + " parentTaxid=" + parentTaxid + " can not be found in the input file");
                }
                aTree.addParent(parent);
            }
            if (genusIndex == -1) {
                this.treeNodeStack.push(aTree);
            }
        }
        catch (TrainingDataException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String str, String str1, String str2) throws SAXException {
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw new SAXException(e);
    }
}

