/*
 * Decompiled with CFR 0.152.
 */
package cn.bgi;

import cn.bgi.ProteinGroup;
import cn.bgi.TableHeader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

public class CombineRun {
    public static void main(String[] args) throws IOException {
        String file = args[0];
        String fasta = args[1];
        String logfileString = args[2];
        String outdir = args[3];
        String prefix = args[4];
        String[] files = file.split(";");
        CombineRun.combine(files, fasta, logfileString, outdir, prefix);
    }

    public static void combine(String[] files, String fasta, String logfileString, String outdir, String prefix) throws IOException {
        String outPsmFileString = String.valueOf(outdir) + "/" + prefix + "-peptideSummary.txt";
        BufferedWriter bWriter = new BufferedWriter(new FileWriter(new File(outPsmFileString)));
        boolean isHeadReader = false;
        int sumIdentPSMs = 0;
        HashSet<String> uniquePeptideSet = new HashSet<String>();
        HashMap<String, Integer> header2indexHashMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < files.length) {
            String line;
            BufferedReader bReader = new BufferedReader(new FileReader(new File(files[i])));
            if (!isHeadReader) {
                String headlineString = bReader.readLine();
                isHeadReader = true;
                bWriter.write(String.valueOf(headlineString) + "\n");
                String[] header = headlineString.trim().split("\t");
                int j = 0;
                while (j < header.length) {
                    header2indexHashMap.put(header[j], j);
                    ++j;
                }
            } else {
                bReader.readLine();
            }
            while ((line = bReader.readLine()) != null) {
                bWriter.write(String.valueOf(line) + "\n");
                String[] items = line.trim().split("\t");
                String pepSeq = items[(Integer)header2indexHashMap.get(TableHeader.peptideSeq)];
                uniquePeptideSet.add(pepSeq);
                ++sumIdentPSMs;
            }
            bReader.close();
            ++i;
        }
        bWriter.close();
        String outProtienFile = String.valueOf(outdir) + "/" + prefix + "-proteinSummary.txt";
        ProteinGroup.proteinGrouper(outPsmFileString, outProtienFile, fasta);
        int sumIdentProteins = ProteinGroup.getSumIdentProteins();
        int sumIdentPeptides = uniquePeptideSet.size();
        BufferedWriter bW = new BufferedWriter(new FileWriter(new File(logfileString)));
        bW.write("spectrum\tpeptide\tprotein\tpeptide_summary\tprotein_summary\n");
        bW.write(String.valueOf(sumIdentPSMs) + "\t" + sumIdentPeptides + "\t" + sumIdentProteins + "\t" + outPsmFileString + "\t" + outProtienFile + "\n");
        bW.close();
    }
}

