/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.xtandemparser.xtandem;

import de.proteinms.xtandemparser.xtandem.Domain;
import de.proteinms.xtandemparser.xtandem.Peptide;
import de.proteinms.xtandemparser.xtandem.ProteinMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class PeptideMap
implements Serializable {
    private HashMap<String, HashMap<String, Peptide>> iSpectrumAndPeptideMap = null;

    public PeptideMap(HashMap aRawPeptideMap, ProteinMap aProteinMap, int aNumberOfSpectra) {
        this.buildPeptideMap(aRawPeptideMap, aProteinMap, aNumberOfSpectra);
    }

    private HashMap buildPeptideMap(HashMap aRawPeptideMap, ProteinMap aProteinMap, int aNumberOfSpectra) {
        this.iSpectrumAndPeptideMap = new HashMap(aNumberOfSpectra);
        if (aRawPeptideMap != null) {
            for (int i = 1; i <= aNumberOfSpectra; ++i) {
                HashMap<String, Peptide> lPeptideMap = new HashMap<String, Peptide>();
                int pCount = 1;
                while (aRawPeptideMap.get("s" + i + "_p" + pCount) != null) {
                    String peptideID = "s" + i + "_p" + pCount;
                    int peptideStart = Integer.parseInt(aRawPeptideMap.get("start_s" + i + "_p" + pCount).toString());
                    int peptideEnd = Integer.parseInt(aRawPeptideMap.get("end_s" + i + "_p" + pCount).toString());
                    String sequence = aRawPeptideMap.get("seq_s" + i + "_p" + pCount).toString().trim();
                    Peptide peptide = new Peptide(peptideID, peptideStart, peptideEnd, sequence);
                    peptide.setSpectrumNumber(i);
                    if (aRawPeptideMap.get("URL_s" + i + "_p" + pCount) != null) {
                        peptide.setFastaFilePath(aRawPeptideMap.get("URL_s" + i + "_p" + pCount).toString());
                    }
                    int dCount = 1;
                    ArrayList<Domain> domainList = new ArrayList<Domain>();
                    while (aRawPeptideMap.get("domainid_s" + i + "_p" + pCount + "_d" + dCount) != null) {
                        Domain domain = new Domain();
                        String domainKey = "s" + i + "_p" + pCount + "_d" + dCount;
                        domain.setDomainKey(domainKey);
                        domain.setProteinKey(aRawPeptideMap.get("proteinkey_s" + i + "_p" + pCount + "_d" + dCount).toString());
                        domain.setDomainID(aRawPeptideMap.get("domainid_s" + i + "_p" + pCount + "_d" + dCount).toString());
                        domain.setDomainStart(Integer.parseInt(aRawPeptideMap.get("domainstart_s" + i + "_p" + pCount + "_d" + dCount).toString()));
                        domain.setDomainEnd(Integer.parseInt(aRawPeptideMap.get("domainend_s" + i + "_p" + pCount + "_d" + dCount).toString()));
                        domain.setDomainExpect(Double.parseDouble(aRawPeptideMap.get("expect_s" + i + "_p" + pCount + "_d" + dCount).toString()));
                        domain.setDomainMh(Double.parseDouble(aRawPeptideMap.get("mh_s" + i + "_p" + pCount + "_d" + dCount).toString()));
                        domain.setDomainDeltaMh(Double.parseDouble(aRawPeptideMap.get("delta_s" + i + "_p" + pCount + "_d" + dCount).toString()));
                        domain.setDomainHyperScore(Double.parseDouble(aRawPeptideMap.get("hyperscore_s" + i + "_p" + pCount + "_d" + dCount).toString()));
                        domain.setDomainNextScore(Double.parseDouble(aRawPeptideMap.get("nextscore_s" + i + "_p" + pCount + "_d" + dCount).toString()));
                        domain.setUpFlankSequence(aRawPeptideMap.get("pre_s" + i + "_p" + pCount + "_d" + dCount).toString());
                        domain.setDownFlankSequence(aRawPeptideMap.get("post_s" + i + "_p" + pCount + "_d" + dCount).toString());
                        domain.setDomainSequence(aRawPeptideMap.get("domainseq_s" + i + "_p" + pCount + "_d" + dCount).toString());
                        domain.setMissedCleavages(Integer.parseInt(aRawPeptideMap.get("missed_cleavages_s" + i + "_p" + pCount + "_d" + dCount).toString()));
                        domainList.add(domain);
                        ++dCount;
                    }
                    peptide.setDomains(domainList);
                    lPeptideMap.put(peptideID, peptide);
                    ++pCount;
                }
                this.iSpectrumAndPeptideMap.put("s" + i, lPeptideMap);
            }
        }
        return this.iSpectrumAndPeptideMap;
    }

    public HashMap<String, HashMap<String, Peptide>> getSpectrumAndPeptideMap() {
        return this.iSpectrumAndPeptideMap;
    }

    public ArrayList<Peptide> getAllPeptides(int aSpectrumNumber) {
        ArrayList<Peptide> arrayList = new ArrayList<Peptide>();
        if (this.iSpectrumAndPeptideMap.get("s" + aSpectrumNumber) != null) {
            arrayList = new ArrayList<Peptide>(this.iSpectrumAndPeptideMap.get("s" + aSpectrumNumber).values());
        }
        return arrayList;
    }

    public Peptide getPeptideByIndex(int aSpectrumNumber, int index) {
        return this.iSpectrumAndPeptideMap.get("s" + aSpectrumNumber).get("s" + aSpectrumNumber + "_p" + index);
    }

    public int getNumberOfPeptides(int aSpectrumNumber) {
        return this.iSpectrumAndPeptideMap.get("s" + aSpectrumNumber).size();
    }
}

